/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import tech.tablesaw.io.RuntimeIOException;

public class Destination {
    protected final OutputStream stream;
    protected final Writer writer;

    public Destination(File file) {
        try {
            this.stream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        this.writer = null;
    }

    public Destination(Writer writer) {
        this.stream = null;
        this.writer = writer;
    }

    public Destination(OutputStream stream) {
        this.stream = stream;
        this.writer = null;
    }

    public OutputStream stream() {
        return this.stream;
    }

    public Writer writer() {
        return this.writer;
    }

    public Writer createWriter() {
        return this.writer != null ? this.writer : new OutputStreamWriter(this.stream);
    }
}

