/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.errorprone.BugPattern;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import tech.picnic.errorprone.refaster.AutoValue_AnnotatedCompositeCodeTransformer;
import tech.picnic.errorprone.refaster.annotation.Description;
import tech.picnic.errorprone.refaster.annotation.OnlineDocumentation;
import tech.picnic.errorprone.refaster.annotation.Severity;

@AutoValue
public abstract class AnnotatedCompositeCodeTransformer
implements CodeTransformer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Splitter CLASS_NAME_SPLITTER = Splitter.on((char)'.').limit(2);

    AnnotatedCompositeCodeTransformer() {
    }

    abstract String packageName();

    abstract ImmutableList<CodeTransformer> transformers();

    public abstract ImmutableClassToInstanceMap<Annotation> annotations();

    public static AnnotatedCompositeCodeTransformer create(String packageName, ImmutableList<CodeTransformer> transformers, ImmutableClassToInstanceMap<Annotation> annotations) {
        return new AutoValue_AnnotatedCompositeCodeTransformer(packageName, transformers, annotations);
    }

    public final void apply(TreePath path, Context context, DescriptionListener listener) {
        for (CodeTransformer transformer : this.transformers()) {
            transformer.apply(path, context, description -> listener.onDescribed(this.augmentDescription(description, transformer, context)));
        }
    }

    private com.google.errorprone.matchers.Description augmentDescription(com.google.errorprone.matchers.Description description, CodeTransformer delegate, Context context) {
        String shortCheckName = this.getShortCheckName(description.checkName);
        return com.google.errorprone.matchers.Description.builder((JCDiagnostic.DiagnosticPosition)description.position, (String)shortCheckName, (String)this.getLinkPattern(delegate, shortCheckName).orElse(null), (String)this.getDescription(delegate)).overrideSeverity(AnnotatedCompositeCodeTransformer.overrideSeverity(this.getSeverity(delegate), context)).addAllFixes((List)description.fixes).build();
    }

    private String getShortCheckName(String fullCheckName) {
        String packageName = this.packageName();
        if (packageName.isEmpty()) {
            return fullCheckName;
        }
        String prefix = packageName + ".";
        Preconditions.checkState((boolean)fullCheckName.startsWith(prefix), (String)"Refaster rule class '%s' is not located in package '%s'", (Object)fullCheckName, (Object)packageName);
        return fullCheckName.substring(prefix.length());
    }

    private Optional<String> getLinkPattern(CodeTransformer delegate, String checkName) {
        Iterator nameComponents = CLASS_NAME_SPLITTER.splitToStream((CharSequence)checkName).iterator();
        return this.getAnnotationValue(OnlineDocumentation.class, OnlineDocumentation::value, delegate).map(url -> url.replace("${topLevelClassName}", (CharSequence)nameComponents.next())).map(url -> url.replace("${nestedClassName}", (CharSequence)Iterators.getNext((Iterator)nameComponents, (Object)"")));
    }

    private BugPattern.SeverityLevel getSeverity(CodeTransformer delegate) {
        return this.getAnnotationValue(Severity.class, Severity::value, delegate).orElse(BugPattern.SeverityLevel.SUGGESTION);
    }

    private String getDescription(CodeTransformer delegate) {
        return this.getAnnotationValue(Description.class, Description::value, delegate).orElse("Refactoring opportunity");
    }

    private <A extends Annotation, T> Optional<T> getAnnotationValue(Class<A> annotation, Function<A, T> extractor, CodeTransformer delegate) {
        return AnnotatedCompositeCodeTransformer.getAnnotationValue(delegate, annotation).or(() -> AnnotatedCompositeCodeTransformer.getAnnotationValue(this, annotation)).map(extractor);
    }

    private static <A extends Annotation> Optional<A> getAnnotationValue(CodeTransformer codeTransformer, Class<A> annotation) {
        return Optional.ofNullable((Annotation)codeTransformer.annotations().getInstance(annotation));
    }

    private static BugPattern.SeverityLevel overrideSeverity(BugPattern.SeverityLevel severity, Context context) {
        ErrorProneOptions options = context.get(ErrorProneOptions.class);
        BugPattern.SeverityLevel minSeverity = options.isSuggestionsAsWarnings() ? BugPattern.SeverityLevel.WARNING : BugPattern.SeverityLevel.SUGGESTION;
        BugPattern.SeverityLevel maxSeverity = options.isDropErrorsToWarnings() ? BugPattern.SeverityLevel.WARNING : BugPattern.SeverityLevel.ERROR;
        return (BugPattern.SeverityLevel)Comparators.max((Comparable)((BugPattern.SeverityLevel)Comparators.min((Comparable)severity, (Comparable)minSeverity)), (Comparable)maxSeverity);
    }
}

