/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class MoreTypes {
    private MoreTypes() {
    }

    public static Supplier<Type> type(String typeName) {
        return Suppliers.typeFromString((String)typeName);
    }

    @SafeVarargs
    public static Supplier<Type> generic(Supplier<Type> type, Supplier<Type> ... typeArgs) {
        return MoreTypes.propagateNull(type, (state, baseType) -> {
            List params = Arrays.stream(typeArgs).map(s -> (Type)s.get(state)).collect(Collectors.toCollection(ArrayList::new));
            if (params.stream().anyMatch(Objects::isNull)) {
                return null;
            }
            return state.getType(baseType, false, params);
        });
    }

    public static Supplier<Type> raw(Supplier<Type> type) {
        return MoreTypes.propagateNull(type, (state, baseType) -> baseType.tsym.erasure(state.getTypes()));
    }

    public static Supplier<Type> superOf(Supplier<Type> type) {
        return MoreTypes.propagateNull(type, (state, baseType) -> new Type.WildcardType((Type)baseType, BoundKind.SUPER, state.getSymtab().boundClass));
    }

    public static Supplier<Type> subOf(Supplier<Type> type) {
        return MoreTypes.propagateNull(type, (state, baseType) -> new Type.WildcardType((Type)type.get(state), BoundKind.EXTENDS, state.getSymtab().boundClass));
    }

    public static Supplier<Type> unbound() {
        return (Supplier & Serializable)state -> new Type.WildcardType(state.getSymtab().objectType, BoundKind.UNBOUND, state.getSymtab().boundClass);
    }

    private static Supplier<Type> propagateNull(Supplier<Type> type, BiFunction<VisitorState, Type, Type> transformer) {
        return (Supplier & Serializable)state -> Optional.ofNullable((Type)type.get(state)).map(t -> (Type)transformer.apply(state, (Type)t)).orElse(null);
    }
}

