/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.msk.auth.iam.internals.AuthenticationRequestParams;
import software.amazon.msk.auth.iam.internals.PayloadGenerationException;
import software.amazon.msk.auth.iam.internals.SignedPayloadGenerator;

public class AWS4SignedPayloadGenerator
implements SignedPayloadGenerator {
    private static final Logger log = LoggerFactory.getLogger(AWS4SignedPayloadGenerator.class);
    private static final String ACTION_KEY = "Action";
    private static final String ACTION_VALUE = "kafka-cluster:Connect";
    private static final String VERSION_KEY = "version";
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String PROTOCOL = "https";
    private static final int EXPIRY_DURATION_MINUTES = 15;

    @Override
    public byte[] signedPayload(@NonNull AuthenticationRequestParams params) throws PayloadGenerationException {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SdkHttpFullRequest request = this.presignRequest(params);
        try {
            return this.toPayloadBytes(request, params);
        }
        catch (IOException e) {
            throw new PayloadGenerationException("Failure to create authentication payload ", e);
        }
    }

    public SdkHttpFullRequest presignRequest(@NonNull AuthenticationRequestParams params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SdkHttpFullRequest request = this.createRequestForSigning(params);
        Aws4PresignerParams signingParams = this.createSigningParams(params);
        return Aws4Signer.create().presign(request, signingParams);
    }

    private SdkHttpFullRequest createRequestForSigning(AuthenticationRequestParams params) {
        return SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).protocol(PROTOCOL).host(params.getHost()).appendRawQueryParameter(ACTION_KEY, ACTION_VALUE).build();
    }

    private Aws4PresignerParams createSigningParams(AuthenticationRequestParams params) {
        return ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().awsCredentials(params.getAwsCredentials())).expirationTime(this.getExpiry()).signingRegion(params.getRegion())).signingName(params.getServiceScope())).build();
    }

    private Instant getExpiry() {
        return Instant.now().plus(15L, ChronoUnit.MINUTES);
    }

    private byte[] toPayloadBytes(SdkHttpFullRequest request, AuthenticationRequestParams params) throws IOException {
        Map<String, String> keyValueMap = this.toKeyValueMap(request, params);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsBytes(keyValueMap);
    }

    private Map<String, String> toKeyValueMap(SdkHttpFullRequest request, AuthenticationRequestParams params) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        Set parameterEntries = request.rawQueryParameters().entrySet();
        parameterEntries.stream().forEach(e -> keyValueMap.put(((String)e.getKey()).toLowerCase(), this.generateParameterValue((String)e.getKey(), (List)e.getValue())));
        keyValueMap.put(VERSION_KEY, params.getVersion());
        keyValueMap.put(USER_AGENT_KEY, params.getUserAgent());
        Set headerEntries = request.headers().entrySet();
        headerEntries.stream().forEach(e -> keyValueMap.put(((String)e.getKey()).toLowerCase(), (String)((List)e.getValue()).get(0)));
        return keyValueMap;
    }

    private String generateParameterValue(String key, List<String> value) {
        if (value.isEmpty()) {
            return "";
        }
        if (value.size() > 1) {
            if (!"X-Amz-SignedHeaders".equals(key)) {
                throw new IllegalArgumentException("Unexpected number of arguments " + value.size() + " for query parameter " + key);
            }
            StringJoiner joiner = new StringJoiner(";");
            value.stream().forEach(joiner::add);
            return joiner.toString();
        }
        return value.get(0);
    }
}

