/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import software.amazon.awssdk.utils.StringUtils;

public class IAMOAuthBearerToken
implements OAuthBearerToken {
    private static final String SIGNING_NAME = "kafka-cluster";
    private final String value;
    private final long lifetimeMs;
    private final long startTimeMs;

    IAMOAuthBearerToken(String token, long lifeTimeSeconds) {
        this.value = token;
        this.startTimeMs = System.currentTimeMillis();
        this.lifetimeMs = this.startTimeMs + lifeTimeSeconds * 1000L;
    }

    public IAMOAuthBearerToken(String token) throws URISyntaxException {
        long signedDateEpochMillis;
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Token can not be empty");
        }
        this.value = token;
        byte[] tokenBytes = token.getBytes(StandardCharsets.UTF_8);
        byte[] decodedBytes = Base64.getUrlDecoder().decode(tokenBytes);
        String decodedPresignedUrl = new String(decodedBytes, StandardCharsets.UTF_8);
        URI uri = new URI(decodedPresignedUrl);
        List params = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
        Map<String, String> paramMap = params.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        int lifeTimeSeconds = Integer.parseInt(paramMap.get("X-Amz-Expires"));
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
        LocalDateTime signedDate = LocalDateTime.parse(paramMap.get("X-Amz-Date"), dateFormat);
        this.startTimeMs = signedDateEpochMillis = signedDate.toInstant(ZoneOffset.UTC).toEpochMilli();
        this.lifetimeMs = this.startTimeMs + (long)lifeTimeSeconds * 1000L;
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        return Collections.emptySet();
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return SIGNING_NAME;
    }

    public Long startTimeMs() {
        return this.startTimeMs;
    }
}

