/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class StatementWrapper
implements Statement {
    protected final Statement statement;
    protected final ConnectionWrapper connectionWrapper;
    protected final ConnectionPluginManager pluginManager;

    public StatementWrapper(@NonNull Statement statement, @NonNull ConnectionWrapper connectionWrapper, @NonNull ConnectionPluginManager pluginManager) {
        this.statement = statement;
        this.connectionWrapper = connectionWrapper;
        this.pluginManager = pluginManager;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEQUERY, () -> this.statement.executeQuery(sql), sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTEUPDATE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEUPDATE, () -> this.statement.executeUpdate(sql), sql);
        }
        return this.statement.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTEUPDATE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEUPDATE, () -> this.statement.executeUpdate(sql, autoGeneratedKeys), sql, autoGeneratedKeys);
        }
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTEUPDATE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEUPDATE, () -> this.statement.executeUpdate(sql, columnIndexes), sql, columnIndexes);
        }
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTEUPDATE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEUPDATE, () -> this.statement.executeUpdate(sql, columnNames), sql, columnNames);
        }
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public void close() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_CLOSE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_CLOSE, this.statement::close, new Object[0]);
        } else {
            this.statement.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETMAXFIELDSIZE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETMAXFIELDSIZE, this.statement::getMaxFieldSize, new Object[0]);
        }
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETMAXFIELDSIZE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETMAXFIELDSIZE, () -> this.statement.setMaxFieldSize(max), max);
        } else {
            this.statement.setMaxFieldSize(max);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETMAXROWS)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETMAXROWS, this.statement::getMaxRows, new Object[0]);
        }
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETMAXROWS)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETMAXROWS, () -> this.statement.setMaxRows(max), max);
        } else {
            this.statement.setMaxRows(max);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETESCAPEPROCESSING)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETESCAPEPROCESSING, () -> this.statement.setEscapeProcessing(enable), enable);
        } else {
            this.statement.setEscapeProcessing(enable);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETQUERYTIMEOUT)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETQUERYTIMEOUT, this.statement::getQueryTimeout, new Object[0]);
        }
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETQUERYTIMEOUT)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETQUERYTIMEOUT, () -> this.statement.setQueryTimeout(seconds), seconds);
        } else {
            this.statement.setQueryTimeout(seconds);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_CANCEL)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_CANCEL, this.statement::cancel, new Object[0]);
        } else {
            this.statement.cancel();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETWARNINGS)) {
            return WrapperUtils.executeWithPlugins(SQLWarning.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETWARNINGS, this.statement::getWarnings, new Object[0]);
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_CLEARWARNINGS)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_CLEARWARNINGS, this.statement::clearWarnings, new Object[0]);
        } else {
            this.statement.clearWarnings();
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETCURSORNAME)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETCURSORNAME, () -> this.statement.setCursorName(name), name);
        } else {
            this.statement.setCursorName(name);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTE, () -> this.statement.execute(sql), sql);
        }
        return this.statement.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTE, () -> this.statement.execute(sql, autoGeneratedKeys), sql, autoGeneratedKeys);
        }
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTE, () -> this.statement.execute(sql, columnIndexes), sql, columnIndexes);
        }
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTE, () -> this.statement.execute(sql, columnNames), sql, columnNames);
        }
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETRESULTSET, this.statement::getResultSet, new Object[0]);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETUPDATECOUNT)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETUPDATECOUNT, this.statement::getUpdateCount, new Object[0]);
        }
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETMORERESULTS)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETMORERESULTS, this.statement::getMoreResults, new Object[0]);
        }
        return this.statement.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETMORERESULTS)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETMORERESULTS, () -> this.statement.getMoreResults(current), current);
        }
        return this.statement.getMoreResults(current);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETFETCHDIRECTION)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETFETCHDIRECTION, this.statement::getFetchDirection, new Object[0]);
        }
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETFETCHDIRECTION)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETFETCHDIRECTION, () -> this.statement.setFetchDirection(direction), direction);
        } else {
            this.statement.setFetchDirection(direction);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETFETCHSIZE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETFETCHSIZE, this.statement::getFetchSize, new Object[0]);
        }
        return this.statement.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETFETCHSIZE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETFETCHSIZE, () -> this.statement.setFetchSize(rows), rows);
        } else {
            this.statement.setFetchSize(rows);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETRESULTSETCONCURRENCY)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETRESULTSETCONCURRENCY, this.statement::getResultSetConcurrency, new Object[0]);
        }
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETRESULTSETTYPE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETRESULTSETTYPE, this.statement::getResultSetType, new Object[0]);
        }
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_ADDBATCH)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_ADDBATCH, () -> this.statement.addBatch(sql), sql);
        } else {
            this.statement.addBatch(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_CLEARBATCH)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_CLEARBATCH, this.statement::clearBatch, new Object[0]);
        } else {
            this.statement.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_EXECUTEBATCH)) {
            return WrapperUtils.executeWithPlugins(int[].class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_EXECUTEBATCH, this.statement::executeBatch, new Object[0]);
        }
        return this.statement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return WrapperUtils.executeWithPlugins(Connection.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETCONNECTION, () -> this.connectionWrapper, new Object[0]);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETGENERATEDKEYS, this.statement::getGeneratedKeys, new Object[0]);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_GETRESULTSETHOLDABILITY)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_GETRESULTSETHOLDABILITY, this.statement::getResultSetHoldability, new Object[0]);
        }
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_ISCLOSED)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_ISCLOSED, this.statement::isClosed, new Object[0]);
        }
        return this.statement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_ISPOOLABLE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_ISPOOLABLE, this.statement::isPoolable, new Object[0]);
        }
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_SETPOOLABLE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_SETPOOLABLE, () -> this.statement.setPoolable(poolable), poolable);
        } else {
            this.statement.setPoolable(poolable);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_CLOSEONCOMPLETION)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_CLOSEONCOMPLETION, this.statement::closeOnCompletion, new Object[0]);
        } else {
            this.statement.closeOnCompletion();
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STATEMENT_ISCLOSEONCOMPLETION)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.statement, JdbcMethod.STATEMENT_ISCLOSEONCOMPLETION, this.statement::isCloseOnCompletion, new Object[0]);
        }
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    public String toString() {
        return super.toString() + " - " + this.statement;
    }
}

