/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class NClobWrapper
implements NClob {
    protected final NClob nclob;
    protected final ConnectionWrapper connectionWrapper;
    protected final ConnectionPluginManager pluginManager;

    public NClobWrapper(@NonNull NClob nclob, @NonNull ConnectionWrapper connectionWrapper, @NonNull ConnectionPluginManager pluginManager) {
        this.nclob = nclob;
        this.connectionWrapper = connectionWrapper;
        this.pluginManager = pluginManager;
    }

    @Override
    public long length() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_LENGTH)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_LENGTH, this.nclob::length, new Object[0]);
        }
        return this.nclob.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_GETSUBSTRING)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_GETSUBSTRING, () -> this.nclob.getSubString(pos, length), pos, length);
        }
        return this.nclob.getSubString(pos, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_GETASCIISTREAM)) {
            return WrapperUtils.executeWithPlugins(Reader.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_GETASCIISTREAM, this.nclob::getCharacterStream, new Object[0]);
        }
        return this.nclob.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_GETCHARACTERSTREAM)) {
            return WrapperUtils.executeWithPlugins(Reader.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_GETCHARACTERSTREAM, () -> this.nclob.getCharacterStream(pos, length), pos, length);
        }
        return this.nclob.getCharacterStream(pos, length);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_GETASCIISTREAM)) {
            return WrapperUtils.executeWithPlugins(InputStream.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_GETASCIISTREAM, this.nclob::getAsciiStream, new Object[0]);
        }
        return this.nclob.getAsciiStream();
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_POSITION)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_POSITION, () -> this.nclob.position(searchStr, start), searchStr, start);
        }
        return this.nclob.position(searchStr, start);
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_POSITION)) {
            return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_POSITION, () -> this.nclob.position(searchStr, start), searchStr, start);
        }
        return this.nclob.position(searchStr, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_SETSTRING)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_SETSTRING, () -> this.nclob.setString(pos, str), pos, str);
        }
        return this.nclob.setString(pos, str);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_SETSTRING)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_SETSTRING, () -> this.nclob.setString(pos, str, offset, len), pos, str, offset, len);
        }
        return this.nclob.setString(pos, str, offset, len);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_SETASCIISTREAM)) {
            return WrapperUtils.executeWithPlugins(OutputStream.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_SETASCIISTREAM, () -> this.nclob.setAsciiStream(pos), pos);
        }
        return this.nclob.setAsciiStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_SETCHARACTERSTREAM)) {
            return WrapperUtils.executeWithPlugins(Writer.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_SETCHARACTERSTREAM, () -> this.nclob.setCharacterStream(pos), pos);
        }
        return this.nclob.setCharacterStream(pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_TRUNCATE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_TRUNCATE, () -> this.nclob.truncate(len), len);
        } else {
            this.nclob.truncate(len);
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.NCLOB_FREE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.connectionWrapper, this.pluginManager, this.nclob, JdbcMethod.NCLOB_FREE, this.nclob::free, new Object[0]);
        } else {
            this.nclob.free();
        }
    }

    public String toString() {
        return super.toString() + " - " + this.nclob;
    }
}

