/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.events;

import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.util.events.Event;

public class MonitorResetEvent
implements Event {
    private final @NonNull String clusterId;
    private final @NonNull Set<String> endpoints;

    public MonitorResetEvent(@NonNull String clusterId, @NonNull Set<String> endpoints) {
        this.clusterId = clusterId;
        this.endpoints = endpoints;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorResetEvent event = (MonitorResetEvent)obj;
        return Objects.equals(this.clusterId, event.clusterId) && Objects.equals(this.endpoints, event.endpoints);
    }

    public @NonNull String getClusterId() {
        return this.clusterId;
    }

    public @NonNull Set<String> getEndpoints() {
        return this.endpoints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clusterId.hashCode();
        result = 31 * result + this.endpoints.hashCode();
        return result;
    }

    @Override
    public boolean isImmediateDelivery() {
        return true;
    }
}

