/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.sql.SQLException;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.PartialPluginService;
import software.amazon.jdbc.PluginServiceImpl;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.FullServicesContainerImpl;
import software.amazon.jdbc.util.events.EventPublisher;
import software.amazon.jdbc.util.monitoring.MonitorService;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class ServiceUtility {
    private static final ServiceUtility instance = new ServiceUtility();

    private ServiceUtility() {
    }

    public static ServiceUtility getInstance() {
        return instance;
    }

    public FullServicesContainer createStandardServiceContainer(StorageService storageService, MonitorService monitorService, EventPublisher eventPublisher, ConnectionProvider defaultConnectionProvider, ConnectionProvider effectiveConnectionProvider, TelemetryFactory telemetryFactory, String originalUrl, String targetDriverProtocol, TargetDriverDialect driverDialect, Properties props, @Nullable ConfigurationProfile configurationProfile) throws SQLException {
        FullServicesContainerImpl servicesContainer = new FullServicesContainerImpl(storageService, monitorService, eventPublisher, defaultConnectionProvider, telemetryFactory);
        ConnectionPluginManager pluginManager = new ConnectionPluginManager(props, telemetryFactory, defaultConnectionProvider, effectiveConnectionProvider);
        servicesContainer.setConnectionPluginManager(pluginManager);
        PluginServiceImpl pluginService = new PluginServiceImpl(servicesContainer, props, originalUrl, targetDriverProtocol, driverDialect, configurationProfile);
        servicesContainer.setHostListProviderService(pluginService);
        servicesContainer.setPluginService(pluginService);
        servicesContainer.setPluginManagerService(pluginService);
        pluginManager.initPlugins(servicesContainer, configurationProfile);
        HostListProviderSupplier supplier = pluginService.getDialect().getHostListProvider();
        if (supplier != null) {
            HostListProvider provider = supplier.getProvider(props, originalUrl, servicesContainer);
            pluginService.setHostListProvider(provider);
        }
        pluginManager.initHostProvider(targetDriverProtocol, originalUrl, props, pluginService);
        pluginService.refreshHostList();
        return servicesContainer;
    }

    public FullServicesContainer createMinimalServiceContainer(StorageService storageService, MonitorService monitorService, EventPublisher eventPublisher, ConnectionProvider connectionProvider, TelemetryFactory telemetryFactory, String originalUrl, String targetDriverProtocol, TargetDriverDialect driverDialect, Dialect dbDialect, Properties props) throws SQLException {
        FullServicesContainerImpl serviceContainer = new FullServicesContainerImpl(storageService, monitorService, eventPublisher, connectionProvider, telemetryFactory);
        ConnectionPluginManager pluginManager = new ConnectionPluginManager(props, telemetryFactory, connectionProvider, null);
        serviceContainer.setConnectionPluginManager(pluginManager);
        PartialPluginService pluginService = new PartialPluginService(serviceContainer, props, originalUrl, targetDriverProtocol, driverDialect, dbDialect);
        serviceContainer.setHostListProviderService(pluginService);
        serviceContainer.setPluginService(pluginService);
        serviceContainer.setPluginManagerService(pluginService);
        pluginManager.initPlugins(serviceContainer, null);
        return serviceContainer;
    }

    public FullServicesContainer createMinimalServiceContainer(FullServicesContainer servicesContainer, Properties props) throws SQLException {
        return this.createMinimalServiceContainer(servicesContainer.getStorageService(), servicesContainer.getMonitorService(), servicesContainer.getEventPublisher(), servicesContainer.getPluginService().getDefaultConnectionProvider(), servicesContainer.getTelemetryFactory(), servicesContainer.getPluginService().getOriginalUrl(), servicesContainer.getPluginService().getDriverProtocol(), servicesContainer.getPluginService().getTargetDriverDialect(), servicesContainer.getPluginService().getDialect(), props);
    }
}

