/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.WeightedRandomHostSelector;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionContext;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessQueryHelper;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitor;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.plugin.limitless.LimitlessRouters;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.HostSelectorUtils;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.monitoring.MonitorErrorResponse;

public class LimitlessRouterServiceImpl
implements LimitlessRouterService {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("limitlessTransactionRouterMonitorDisposalTimeMs", "600000", "Interval in milliseconds for an Limitless router monitor to be considered inactive and to be disposed.");
    protected static final Map<String, ReentrantLock> forceGetLimitlessRoutersLockMap = new ConcurrentHashMap<String, ReentrantLock>();
    protected static final Set<MonitorErrorResponse> monitorErrorResponses = new HashSet<MonitorErrorResponse>(Collections.singletonList(MonitorErrorResponse.RECREATE));
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected final LimitlessQueryHelper queryHelper;

    public LimitlessRouterServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props) {
        this(servicesContainer, new LimitlessQueryHelper(servicesContainer.getPluginService()), props);
    }

    public LimitlessRouterServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull LimitlessQueryHelper queryHelper, @NonNull Properties props) {
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.queryHelper = queryHelper;
        this.servicesContainer.getStorageService().registerItemClassIfAbsent(LimitlessRouters.class, true, TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props)), null, null);
        this.servicesContainer.getMonitorService().registerMonitorTypeIfAbsent(LimitlessRouterMonitor.class, TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props)), TimeUnit.MINUTES.toNanos(3L), monitorErrorResponses, LimitlessRouters.class);
    }

    @Override
    public void establishConnection(LimitlessConnectionContext context) throws SQLException {
        HostSpec selectedHostSpec;
        context.setLimitlessRouters(this.getLimitlessRouters(this.pluginService.getHostListProvider().getClusterId()));
        if (Utils.isNullOrEmpty(context.getLimitlessRouters())) {
            LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.limitlessRouterCacheEmpty"));
            boolean waitForRouterInfo = LimitlessConnectionPlugin.WAIT_FOR_ROUTER_INFO.getBoolean(context.getProps());
            if (waitForRouterInfo) {
                this.synchronouslyGetLimitlessRoutersWithRetry(context);
            } else {
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.usingProvidedConnectUrl"));
                if (context.getConnection() == null || context.getConnection().isClosed()) {
                    context.setConnection(context.getConnectFunc().call());
                }
                return;
            }
        }
        if (Utils.containsHostAndPort(context.getLimitlessRouters(), context.getHostSpec().getHostAndPort())) {
            LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.connectWithHost", new Object[]{context.getHostSpec().getHost()}));
            if (context.getConnection() == null || context.getConnection().isClosed()) {
                try {
                    context.setConnection(context.getConnectFunc().call());
                }
                catch (SQLException e) {
                    if (this.isLoginException(e)) {
                        throw e;
                    }
                    this.retryConnectWithLeastLoadedRouters(context);
                }
            }
            return;
        }
        HostSelectorUtils.setHostWeightPairsProperty(WeightedRandomHostSelector.WEIGHTED_RANDOM_HOST_WEIGHT_PAIRS, context.getProps(), context.getLimitlessRouters());
        try {
            selectedHostSpec = this.pluginService.getHostSpecByStrategy(context.getLimitlessRouters(), HostRole.WRITER, "weightedRandom");
            LOGGER.fine(Messages.get("LimitlessRouterServiceImpl.selectedHost", new Object[]{selectedHostSpec != null ? selectedHostSpec.getHost() : "null"}));
        }
        catch (SQLException e) {
            if (this.isLoginException(e)) {
                throw e;
            }
            this.retryConnectWithLeastLoadedRouters(context);
            return;
        }
        if (selectedHostSpec == null) {
            this.retryConnectWithLeastLoadedRouters(context);
            return;
        }
        try {
            context.setConnection(this.pluginService.connect(selectedHostSpec, context.getProps(), context.getPlugin()));
        }
        catch (SQLException e) {
            if (this.isLoginException(e)) {
                throw e;
            }
            if (selectedHostSpec != null) {
                LOGGER.fine(Messages.get("LimitlessRouterServiceImpl.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
                selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
            }
            this.retryConnectWithLeastLoadedRouters(context);
        }
    }

    protected List<HostSpec> getLimitlessRouters(String clusterId) {
        LimitlessRouters routers = this.servicesContainer.getStorageService().get(LimitlessRouters.class, clusterId);
        return routers == null ? null : routers.getHosts();
    }

    private void retryConnectWithLeastLoadedRouters(LimitlessConnectionContext context) throws SQLException {
        int retryCount = 0;
        int maxRetries = LimitlessConnectionPlugin.MAX_RETRIES.getInteger(context.getProps());
        while (retryCount++ < maxRetries) {
            HostSpec selectedHostSpec;
            if (Utils.isNullOrEmpty(context.getLimitlessRouters()) || context.getLimitlessRouters().stream().noneMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE))) {
                this.synchronouslyGetLimitlessRoutersWithRetry(context);
                if (Utils.isNullOrEmpty(context.getLimitlessRouters()) || context.getLimitlessRouters().stream().noneMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE))) {
                    LOGGER.warning(Messages.get("LimitlessRouterServiceImpl.noRoutersAvailableForRetry"));
                    if (context.getConnection() != null && !context.getConnection().isClosed()) {
                        return;
                    }
                    try {
                        context.setConnection(context.getConnectFunc().call());
                        return;
                    }
                    catch (SQLException e) {
                        if (this.isLoginException(e)) {
                            throw e;
                        }
                        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.unableToConnectNoRoutersAvailable", new Object[]{context.getHostSpec().getHost()}), e);
                    }
                }
            }
            try {
                selectedHostSpec = this.pluginService.getHostSpecByStrategy(context.getLimitlessRouters(), HostRole.WRITER, "highestWeight");
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.selectedHostForRetry", new Object[]{selectedHostSpec != null ? selectedHostSpec.getHost() : "null"}));
                if (selectedHostSpec == null) {
                    continue;
                }
            }
            catch (UnsupportedOperationException e) {
                LOGGER.severe(Messages.get("LimitlessRouterServiceImpl.incorrectConfiguration"));
                throw e;
            }
            catch (SQLException e) {
                continue;
            }
            try {
                context.setConnection(this.pluginService.connect(selectedHostSpec, context.getProps(), context.getPlugin()));
                if (context.getConnection() == null) continue;
                return;
            }
            catch (SQLException e) {
                if (this.isLoginException(e)) {
                    throw e;
                }
                selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
            }
        }
        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.maxRetriesExceeded"));
    }

    protected void synchronouslyGetLimitlessRoutersWithRetry(LimitlessConnectionContext context) throws SQLException {
        LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.synchronouslyGetLimitlessRouters"));
        int retryCount = -1;
        int maxRetries = LimitlessConnectionPlugin.GET_ROUTER_MAX_RETRIES.getInteger(context.getProps());
        int retryIntervalMs = LimitlessConnectionPlugin.GET_ROUTER_RETRY_INTERVAL_MILLIS.getInteger(context.getProps());
        do {
            try {
                this.synchronouslyGetLimitlessRouters(context);
                if (!Utils.isNullOrEmpty(context.getLimitlessRouters())) {
                    return;
                }
                Thread.sleep(retryIntervalMs);
            }
            catch (SQLException e) {
                if (this.isLoginException(e)) {
                    throw e;
                }
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.getLimitlessRoutersException", new Object[]{e}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(Messages.get("LimitlessRouterServiceImpl.interruptedSynchronousGetRouter"), e);
            }
            finally {
                ++retryCount;
            }
        } while (retryCount < maxRetries);
        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.noRoutersAvailable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronouslyGetLimitlessRouters(LimitlessConnectionContext context) throws SQLException {
        block7: {
            ReentrantLock lock = forceGetLimitlessRoutersLockMap.computeIfAbsent(this.pluginService.getHostListProvider().getClusterId(), key -> new ReentrantLock());
            lock.lock();
            try {
                List<HostSpec> newRouterList;
                List<HostSpec> limitlessRouters = this.getLimitlessRouters(this.pluginService.getHostListProvider().getClusterId());
                if (!Utils.isNullOrEmpty(limitlessRouters)) {
                    context.setLimitlessRouters(limitlessRouters);
                    return;
                }
                if (context.getConnection() == null || context.getConnection().isClosed()) {
                    context.setConnection(context.getConnectFunc().call());
                }
                if (!Utils.isNullOrEmpty(newRouterList = this.queryHelper.queryForLimitlessRouters(context.getConnection(), context.getHostSpec().getPort()))) {
                    context.setLimitlessRouters(newRouterList);
                    LimitlessRouters newRouters = new LimitlessRouters(newRouterList);
                    this.servicesContainer.getStorageService().set(this.pluginService.getHostListProvider().getClusterId(), newRouters);
                    break block7;
                }
                throw new SQLException(Messages.get("LimitlessRouterServiceImpl.fetchedEmptyRouterList"));
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected boolean isLoginException(Throwable throwable) {
        return this.pluginService.isLoginException(throwable, this.pluginService.getTargetDriverDialect());
    }

    @Override
    public void startMonitoring(@NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        try {
            String limitlessRouterMonitorKey = this.pluginService.getHostListProvider().getClusterId();
            this.servicesContainer.getMonitorService().runIfAbsent(LimitlessRouterMonitor.class, limitlessRouterMonitorKey, this.servicesContainer, props, servicesContainer -> new LimitlessRouterMonitor(servicesContainer, hostSpec, limitlessRouterMonitorKey, props, intervalMs));
        }
        catch (SQLException e) {
            LOGGER.warning(Messages.get("LimitlessRouterServiceImpl.errorStartingMonitor", new Object[]{e}));
            throw new RuntimeException(e);
        }
    }

    public static void clearCache() {
        forceGetLimitlessRoutersLockMap.clear();
    }

    static {
        PropertyDefinition.registerPluginProperties(LimitlessRouterServiceImpl.class);
    }
}

