/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import software.amazon.jdbc.plugin.federatedauth.NonValidatingSSLSocketFactory;

public class HttpClientFactory {
    private static final int MAX_REQUEST_RETRIES = 3;

    public CloseableHttpClient getCloseableHttpClient(int socketTimeoutMs, int connectionTimeoutMs, boolean keySslInsecure) throws GeneralSecurityException {
        RequestConfig rc = RequestConfig.custom().setSocketTimeout(socketTimeoutMs).setConnectTimeout(connectionTimeoutMs).setExpectContinueEnabled(false).setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(rc).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).useSystemProperties();
        if (keySslInsecure) {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManager[] tma = new TrustManager[]{new NonValidatingSSLSocketFactory.NonValidatingTrustManager()};
            ctx.init(null, tma, null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(factory, (HostnameVerifier)new NoopHostnameVerifier());
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sf);
        }
        return builder.build();
    }
}

