/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.dev;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.dev.ExceptionSimulator;
import software.amazon.jdbc.plugin.dev.ExceptionSimulatorExecuteJdbcMethodCallback;
import software.amazon.jdbc.plugin.dev.ExceptionSimulatorManager;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;

public class DeveloperConnectionPlugin
extends AbstractConnectionPlugin
implements ExceptionSimulator {
    private static final Logger LOGGER = Logger.getLogger(DeveloperConnectionPlugin.class.getName());
    private static final String ALL_METHODS = "*";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("*")));
    private String nextMethodName;
    private Throwable nextException;
    private ExceptionSimulatorExecuteJdbcMethodCallback exceptionSimulatorExecuteJdbcMethodCallback;

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public void raiseExceptionOnNextCall(Throwable throwable) {
        this.nextException = throwable;
        this.nextMethodName = ALL_METHODS;
    }

    @Override
    public void raiseExceptionOnNextCall(@NonNull String methodName, Throwable throwable) {
        if (StringUtils.isNullOrEmpty(methodName)) {
            throw new RuntimeException("methodName should not be empty.");
        }
        this.nextException = throwable;
        this.nextMethodName = methodName;
    }

    @Override
    public void setCallback(ExceptionSimulatorExecuteJdbcMethodCallback exceptionSimulatorExecuteJdbcMethodCallback) {
        this.exceptionSimulatorExecuteJdbcMethodCallback = exceptionSimulatorExecuteJdbcMethodCallback;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        this.raiseExceptionIfNeeded(resultClass, exceptionClass, methodName, jdbcMethodArgs);
        return jdbcMethodFunc.call();
    }

    protected <T, E extends Exception> void raiseExceptionIfNeeded(Class<T> resultClass, Class<E> exceptionClass, String methodName, Object[] jdbcMethodArgs) throws E {
        if (this.nextException != null) {
            if (ALL_METHODS.equals(this.nextMethodName) || methodName.equals(this.nextMethodName)) {
                this.raiseException(exceptionClass, this.nextException, methodName);
            }
        } else if (this.exceptionSimulatorExecuteJdbcMethodCallback != null) {
            this.raiseException(exceptionClass, this.exceptionSimulatorExecuteJdbcMethodCallback.getExceptionToRaise(resultClass, exceptionClass, methodName, jdbcMethodArgs), methodName);
        }
    }

    protected <E extends Exception> void raiseException(Class<E> exceptionClass, Throwable throwable, String methodName) throws E {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            this.nextException = null;
            this.nextMethodName = null;
            LOGGER.finest(() -> String.format("Raise an exception %s while executing %s.", throwable.getClass().getName(), methodName));
            throw (RuntimeException)throwable;
        }
        Object resulException = WrapperUtils.wrapExceptionIfNeeded(exceptionClass, throwable);
        this.nextException = null;
        this.nextMethodName = null;
        LOGGER.finest(() -> String.format("Raise an exception %s while executing %s.", resulException.getClass().getName(), methodName));
        throw resulException;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        this.raiseExceptionOnConnectIfNeeded(driverProtocol, hostSpec, props, isInitialConnection);
        return super.connect(driverProtocol, hostSpec, props, isInitialConnection, connectFunc);
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        this.raiseExceptionOnConnectIfNeeded(driverProtocol, hostSpec, props, isInitialConnection);
        return super.connect(driverProtocol, hostSpec, props, isInitialConnection, forceConnectFunc);
    }

    protected void raiseExceptionOnConnectIfNeeded(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection) throws SQLException {
        if (ExceptionSimulatorManager.nextException != null) {
            this.raiseExceptionOnConnect(ExceptionSimulatorManager.nextException);
        } else if (ExceptionSimulatorManager.connectCallback != null) {
            this.raiseExceptionOnConnect(ExceptionSimulatorManager.connectCallback.getExceptionToRaise(driverProtocol, hostSpec, props, isInitialConnection));
        }
    }

    protected void raiseExceptionOnConnect(Throwable throwable) throws SQLException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            ExceptionSimulatorManager.nextException = null;
            LOGGER.finest(() -> String.format("Raise an exception %s while opening a new connection.", ExceptionSimulatorManager.nextException.getClass().getName()));
            throw (RuntimeException)throwable;
        }
        SQLException resulException = WrapperUtils.wrapExceptionIfNeeded(SQLException.class, throwable);
        ExceptionSimulatorManager.nextException = null;
        LOGGER.finest(() -> String.format("Raise an exception %s while opening a new connection.", resulException.getClass().getName()));
        throw resulException;
    }
}

