/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.customendpoint;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBClusterEndpoint;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.RdsException;
import software.amazon.jdbc.AllowedAndBlockedHosts;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointInfo;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointMonitor;
import software.amazon.jdbc.plugin.customendpoint.MemberListType;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.monitoring.AbstractMonitor;
import software.amazon.jdbc.util.storage.CacheMap;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class CustomEndpointMonitorImpl
extends AbstractMonitor
implements CustomEndpointMonitor {
    private static final Logger LOGGER = Logger.getLogger(CustomEndpointMonitorImpl.class.getName());
    private static final String TELEMETRY_ENDPOINT_INFO_CHANGED = "customEndpoint.infoChanged.counter";
    protected static final CacheMap<String, CustomEndpointInfo> customEndpointInfoCache = new CacheMap();
    protected static final long CUSTOM_ENDPOINT_INFO_EXPIRATION_NANO = TimeUnit.MINUTES.toNanos(5L);
    protected static final long UNAUTHORIZED_SLEEP_SEC = TimeUnit.MINUTES.toSeconds(5L);
    protected static final long MONITOR_TERMINATION_TIMEOUT_SEC = 30L;
    protected final RdsClient rdsClient;
    protected final HostSpec customEndpointHostSpec;
    protected final String endpointIdentifier;
    protected final Region region;
    protected long refreshRateNano;
    protected final StorageService storageService;
    private final TelemetryCounter infoChangedCounter;

    public CustomEndpointMonitorImpl(StorageService storageService, TelemetryFactory telemetryFactory, HostSpec customEndpointHostSpec, String endpointIdentifier, Region region, long refreshRateNano, BiFunction<HostSpec, Region, RdsClient> rdsClientFunc) {
        super(30L);
        this.storageService = storageService;
        this.customEndpointHostSpec = customEndpointHostSpec;
        this.endpointIdentifier = endpointIdentifier;
        this.region = region;
        this.refreshRateNano = refreshRateNano;
        this.rdsClient = rdsClientFunc.apply(customEndpointHostSpec, this.region);
        this.infoChangedCounter = telemetryFactory.createCounter(TELEMETRY_ENDPOINT_INFO_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.startingMonitor", new Object[]{this.customEndpointHostSpec.getUrl()}));
        try {
            while (!this.stop.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    long start = System.nanoTime();
                    this.lastActivityTimestampNanos.set(System.nanoTime());
                    Filter customEndpointFilter = (Filter)Filter.builder().name("db-cluster-endpoint-type").values(new String[]{"custom"}).build();
                    DescribeDbClusterEndpointsResponse endpointsResponse = this.rdsClient.describeDBClusterEndpoints(builder -> builder.dbClusterEndpointIdentifier(this.endpointIdentifier).filters(new Filter[]{customEndpointFilter}));
                    List endpoints = endpointsResponse.dbClusterEndpoints();
                    if (endpoints.size() != 1) {
                        List endpointURLs = endpoints.stream().map(DBClusterEndpoint::endpoint).collect(Collectors.toList());
                        LOGGER.warning(Messages.get("CustomEndpointMonitorImpl.unexpectedNumberOfEndpoints", new Object[]{this.endpointIdentifier, this.region.id(), endpoints.size(), endpointURLs}));
                        TimeUnit.NANOSECONDS.sleep(this.refreshRateNano);
                        continue;
                    }
                    CustomEndpointInfo endpointInfo = CustomEndpointInfo.fromDBClusterEndpoint((DBClusterEndpoint)endpoints.get(0));
                    CustomEndpointInfo cachedEndpointInfo = customEndpointInfoCache.get(this.customEndpointHostSpec.getUrl());
                    if (cachedEndpointInfo != null && cachedEndpointInfo.equals(endpointInfo)) {
                        long elapsedTime = System.nanoTime() - start;
                        long sleepDuration = Math.max(0L, this.refreshRateNano - elapsedTime);
                        TimeUnit.NANOSECONDS.sleep(sleepDuration);
                        continue;
                    }
                    LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.detectedChangeInCustomEndpointInfo", new Object[]{this.customEndpointHostSpec.getUrl(), endpointInfo}));
                    AllowedAndBlockedHosts allowedAndBlockedHosts = MemberListType.STATIC_LIST.equals((Object)endpointInfo.getMemberListType()) ? new AllowedAndBlockedHosts(endpointInfo.getStaticMembers(), null) : new AllowedAndBlockedHosts(null, endpointInfo.getExcludedMembers());
                    this.storageService.set(this.customEndpointHostSpec.getUrl(), allowedAndBlockedHosts);
                    customEndpointInfoCache.put(this.customEndpointHostSpec.getUrl(), endpointInfo, CUSTOM_ENDPOINT_INFO_EXPIRATION_NANO);
                    if (this.infoChangedCounter != null) {
                        this.infoChangedCounter.inc();
                    }
                    long elapsedTime = System.nanoTime() - start;
                    long sleepDuration = Math.max(0L, this.refreshRateNano - elapsedTime);
                    TimeUnit.NANOSECONDS.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (RdsException ex) {
                    LOGGER.log(Level.SEVERE, Messages.get("CustomEndpointMonitorImpl.exception", new Object[]{this.customEndpointHostSpec.getUrl()}), ex);
                    if (ex.isThrottlingException()) {
                        this.refreshRateNano *= 2L;
                        TimeUnit.NANOSECONDS.sleep(this.refreshRateNano);
                        continue;
                    }
                    if (ex.statusCode() == 401 || ex.statusCode() == 403) {
                        TimeUnit.SECONDS.sleep(UNAUTHORIZED_SLEEP_SEC);
                        continue;
                    }
                    TimeUnit.NANOSECONDS.sleep(this.refreshRateNano);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, Messages.get("CustomEndpointMonitorImpl.exception", new Object[]{this.customEndpointHostSpec.getUrl()}), e);
                    TimeUnit.NANOSECONDS.sleep(this.refreshRateNano);
                }
            }
            customEndpointInfoCache.remove(this.customEndpointHostSpec.getUrl());
        }
        catch (InterruptedException e) {
            try {
                LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.interrupted", new Object[]{this.customEndpointHostSpec.getUrl()}));
                Thread.currentThread().interrupt();
                customEndpointInfoCache.remove(this.customEndpointHostSpec.getUrl());
            }
            catch (Throwable throwable) {
                customEndpointInfoCache.remove(this.customEndpointHostSpec.getUrl());
                this.rdsClient.close();
                LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getUrl()}));
                throw throwable;
            }
            this.rdsClient.close();
            LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getUrl()}));
        }
        this.rdsClient.close();
        LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getUrl()}));
    }

    @Override
    public boolean hasCustomEndpointInfo() {
        return customEndpointInfoCache.get(this.customEndpointHostSpec.getUrl()) != null;
    }

    @Override
    public void close() {
        customEndpointInfoCache.remove(this.customEndpointHostSpec.getUrl());
        this.rdsClient.close();
    }

    public static void clearCache() {
        LOGGER.info(Messages.get("CustomEndpointMonitorImpl.clearCache"));
        customEndpointInfoCache.clear();
    }
}

