/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenConnectionPlugin;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseConnectRouting;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Pair;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class SuspendUntilCorrespondingNodeFoundConnectRouting
extends BaseConnectRouting {
    private static final Logger LOGGER = Logger.getLogger(SuspendUntilCorrespondingNodeFoundConnectRouting.class.getName());
    private static final String TELEMETRY_SWITCHOVER = "Blue/Green switchover";
    private static final long SLEEP_TIME_MS = 100L;
    protected String bgdId;

    public SuspendUntilCorrespondingNodeFoundConnectRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role, String bgdId) {
        super(hostAndPort, role);
        this.bgdId = bgdId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection apply(ConnectionPlugin plugin, HostSpec hostSpec, Properties props, boolean isInitialConnection, boolean useForceConnect, JdbcCallable<Connection, SQLException> connectFunc, StorageService storageService, PluginService pluginService) throws SQLException {
        LOGGER.finest(() -> Messages.get("bgd.waitConnectUntilCorrespondingNodeFound", new Object[]{hostSpec.getHost()}));
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_SWITCHOVER, TelemetryTraceLevel.NESTED);
        BlueGreenStatus bgStatus = storageService.get(BlueGreenStatus.class, this.bgdId);
        Pair<HostSpec, HostSpec> correspondingPair = bgStatus == null ? null : bgStatus.getCorrespondingNodes().get(hostSpec.getHost());
        long timeoutNano = TimeUnit.MILLISECONDS.toNanos(BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props));
        long holdStartTime = this.getNanoTime();
        long endTime = this.getNanoTime() + timeoutNano;
        try {
            while (this.getNanoTime() <= endTime && bgStatus != null && bgStatus.getCurrentPhase() != BlueGreenPhase.COMPLETED && (correspondingPair == null || correspondingPair.getValue2() == null)) {
                try {
                    this.delay(100L, bgStatus, storageService, this.bgdId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                bgStatus = storageService.get(BlueGreenStatus.class, this.bgdId);
                correspondingPair = bgStatus == null ? null : bgStatus.getCorrespondingNodes().get(hostSpec.getHost());
            }
            if (bgStatus == null || bgStatus.getCurrentPhase() == BlueGreenPhase.COMPLETED) {
                LOGGER.finest(Messages.get("bgd.completedContinueWithConnect", new Object[]{TimeUnit.NANOSECONDS.toMillis(this.getNanoTime() - holdStartTime)}));
                Connection connection = null;
                return connection;
            }
            if (this.getNanoTime() > endTime) {
                throw new SQLTimeoutException(Messages.get("bgd.correspondingNodeNotFoundTryConnectLater", new Object[]{hostSpec.getHost(), BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props)}));
            }
            LOGGER.finest(Messages.get("bgd.correspondingNodeFoundContinueWithConnect", new Object[]{hostSpec.getHost(), TimeUnit.NANOSECONDS.toMillis(this.getNanoTime() - holdStartTime)}));
        }
        finally {
            if (telemetryContext != null) {
                telemetryContext.closeContext();
            }
        }
        return null;
    }
}

