/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.ConnectRouting;
import software.amazon.jdbc.util.storage.StorageService;

public abstract class BaseConnectRouting
extends BaseRouting
implements ConnectRouting {
    private static final Logger LOGGER = Logger.getLogger(BaseConnectRouting.class.getName());
    protected final String hostAndPort;
    protected final BlueGreenRole role;

    public BaseConnectRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role) {
        this.hostAndPort = hostAndPort == null ? null : hostAndPort.toLowerCase();
        this.role = role;
    }

    @Override
    public boolean isMatch(HostSpec hostSpec, BlueGreenRole hostRole) {
        return !(this.hostAndPort != null && !this.hostAndPort.equals(hostSpec == null ? null : hostSpec.getHostAndPort().toLowerCase()) || this.role != null && !this.role.equals((Object)hostRole));
    }

    @Override
    public abstract Connection apply(ConnectionPlugin var1, HostSpec var2, Properties var3, boolean var4, boolean var5, JdbcCallable<Connection, SQLException> var6, StorageService var7, PluginService var8) throws SQLException;

    public String toString() {
        return String.format("%s [%s, %s]", super.toString(), this.hostAndPort == null ? "<null>" : this.hostAndPort, this.role == null ? "<null>" : this.role.toString());
    }
}

