/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostavailability;

import java.util.Properties;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.ExponentialBackoffHostAvailabilityStrategy;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategy;
import software.amazon.jdbc.hostavailability.SimpleHostAvailabilityStrategy;
import software.amazon.jdbc.util.StringUtils;

public class HostAvailabilityStrategyFactory {
    public static final AwsWrapperProperty DEFAULT_HOST_AVAILABILITY_STRATEGY = new AwsWrapperProperty("defaultHostAvailabilityStrategy", "", "An override for specifying the default host availability change strategy.");
    public static final AwsWrapperProperty HOST_AVAILABILITY_STRATEGY_MAX_RETRIES = new AwsWrapperProperty("hostAvailabilityStrategyMaxRetries", "5", "Max number of retries for checking a host's availability.");
    public static final AwsWrapperProperty HOST_AVAILABILITY_STRATEGY_INITIAL_BACKOFF_TIME = new AwsWrapperProperty("hostAvailabilityStrategyInitialBackoffTime", "30", "The initial backoff time in seconds.");

    public HostAvailabilityStrategy create(Properties props) {
        if (props == null || StringUtils.isNullOrEmpty(DEFAULT_HOST_AVAILABILITY_STRATEGY.getString(props))) {
            return new SimpleHostAvailabilityStrategy();
        }
        if (ExponentialBackoffHostAvailabilityStrategy.NAME.equalsIgnoreCase(DEFAULT_HOST_AVAILABILITY_STRATEGY.getString(props))) {
            return new ExponentialBackoffHostAvailabilityStrategy(props);
        }
        return new SimpleHostAvailabilityStrategy();
    }

    static {
        PropertyDefinition.registerPluginProperties(HostAvailabilityStrategyFactory.class);
    }
}

