/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.util.Messages;

public class WeightedRandomHostSelector
implements HostSelector {
    public static final AwsWrapperProperty WEIGHTED_RANDOM_HOST_WEIGHT_PAIRS = new AwsWrapperProperty("weightedRandomHostWeightPairs", null, "Comma separated list of database host-weight pairs in the format of `<host>:<weight>`.");
    public static final String STRATEGY_WEIGHTED_RANDOM = "weightedRandom";
    static final int DEFAULT_WEIGHT = 1;
    static final Pattern HOST_WEIGHT_PAIRS_PATTERN = Pattern.compile("((?<host>[^:/?#]*):(?<weight>[0-9]*))");
    private Map<String, Integer> cachedHostWeightMap;
    private String cachedHostWeightMapString;
    private Random random;
    private final ReentrantLock lock = new ReentrantLock();

    public WeightedRandomHostSelector() {
        this(new Random());
    }

    public WeightedRandomHostSelector(Random random) {
        this.random = random;
    }

    @Override
    public HostSpec getHost(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @Nullable Properties props) throws SQLException {
        Map<String, Integer> hostWeightMap = this.getHostWeightPairMap(WEIGHTED_RANDOM_HOST_WEIGHT_PAIRS.getString(props));
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole()) && hostSpec.getAvailability().equals((Object)HostAvailability.AVAILABLE)).sorted(Comparator.comparing(HostSpec::getHost)).collect(Collectors.toList());
        if (eligibleHosts.isEmpty()) {
            throw new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        HashMap<String, NumberRange> hostWeightRangeMap = new HashMap<String, NumberRange>();
        int counter = 1;
        for (HostSpec host : eligibleHosts) {
            if (!hostWeightMap.containsKey(host.getHost())) continue;
            int hostWeight = hostWeightMap.get(host.getHost());
            if (hostWeight > 0) {
                int rangeStart = counter;
                int rangeEnd = counter + hostWeight - 1;
                hostWeightRangeMap.put(host.getHost(), new NumberRange(rangeStart, rangeEnd));
                counter += hostWeight;
                continue;
            }
            hostWeightRangeMap.put(host.getHost(), new NumberRange(counter, counter));
            ++counter;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        int randomInt = this.random.nextInt(counter);
        for (HostSpec host : eligibleHosts) {
            NumberRange range = (NumberRange)hostWeightRangeMap.get(host.getHost());
            if (range == null || !range.isInRange(randomInt)) continue;
            return host;
        }
        throw new SQLException(Messages.get("HostSelector.weightedRandomUnableToGetHost", new Object[]{role}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getHostWeightPairMap(String hostWeightMapString) throws SQLException {
        try {
            String[] hostWeightPairs;
            this.lock.lock();
            if (this.cachedHostWeightMapString != null && this.cachedHostWeightMapString.trim().equals(hostWeightMapString.trim()) && this.cachedHostWeightMap != null && !this.cachedHostWeightMap.isEmpty()) {
                Map<String, Integer> map = this.cachedHostWeightMap;
                return map;
            }
            HashMap<String, Integer> hostWeightMap = new HashMap<String, Integer>();
            if (hostWeightMapString == null || hostWeightMapString.trim().isEmpty()) {
                HashMap<String, Integer> hashMap = hostWeightMap;
                return hashMap;
            }
            for (String hostWeightPair : hostWeightPairs = hostWeightMapString.split(",")) {
                Matcher matcher = HOST_WEIGHT_PAIRS_PATTERN.matcher(hostWeightPair);
                if (!matcher.matches()) {
                    throw new SQLException(Messages.get("HostSelector.weightedRandomInvalidHostWeightPairs"));
                }
                String hostName = matcher.group("host").trim();
                String hostWeight = matcher.group("weight").trim();
                if (hostName.isEmpty() || hostWeight.isEmpty()) {
                    throw new SQLException(Messages.get("HostSelector.weightedRandomInvalidHostWeightPairs"));
                }
                try {
                    int weight = Integer.parseInt(hostWeight);
                    if (weight < 1) {
                        throw new SQLException(Messages.get("HostSelector.weightedRandomInvalidHostWeightPairs"));
                    }
                    hostWeightMap.put(hostName, weight);
                }
                catch (NumberFormatException e) {
                    throw new SQLException(Messages.get("HostSelector.roundRobinInvalidHostWeightPairs"));
                }
            }
            this.cachedHostWeightMap = hostWeightMap;
            this.cachedHostWeightMapString = hostWeightMapString;
            HashMap<String, Integer> hashMap = hostWeightMap;
            return hashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class NumberRange {
        private int start;
        private int end;

        public NumberRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean isInRange(int value) {
            return this.start <= value && value <= this.end;
        }
    }
}

