/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class ResultSetMetaDataWrapper
implements ResultSetMetaData {
    protected ResultSetMetaData resultSetMetaData;
    protected ConnectionPluginManager pluginManager;

    public ResultSetMetaDataWrapper(@NonNull ResultSetMetaData resultSetMetaData, @NonNull ConnectionPluginManager pluginManager) {
        this.resultSetMetaData = resultSetMetaData;
        this.pluginManager = pluginManager;
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNCOUNT)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNCOUNT, () -> this.resultSetMetaData.getColumnCount(), new Object[0]);
        }
        return this.resultSetMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISAUTOINCREMENT)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISAUTOINCREMENT, () -> this.resultSetMetaData.isAutoIncrement(column), column);
        }
        return this.resultSetMetaData.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISCASESENSITIVE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISCASESENSITIVE, () -> this.resultSetMetaData.isCaseSensitive(column), column);
        }
        return this.resultSetMetaData.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISSEARCHABLE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISSEARCHABLE, () -> this.resultSetMetaData.isSearchable(column), column);
        }
        return this.resultSetMetaData.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISCURRENCY)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISCURRENCY, () -> this.resultSetMetaData.isCurrency(column), column);
        }
        return this.resultSetMetaData.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISNULLABLE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISNULLABLE, () -> this.resultSetMetaData.isNullable(column), column);
        }
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISSIGNED)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISSIGNED, () -> this.resultSetMetaData.isSigned(column), column);
        }
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNDISPLAYSIZE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNDISPLAYSIZE, () -> this.resultSetMetaData.getColumnDisplaySize(column), column);
        }
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNLABEL)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNLABEL, () -> this.resultSetMetaData.getColumnLabel(column), column);
        }
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNNAME, () -> this.resultSetMetaData.getColumnName(column), column);
        }
        return this.resultSetMetaData.getColumnName(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETSCHEMANAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETSCHEMANAME, () -> this.resultSetMetaData.getSchemaName(column), column);
        }
        return this.resultSetMetaData.getSchemaName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETPRECISION)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETPRECISION, () -> this.resultSetMetaData.getPrecision(column), column);
        }
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETSCALE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETSCALE, () -> this.resultSetMetaData.getScale(column), column);
        }
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETTABLENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETTABLENAME, () -> this.resultSetMetaData.getTableName(column), column);
        }
        return this.resultSetMetaData.getTableName(column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCATALOGNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCATALOGNAME, () -> this.resultSetMetaData.getCatalogName(column), column);
        }
        return this.resultSetMetaData.getCatalogName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNTYPE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNTYPE, () -> this.resultSetMetaData.getColumnType(column), column);
        }
        return this.resultSetMetaData.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNTYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNTYPENAME, () -> this.resultSetMetaData.getColumnTypeName(column), column);
        }
        return this.resultSetMetaData.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISREADONLY)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISREADONLY, () -> this.resultSetMetaData.isReadOnly(column), column);
        }
        return this.resultSetMetaData.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISWRITABLE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISWRITABLE, () -> this.resultSetMetaData.isWritable(column), column);
        }
        return this.resultSetMetaData.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_ISDEFINITELYWRITABLE)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_ISDEFINITELYWRITABLE, () -> this.resultSetMetaData.isDefinitelyWritable(column), column);
        }
        return this.resultSetMetaData.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.RESULTSETMETADATA_GETCOLUMNCLASSNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.resultSetMetaData, JdbcMethod.RESULTSETMETADATA_GETCOLUMNCLASSNAME, () -> this.resultSetMetaData.getColumnClassName(column), column);
        }
        return this.resultSetMetaData.getColumnClassName(column);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.resultSetMetaData.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.resultSetMetaData.isWrapperFor(iface);
    }

    public String toString() {
        return super.toString() + " - " + this.resultSetMetaData;
    }
}

