/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AllowedAndBlockedHosts;
import software.amazon.jdbc.hostlistprovider.Topology;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.events.DataAccessEvent;
import software.amazon.jdbc.util.events.EventPublisher;
import software.amazon.jdbc.util.storage.ExpirationCache;
import software.amazon.jdbc.util.storage.ItemDisposalFunc;
import software.amazon.jdbc.util.storage.ShouldDisposeFunc;
import software.amazon.jdbc.util.storage.StorageService;

public class StorageServiceImpl
implements StorageService {
    private static final Logger LOGGER = Logger.getLogger(StorageServiceImpl.class.getName());
    protected static final long DEFAULT_CLEANUP_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(5L);
    protected static final Map<Class<?>, Supplier<ExpirationCache<Object, ?>>> defaultCacheSuppliers;
    protected final EventPublisher publisher;
    protected final Map<Class<?>, ExpirationCache<Object, ?>> caches = new ConcurrentHashMap();
    protected final ScheduledExecutorService cleanupExecutor = ExecutorFactory.newSingleThreadScheduledThreadExecutor("ssi");

    public StorageServiceImpl(EventPublisher publisher) {
        this(DEFAULT_CLEANUP_INTERVAL_NANOS, publisher);
    }

    public StorageServiceImpl(long cleanupIntervalNanos, EventPublisher publisher) {
        this.publisher = publisher;
        this.initCleanupThread(cleanupIntervalNanos);
    }

    protected void initCleanupThread(long cleanupIntervalNanos) {
        this.cleanupExecutor.scheduleAtFixedRate(this::removeExpiredItems, cleanupIntervalNanos, cleanupIntervalNanos, TimeUnit.NANOSECONDS);
    }

    protected void removeExpiredItems() {
        LOGGER.finest(Messages.get("StorageServiceImpl.removeExpiredItems"));
        for (ExpirationCache<Object, ?> cache : this.caches.values()) {
            cache.removeExpiredEntries();
        }
    }

    @Override
    public <V> void registerItemClassIfAbsent(Class<V> itemClass, boolean isRenewableExpiration, long timeToLiveNanos, @Nullable ShouldDisposeFunc<V> shouldDisposeFunc, @Nullable ItemDisposalFunc<V> itemDisposalFunc) {
        this.caches.computeIfAbsent(itemClass, k -> new ExpirationCache(isRenewableExpiration, timeToLiveNanos, shouldDisposeFunc, itemDisposalFunc));
    }

    @Override
    public <V> void set(Object key, V value) {
        ExpirationCache cache = this.caches.get(value.getClass());
        if (cache == null) {
            Supplier<ExpirationCache<Object, ?>> supplier = defaultCacheSuppliers.get(value.getClass());
            if (supplier == null) {
                throw new IllegalStateException(Messages.get("StorageServiceImpl.itemClassNotRegistered", new Object[]{value.getClass()}));
            }
            cache = this.caches.computeIfAbsent(value.getClass(), c -> (ExpirationCache)supplier.get());
        }
        try {
            ExpirationCache typedCache = cache;
            typedCache.put((Object)key, value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Messages.get("StorageServiceImpl.unexpectedValueMismatch", new Object[]{value, value.getClass(), cache}));
        }
    }

    @Override
    public <V> @Nullable V get(Class<V> itemClass, Object key) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache == null) {
            return null;
        }
        Object value = cache.get(key);
        if (value == null) {
            return null;
        }
        if (itemClass.isInstance(value)) {
            DataAccessEvent event = new DataAccessEvent(itemClass, key);
            this.publisher.publish(event);
            return itemClass.cast(value);
        }
        LOGGER.fine(Messages.get("StorageServiceImpl.itemClassMismatch", new Object[]{key, itemClass, value, value.getClass()}));
        return null;
    }

    @Override
    public boolean exists(Class<?> itemClass, Object key) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache == null) {
            return false;
        }
        return cache.exists(key);
    }

    @Override
    public void remove(Class<?> itemClass, Object key) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache != null) {
            cache.remove(key);
        }
    }

    @Override
    public void clear(Class<?> itemClass) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache != null) {
            cache.clear();
        }
    }

    @Override
    public void clearAll() {
        for (ExpirationCache<Object, ?> cache : this.caches.values()) {
            cache.clear();
        }
    }

    @Override
    public <K, V> @Nullable Map<K, V> getEntries(Class<V> itemClass) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache == null) {
            return null;
        }
        return cache.getEntries();
    }

    @Override
    public int size(Class<?> itemClass) {
        ExpirationCache<Object, ?> cache = this.caches.get(itemClass);
        if (cache == null) {
            return 0;
        }
        return cache.size();
    }

    static {
        HashMap<Class<BlueGreenStatus>, Supplier<ExpirationCache>> suppliers = new HashMap<Class<BlueGreenStatus>, Supplier<ExpirationCache>>();
        suppliers.put(Topology.class, ExpirationCache::new);
        suppliers.put(AllowedAndBlockedHosts.class, ExpirationCache::new);
        suppliers.put(BlueGreenStatus.class, () -> new ExpirationCache(false, TimeUnit.MINUTES.toNanos(60L), null, null));
        defaultCacheSuppliers = Collections.unmodifiableMap(suppliers);
    }
}

