/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.JdbcRunnable;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ArrayWrapper;
import software.amazon.jdbc.wrapper.ArrayWrapperFactory;
import software.amazon.jdbc.wrapper.BlobWrapper;
import software.amazon.jdbc.wrapper.BlobWrapperFactory;
import software.amazon.jdbc.wrapper.CallableStatementWrapper;
import software.amazon.jdbc.wrapper.CallableStatementWrapperFactory;
import software.amazon.jdbc.wrapper.ClobWrapper;
import software.amazon.jdbc.wrapper.ClobWrapperFactory;
import software.amazon.jdbc.wrapper.ConnectionWrapper;
import software.amazon.jdbc.wrapper.DatabaseMetaDataWrapper;
import software.amazon.jdbc.wrapper.DatabaseMetaDataWrapperFactory;
import software.amazon.jdbc.wrapper.NClobWrapper;
import software.amazon.jdbc.wrapper.NClobWrapperFactory;
import software.amazon.jdbc.wrapper.ParameterMetaDataWrapper;
import software.amazon.jdbc.wrapper.ParameterMetaDataWrapperFactory;
import software.amazon.jdbc.wrapper.PreparedStatementWrapper;
import software.amazon.jdbc.wrapper.PreparedStatementWrapperFactory;
import software.amazon.jdbc.wrapper.RefWrapper;
import software.amazon.jdbc.wrapper.RefWrapperFactory;
import software.amazon.jdbc.wrapper.ResultSetMetaDataWrapper;
import software.amazon.jdbc.wrapper.ResultSetMetaDataWrapperFactory;
import software.amazon.jdbc.wrapper.ResultSetWrapper;
import software.amazon.jdbc.wrapper.ResultSetWrapperFactory;
import software.amazon.jdbc.wrapper.SQLDataWrapper;
import software.amazon.jdbc.wrapper.SQLDataWrapperFactory;
import software.amazon.jdbc.wrapper.SQLInputWrapper;
import software.amazon.jdbc.wrapper.SQLInputWrapperFactory;
import software.amazon.jdbc.wrapper.SQLOutputWrapper;
import software.amazon.jdbc.wrapper.SQLOutputWrapperFactory;
import software.amazon.jdbc.wrapper.SQLTypeWrapper;
import software.amazon.jdbc.wrapper.SQLTypeWrapperFactory;
import software.amazon.jdbc.wrapper.SavepointWrapper;
import software.amazon.jdbc.wrapper.SavepointWrapperFactory;
import software.amazon.jdbc.wrapper.StatementWrapper;
import software.amazon.jdbc.wrapper.StatementWrapperFactory;
import software.amazon.jdbc.wrapper.StructWrapper;
import software.amazon.jdbc.wrapper.StructWrapperFactory;
import software.amazon.jdbc.wrapper.WrapperFactory;

public class WrapperUtils {
    private static final ConcurrentMap<Class<?>, Boolean> isJdbcInterfaceCache = new ConcurrentHashMap();
    private static final Map<Class<?>, WrapperFactory> availableWrappers = new HashMap<Class<?>, WrapperFactory>(){
        {
            this.put(CallableStatement.class, new CallableStatementWrapperFactory());
            this.put(PreparedStatement.class, new PreparedStatementWrapperFactory());
            this.put(Statement.class, new StatementWrapperFactory());
            this.put(ResultSet.class, new ResultSetWrapperFactory());
            this.put(Array.class, new ArrayWrapperFactory());
            this.put(Blob.class, new BlobWrapperFactory());
            this.put(NClob.class, new NClobWrapperFactory());
            this.put(Clob.class, new ClobWrapperFactory());
            this.put(Ref.class, new RefWrapperFactory());
            this.put(Struct.class, new StructWrapperFactory());
            this.put(Savepoint.class, new SavepointWrapperFactory());
            this.put(DatabaseMetaData.class, new DatabaseMetaDataWrapperFactory());
            this.put(ParameterMetaData.class, new ParameterMetaDataWrapperFactory());
            this.put(ResultSetMetaData.class, new ResultSetMetaDataWrapperFactory());
            this.put(SQLData.class, new SQLDataWrapperFactory());
            this.put(SQLInput.class, new SQLInputWrapperFactory());
            this.put(SQLOutput.class, new SQLOutputWrapperFactory());
            this.put(SQLType.class, new SQLTypeWrapperFactory());
        }
    };
    private static final Set<Class<?>> allWrapperClasses = new HashSet<Class<?>>(){
        {
            this.add(ArrayWrapper.class);
            this.add(BlobWrapper.class);
            this.add(CallableStatementWrapper.class);
            this.add(ClobWrapper.class);
            this.add(ConnectionWrapper.class);
            this.add(DatabaseMetaDataWrapper.class);
            this.add(NClobWrapper.class);
            this.add(ParameterMetaDataWrapper.class);
            this.add(PreparedStatementWrapper.class);
            this.add(RefWrapper.class);
            this.add(ResultSetMetaDataWrapper.class);
            this.add(ResultSetWrapper.class);
            this.add(SavepointWrapper.class);
            this.add(SQLDataWrapper.class);
            this.add(SQLInputWrapper.class);
            this.add(SQLOutputWrapper.class);
            this.add(SQLTypeWrapper.class);
            this.add(StatementWrapper.class);
            this.add(StructWrapper.class);
        }
    };
    public static final Set<Class<?>> skipWrappingForClasses = new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(String.class);
            this.add(Float.class);
            this.add(Integer.class);
            this.add(BigDecimal.class);
            this.add(Double.class);
            this.add(Date.class);
            this.add(Long.class);
            this.add(Object.class);
            this.add(Short.class);
            this.add(Timer.class);
            this.add(URL.class);
        }
    };
    public static final Set<String> skipWrappingForPackages = new HashSet<String>();

    public static <E extends Exception> void runWithPlugins(Class<E> exceptionClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, JdbcMethod jdbcMethod, JdbcRunnable<E> jdbcMethodFunc, Object ... jdbcMethodArgs) throws E {
        WrapperUtils.executeWithPlugins(Void.TYPE, exceptionClass, pluginManager, methodInvokeOn, jdbcMethod, () -> {
            jdbcMethodFunc.call();
            return null;
        }, jdbcMethodArgs);
    }

    public static <T> T executeWithPlugins(Class<T> resultClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, JdbcMethod jdbcMethod, JdbcCallable<T, RuntimeException> jdbcMethodFunc, Object ... jdbcMethodArgs) {
        if (jdbcMethod.shouldLockConnection) {
            pluginManager.lock();
        }
        TelemetryFactory telemetryFactory = pluginManager.getTelemetryFactory();
        TelemetryContext context = telemetryFactory.openTelemetryContext(jdbcMethod.methodName, TelemetryTraceLevel.TOP_LEVEL);
        try {
            T result;
            block13: {
                T t;
                if (context != null) {
                    context.setAttribute("jdbcCall", jdbcMethod.methodName);
                }
                result = pluginManager.execute(resultClass, RuntimeException.class, methodInvokeOn, jdbcMethod, jdbcMethodFunc, jdbcMethodArgs);
                if (context != null) {
                    context.setSuccess(true);
                }
                try {
                    if (!jdbcMethod.wrapResults) break block13;
                    t = WrapperUtils.wrapWithProxyIfNeeded(resultClass, result, pluginManager);
                }
                catch (InstantiationException e) {
                    if (context != null) {
                        context.setSuccess(false);
                    }
                    throw new RuntimeException(e);
                }
                return t;
            }
            T t = result;
            return t;
        }
        finally {
            if (jdbcMethod.shouldLockConnection) {
                pluginManager.unlock();
            }
            if (context != null) {
                context.closeContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T executeWithPlugins(Class<T> resultClass, Class<E> exceptionClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, JdbcMethod jdbcMethod, JdbcCallable<T, E> jdbcMethodFunc, Object ... jdbcMethodArgs) throws E {
        if (jdbcMethod.shouldLockConnection) {
            pluginManager.lock();
        }
        TelemetryFactory telemetryFactory = pluginManager.getTelemetryFactory();
        TelemetryContext context = telemetryFactory.openTelemetryContext(jdbcMethod.methodName, TelemetryTraceLevel.TOP_LEVEL);
        if (context != null) {
            context.setAttribute("jdbcCall", jdbcMethod.methodName);
        }
        T result = pluginManager.execute(resultClass, exceptionClass, methodInvokeOn, jdbcMethod, jdbcMethodFunc, jdbcMethodArgs);
        if (context != null) {
            context.setSuccess(true);
        }
        if (jdbcMethod.wrapResults) {
            T t;
            try {
                t = WrapperUtils.wrapWithProxyIfNeeded(resultClass, result, pluginManager);
            }
            catch (InstantiationException e) {
                if (context != null) {
                    context.setSuccess(false);
                }
                throw new RuntimeException(e);
            }
            return t;
        }
        T t = result;
        return t;
        finally {
            if (jdbcMethod.shouldLockConnection) {
                pluginManager.unlock();
            }
            if (context != null) {
                context.closeContext();
            }
        }
    }

    public static <T> @Nullable T wrapWithProxyIfNeeded(Class<T> resultClass, @Nullable T toProxy, ConnectionPluginManager pluginManager) throws InstantiationException {
        WrapperFactory wrapperFactory;
        if (toProxy == null) {
            return null;
        }
        Class<?> toProxyClass = toProxy.getClass();
        if (skipWrappingForClasses.contains(toProxyClass) || toProxy instanceof RowId || toProxy instanceof SQLXML || toProxy instanceof InputStream || toProxy instanceof Reader) {
            return toProxy;
        }
        if (allWrapperClasses.contains(toProxy.getClass())) {
            return toProxy;
        }
        Class<Object> effectiveResultClass = resultClass;
        if (resultClass == Statement.class) {
            if (toProxy instanceof CallableStatement) {
                effectiveResultClass = CallableStatement.class;
            } else if (toProxy instanceof PreparedStatement) {
                effectiveResultClass = PreparedStatement.class;
            }
        }
        if ((wrapperFactory = availableWrappers.get(effectiveResultClass)) != null) {
            return resultClass.cast(wrapperFactory.getInstance(toProxy, pluginManager));
        }
        for (Class<?> iface : toProxy.getClass().getInterfaces()) {
            if (!WrapperUtils.isJdbcInterface(iface) || (wrapperFactory = availableWrappers.get(iface)) == null) continue;
            return resultClass.cast(wrapperFactory.getInstance(toProxy, pluginManager));
        }
        if (skipWrappingForPackages.contains(toProxyClass.getPackage().getName())) {
            return toProxy;
        }
        if (WrapperUtils.isJdbcInterface(toProxy.getClass())) {
            throw new RuntimeException(Messages.get("WrapperUtils.noWrapperClassExists", new Object[]{toProxy.getClass().getName()}));
        }
        return toProxy;
    }

    public static boolean isJdbcPackage(@Nullable String packageName) {
        return packageName != null && (packageName.startsWith("java.sql") || packageName.startsWith("javax.sql") || packageName.startsWith("org.postgresql"));
    }

    public static boolean isJdbcInterface(Class<?> clazz) {
        if (isJdbcInterfaceCache.containsKey(clazz)) {
            return (Boolean)isJdbcInterfaceCache.get(clazz);
        }
        if (clazz.isInterface()) {
            try {
                Package classPackage = clazz.getPackage();
                if (classPackage != null && WrapperUtils.isJdbcPackage(classPackage.getName())) {
                    isJdbcInterfaceCache.putIfAbsent(clazz, true);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!WrapperUtils.isJdbcInterface(iface)) continue;
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        if (clazz.getSuperclass() != null && WrapperUtils.isJdbcInterface(clazz.getSuperclass())) {
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        isJdbcInterfaceCache.putIfAbsent(clazz, false);
        return false;
    }

    public static <T> T createInstance(Class<?> classToInstantiate, Class<T> resultClass, Class<?>[] constructorArgClasses, Object ... constructorArgs) throws InstantiationException {
        if (classToInstantiate == null) {
            throw new IllegalArgumentException("classToInstantiate");
        }
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass");
        }
        try {
            if (constructorArgClasses == null || constructorArgClasses.length == 0 || constructorArgs == null || constructorArgs.length == 0) {
                return resultClass.cast(classToInstantiate.newInstance());
            }
            Class<?>[] argClasses = constructorArgClasses;
            if (argClasses == null) {
                argClasses = new Class[constructorArgs.length];
                for (int i = 0; i < constructorArgs.length; ++i) {
                    argClasses[i] = constructorArgs[i].getClass();
                }
            }
            Constructor<?> constructor = classToInstantiate.getConstructor(argClasses);
            return resultClass.cast(constructor.newInstance(constructorArgs));
        }
        catch (Exception e) {
            throw new InstantiationException(Messages.get("WrapperUtils.failedToInitializeClass", new Object[]{classToInstantiate.getName()}));
        }
    }

    public static <T> T createInstance(String className, Class<T> resultClass, Object ... constructorArgs) throws InstantiationException {
        Class<?> loaded;
        if (StringUtils.isNullOrEmpty(className)) {
            throw new IllegalArgumentException("className");
        }
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass");
        }
        try {
            loaded = Class.forName(className);
        }
        catch (Exception e) {
            throw new InstantiationException(Messages.get("WrapperUtils.failedToInitializeClass", new Object[]{className}));
        }
        return WrapperUtils.createInstance(loaded, resultClass, null, constructorArgs);
    }

    public static Object getFieldValue(Object target, String accessor) {
        if (target == null) {
            return null;
        }
        List<String> fieldNames = StringUtils.split(accessor, "\\.", true);
        Class<?> targetClass = target.getClass();
        for (String fieldName : fieldNames) {
            Object fieldValue;
            AccessibleObject field = null;
            while (targetClass != null && field == null) {
                try {
                    field = targetClass.getDeclaredField(fieldName);
                }
                catch (Exception ex) {
                    targetClass = targetClass.getSuperclass();
                }
            }
            if (field == null) {
                return null;
            }
            if (!field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
            try {
                fieldValue = ((Field)field).get(target);
            }
            catch (Exception ex) {
                return null;
            }
            if (fieldValue == null) {
                return null;
            }
            target = fieldValue;
            targetClass = target.getClass();
        }
        return target;
    }

    public static Connection getConnectionFromSqlObject(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Connection) {
                return (Connection)obj;
            }
            if (obj instanceof Statement) {
                Statement stmt = (Statement)obj;
                return !stmt.isClosed() ? stmt.getConnection() : null;
            }
            if (obj instanceof ResultSet) {
                ResultSet rs = (ResultSet)obj;
                Statement stmt = !rs.isClosed() ? rs.getStatement() : null;
                return stmt != null && !stmt.isClosed() ? stmt.getConnection() : null;
            }
        }
        catch (UnsupportedOperationException | SQLException exception) {
            // empty catch block
        }
        return null;
    }

    public static <E extends Exception> E wrapExceptionIfNeeded(Class<E> exceptionClass, Throwable exception) {
        Exception result;
        if (exceptionClass.isAssignableFrom(exception.getClass())) {
            return (E)((Exception)exceptionClass.cast(exception));
        }
        try {
            result = (Exception)WrapperUtils.createInstance(exceptionClass, exceptionClass, new Class[]{Throwable.class}, exception);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        return (E)((Exception)exceptionClass.cast(result));
    }
}

