/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public class PropertyUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyUtils.class.getName());
    private static final Set<Object> SECRET_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList(PropertyDefinition.PASSWORD.name)));

    public static void applyProperties(Object target, Properties properties) {
        if (target == null || properties == null) {
            return;
        }
        List<Method> methods = Arrays.asList(target.getClass().getMethods());
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            String propName = key.toString();
            Object propValue = properties.getProperty(propName);
            if (propValue == null) {
                propValue = properties.get(key);
            }
            PropertyUtils.setPropertyOnTarget(target, propName, propValue, methods);
        }
    }

    public static void setPropertyOnTarget(Object target, String propName, Object propValue, List<Method> methods) {
        Method writeMethod = null;
        String methodName = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
            writeMethod = method;
            break;
        }
        if (writeMethod == null) {
            methodName = "set" + propName.toUpperCase();
            for (Method method : methods) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
                writeMethod = method;
                break;
            }
        }
        if (writeMethod == null) {
            LOGGER.finest(() -> Messages.get("PropertyUtils.setMethodDoesNotExistOnTarget", new Object[]{propName, target.getClass()}));
            return;
        }
        try {
            Class<?> paramClass = writeMethod.getParameterTypes()[0];
            if (paramClass == String.class) {
                writeMethod.invoke(target, propValue.toString());
            } else if (paramClass == Integer.TYPE) {
                writeMethod.invoke(target, Integer.parseInt(propValue.toString()));
            } else if (paramClass == Long.TYPE) {
                writeMethod.invoke(target, Long.parseLong(propValue.toString()));
            } else if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                writeMethod.invoke(target, Boolean.parseBoolean(propValue.toString()));
            } else {
                writeMethod.invoke(target, propValue);
            }
            Object cleanPropValue = PropertyUtils.isSecretProperty(propName) ? "***" : propValue;
            LOGGER.finest(() -> String.format("Set property '%s' with value: %s", propName, cleanPropValue));
        }
        catch (InvocationTargetException ex) {
            LOGGER.warning(() -> Messages.get("PropertyUtils.failedToSetPropertyWithReason", new Object[]{propName, target.getClass(), ex.getCause().getMessage()}));
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception e) {
            LOGGER.warning(() -> Messages.get("PropertyUtils.failedToSetProperty", new Object[]{propName, target.getClass()}));
            throw new RuntimeException(e);
        }
    }

    public static @NonNull Properties copyProperties(Properties props) {
        Properties copy = new Properties();
        if (props == null) {
            return copy;
        }
        return PropertyUtils.addProperties(copy, props);
    }

    public static @NonNull Properties addProperties(Properties dest, Properties propsToAdd) {
        if (propsToAdd == null) {
            return dest;
        }
        for (Map.Entry<Object, Object> entry : propsToAdd.entrySet()) {
            dest.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return dest;
    }

    private static boolean isSecretProperty(Object propertyKey) {
        return SECRET_PROPERTIES.contains(propertyKey);
    }

    public static @NonNull Properties maskProperties(Properties props) {
        Properties maskedProperties = PropertyUtils.copyProperties(props);
        if (maskedProperties.containsKey(PropertyDefinition.PASSWORD.name)) {
            maskedProperties.setProperty(PropertyDefinition.PASSWORD.name, "***");
        }
        return maskedProperties;
    }

    public static String logProperties(Properties props, String caption) {
        StringBuilder sb = new StringBuilder();
        for (Object key : props.keySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("[").append(key.toString()).append("] ").append(props.get(key).toString());
        }
        if (sb.length() == 0) {
            sb.append("<empty>");
        }
        if (caption != null) {
            sb.insert(0, caption);
        }
        return sb.toString();
    }

    public static Integer getIntegerPropertyValue(@NonNull Properties props, @NonNull AwsWrapperProperty wrapperProperty) {
        Integer result = null;
        if (!StringUtils.isNullOrEmpty(wrapperProperty.getString(props))) {
            result = wrapperProperty.getInteger(props);
        }
        return result;
    }

    public static Boolean getBooleanPropertyValue(@NonNull Properties props, @NonNull AwsWrapperProperty wrapperProperty) {
        Boolean result = null;
        if (!StringUtils.isNullOrEmpty(wrapperProperty.getString(props))) {
            result = wrapperProperty.getBoolean(props);
        }
        return result;
    }
}

