/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.failover.ClusterAwareReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ClusterAwareWriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.FailoverFailedSQLException;
import software.amazon.jdbc.plugin.failover.FailoverMode;
import software.amazon.jdbc.plugin.failover.FailoverSuccessSQLException;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.plugin.failover.TransactionStateUnknownSQLException;
import software.amazon.jdbc.plugin.failover.WriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.WriterFailoverResult;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsHelper;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class FailoverConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(FailoverConnectionPlugin.class.getName());
    private static final String TELEMETRY_WRITER_FAILOVER = "failover to writer node";
    private static final String TELEMETRY_READER_FAILOVER = "failover to replica";
    private static final Set<String> METHODS_REQUIRING_UPDATED_TOPOLOGY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JdbcMethod.CONNECTION_COMMIT.methodName, JdbcMethod.CONNECT.methodName, JdbcMethod.CONNECTION_ISVALID.methodName, JdbcMethod.CONNECTION_SETAUTOCOMMIT.methodName, JdbcMethod.CONNECTION_SETREADONLY.methodName, JdbcMethod.STATEMENT_EXECUTE.methodName, JdbcMethod.STATEMENT_EXECUTEBATCH.methodName, JdbcMethod.STATEMENT_EXECUTEQUERY.methodName, JdbcMethod.STATEMENT_EXECUTEUPDATE.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTE.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTEBATCH.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTELARGEUPDATE.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTEQUERY.methodName, JdbcMethod.PREPAREDSTATEMENT_EXECUTEUPDATE.methodName, JdbcMethod.PREPAREDSTATEMENT_GETPARAMETERMETADATA.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTE.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTELARGEUPDATE.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTEQUERY.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTEUPDATE.methodName, JdbcMethod.CALLABLESTATEMENT_EXECUTEBATCH.methodName)));
    private final Set<String> subscribedMethods;
    private final PluginService pluginService;
    protected final Properties properties;
    protected boolean enableFailoverSetting;
    protected boolean enableConnectFailover;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected FailoverMode failoverMode;
    private boolean telemetryFailoverAdditionalTopTraceSetting;
    private final AtomicBoolean closedExplicitly = new AtomicBoolean(false);
    protected boolean isClosed = false;
    protected String closedReason = null;
    private final RdsUtils rdsHelper;
    protected WriterFailoverHandler writerFailoverHandler = null;
    protected ReaderFailoverHandler readerFailoverHandler = null;
    private Throwable lastExceptionDealtWith = null;
    private PluginManagerService pluginManagerService;
    private boolean isInTransaction = false;
    private RdsUrlType rdsUrlType = null;
    private HostListProviderService hostListProviderService;
    private final AuroraStaleDnsHelper staleDnsHelper;
    private Supplier<WriterFailoverHandler> writerFailoverHandlerSupplier;
    private Supplier<ReaderFailoverHandler> readerFailoverHandlerSupplier;
    public static final AwsWrapperProperty FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS = new AwsWrapperProperty("failoverClusterTopologyRefreshRateMs", "2000", "Cluster topology refresh rate in millis during a writer failover process. During the writer failover process, cluster topology may be refreshed at a faster pace than normal to speed up discovery of the newly promoted writer.");
    public static final AwsWrapperProperty FAILOVER_TIMEOUT_MS = new AwsWrapperProperty("failoverTimeoutMs", "300000", "Maximum allowed time for the failover process.");
    public static final AwsWrapperProperty FAILOVER_WRITER_RECONNECT_INTERVAL_MS = new AwsWrapperProperty("failoverWriterReconnectIntervalMs", "2000", "Interval of time to wait between attempts to reconnect to a failed writer during a writer failover process.");
    public static final AwsWrapperProperty FAILOVER_READER_CONNECT_TIMEOUT_MS = new AwsWrapperProperty("failoverReaderConnectTimeoutMs", "30000", "Reader connection attempt timeout during a reader failover process.");
    public static final AwsWrapperProperty ENABLE_CLUSTER_AWARE_FAILOVER = new AwsWrapperProperty("enableClusterAwareFailover", "true", "Enable/disable cluster-aware failover logic");
    public static final AwsWrapperProperty ENABLE_CONNECT_FAILOVER = new AwsWrapperProperty("enableConnectFailover", "false", "Enable/disable cluster-aware failover if the initial connection to the database fails due to a network exception. Note that this may result in a connection to a different instance in the cluster than was specified by the URL.");
    public static final AwsWrapperProperty FAILOVER_MODE = new AwsWrapperProperty("failoverMode", null, "Set node role to follow during failover.");
    public static final AwsWrapperProperty TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE = new AwsWrapperProperty("telemetryFailoverAdditionalTopTrace", "false", "Post an additional top-level trace for failover process.");
    public static final AwsWrapperProperty SKIP_FAILOVER_ON_INTERRUPTED_THREAD = new AwsWrapperProperty("skipFailoverOnInterruptedThread", "false", "Enable to skip failover if the current thread is interrupted.");
    private final TelemetryCounter failoverWriterTriggeredCounter;
    private final TelemetryCounter failoverWriterSuccessCounter;
    private final TelemetryCounter failoverWriterFailedCounter;
    private final TelemetryCounter failoverReaderTriggeredCounter;
    private final TelemetryCounter failoverReaderSuccessCounter;
    private final TelemetryCounter failoverReaderFailedCounter;
    private boolean skipFailoverOnInterruptedThread;

    public FailoverConnectionPlugin(PluginService pluginService, Properties properties) {
        this(pluginService, properties, new RdsUtils());
    }

    FailoverConnectionPlugin(PluginService pluginService, Properties properties, RdsUtils rdsHelper) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.rdsHelper = rdsHelper;
        if (pluginService instanceof PluginManagerService) {
            this.pluginManagerService = (PluginManagerService)((Object)pluginService);
        }
        this.initSettings();
        this.staleDnsHelper = new AuroraStaleDnsHelper(this.pluginService);
        HashSet<String> methods = new HashSet<String>();
        if (this.enableFailoverSetting) {
            methods.add(JdbcMethod.CONNECTION_CLOSE.methodName);
            methods.add(JdbcMethod.CONNECTION_ABORT.methodName);
            methods.add(JdbcMethod.CONNECTION_CLEARWARNINGS.methodName);
            methods.add(JdbcMethod.INITHOSTPROVIDER.methodName);
            methods.add(JdbcMethod.CONNECT.methodName);
            methods.add(JdbcMethod.NOTIFYCONNECTIONCHANGED.methodName);
            methods.add(JdbcMethod.NOTIFYNODELISTCHANGED.methodName);
            methods.addAll(this.pluginService.getTargetDriverDialect().getNetworkBoundMethodNames(this.properties));
        }
        this.subscribedMethods = Collections.unmodifiableSet(methods);
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        this.failoverWriterTriggeredCounter = telemetryFactory.createCounter("writerFailover.triggered.count");
        this.failoverWriterSuccessCounter = telemetryFactory.createCounter("writerFailover.completed.success.count");
        this.failoverWriterFailedCounter = telemetryFactory.createCounter("writerFailover.completed.failed.count");
        this.failoverReaderTriggeredCounter = telemetryFactory.createCounter("readerFailover.triggered.count");
        this.failoverReaderSuccessCounter = telemetryFactory.createCounter("readerFailover.completed.success.count");
        this.failoverReaderFailedCounter = telemetryFactory.createCounter("readerFailover.completed.failed.count");
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return this.subscribedMethods;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        try {
            if (this.enableFailoverSetting && !this.canDirectExecute(methodName) && !this.closedExplicitly.get() && this.pluginService.getCurrentConnection() != null && this.pluginService.getCurrentConnection().isClosed()) {
                this.pickNewConnection();
            }
        }
        catch (SQLException ex) {
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
        }
        if (!this.enableFailoverSetting || this.canDirectExecute(methodName)) {
            T result = jdbcMethodFunc.call();
            if (JdbcMethod.CONNECTION_ABORT.methodName.equals(methodName) || JdbcMethod.CONNECTION_CLOSE.methodName.equals(methodName)) {
                this.closedExplicitly.set(true);
            }
            return result;
        }
        if (this.isClosed && !this.allowedOnClosedConnection(methodName)) {
            try {
                this.invalidInvocationOnClosedConnection();
            }
            catch (SQLException ex) {
                throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
            }
        }
        T result = null;
        try {
            if (this.canUpdateTopology(methodName)) {
                this.updateTopology(false);
            }
            result = jdbcMethodFunc.call();
            if (JdbcMethod.CONNECTION_ABORT.methodName.equals(methodName) || JdbcMethod.CONNECTION_CLOSE.methodName.equals(methodName)) {
                this.closedExplicitly.set(true);
            }
        }
        catch (IllegalStateException e) {
            this.dealWithIllegalStateException(e, exceptionClass);
        }
        catch (Exception e) {
            this.dealWithOriginalException(e, null, exceptionClass);
        }
        return result;
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties properties, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.initHostProvider(hostListProviderService, initHostProviderFunc, () -> new ClusterAwareReaderFailoverHandler(this.pluginService, this.properties, this.failoverTimeoutMsSetting, this.failoverReaderConnectTimeoutMsSetting, this.failoverMode == FailoverMode.STRICT_READER), () -> new ClusterAwareWriterFailoverHandler(this.pluginService, this.readerFailoverHandler, this.properties, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting));
    }

    void initHostProvider(HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc, Supplier<ReaderFailoverHandler> readerFailoverHandlerSupplier, Supplier<WriterFailoverHandler> writerFailoverHandlerSupplier) throws SQLException {
        this.readerFailoverHandlerSupplier = readerFailoverHandlerSupplier;
        this.writerFailoverHandlerSupplier = writerFailoverHandlerSupplier;
        this.hostListProviderService = hostListProviderService;
        if (!this.enableFailoverSetting) {
            return;
        }
        initHostProviderFunc.call();
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        HostSpec currentHost;
        String url;
        if (!this.enableFailoverSetting) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder("Changes:");
            for (Map.Entry<String, EnumSet<NodeChangeOptions>> change : changes.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(String.format("\tHost '%s': %s", change.getKey(), change.getValue()));
            }
            LOGGER.finest(sb.toString());
        }
        if (this.isNodeStillValid(url = (currentHost = this.pluginService.getCurrentHostSpec()).getUrl(), changes)) {
            return;
        }
        for (String alias : currentHost.getAliases()) {
            if (!this.isNodeStillValid(alias + "/", changes)) continue;
            return;
        }
        LOGGER.fine(() -> Messages.get("Failover.invalidNode", new Object[]{currentHost}));
    }

    private boolean isNodeStillValid(String node, Map<String, EnumSet<NodeChangeOptions>> changes) {
        if (changes.containsKey(node)) {
            EnumSet<NodeChangeOptions> options = changes.get(node);
            return !options.contains((Object)NodeChangeOptions.NODE_DELETED) && !options.contains((Object)NodeChangeOptions.WENT_DOWN);
        }
        return true;
    }

    public boolean isFailoverEnabled() {
        return this.enableFailoverSetting && !RdsUrlType.RDS_PROXY.equals((Object)this.rdsUrlType) && !Utils.isNullOrEmpty(this.pluginService.getAllHosts());
    }

    private void initSettings() {
        this.enableFailoverSetting = ENABLE_CLUSTER_AWARE_FAILOVER.getBoolean(this.properties);
        this.enableConnectFailover = ENABLE_CONNECT_FAILOVER.getBoolean(this.properties);
        this.failoverTimeoutMsSetting = FAILOVER_TIMEOUT_MS.getInteger(this.properties);
        this.failoverClusterTopologyRefreshRateMsSetting = FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInteger(this.properties);
        this.failoverWriterReconnectIntervalMsSetting = FAILOVER_WRITER_RECONNECT_INTERVAL_MS.getInteger(this.properties);
        this.failoverReaderConnectTimeoutMsSetting = FAILOVER_READER_CONNECT_TIMEOUT_MS.getInteger(this.properties);
        this.telemetryFailoverAdditionalTopTraceSetting = TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE.getBoolean(this.properties);
        this.skipFailoverOnInterruptedThread = SKIP_FAILOVER_ON_INTERRUPTED_THREAD.getBoolean(this.properties);
    }

    protected void initFailoverMode() {
        if (this.rdsUrlType == null) {
            this.failoverMode = FailoverMode.fromValue(FAILOVER_MODE.getString(this.properties));
            HostSpec initialHostSpec = this.hostListProviderService.getInitialConnectionHostSpec();
            this.rdsUrlType = this.rdsHelper.identifyRdsType(initialHostSpec.getHost());
            if (this.failoverMode == null) {
                this.failoverMode = this.rdsUrlType == RdsUrlType.RDS_READER_CLUSTER ? FailoverMode.READER_OR_WRITER : FailoverMode.STRICT_WRITER;
            }
            LOGGER.finer(() -> Messages.get("Failover.parameterValue", new Object[]{"failoverMode", this.failoverMode}));
        }
    }

    private void invalidInvocationOnClosedConnection() throws SQLException {
        if (!this.closedExplicitly.get()) {
            this.isClosed = false;
            this.closedReason = null;
            this.pickNewConnection();
            LOGGER.info(Messages.get("Failover.connectionChangedError"));
            throw new FailoverSuccessSQLException();
        }
        String reason = Messages.get("Failover.noOperationsAfterConnectionClosed");
        if (this.closedReason != null) {
            reason = reason + " " + this.closedReason;
        }
        throw new SQLException(reason, SqlState.CONNECTION_NOT_OPEN.getState());
    }

    private HostSpec getCurrentWriter() throws SQLException {
        List<HostSpec> topology = this.pluginService.getAllHosts();
        if (topology == null) {
            return null;
        }
        return this.getWriter(topology);
    }

    private HostSpec getWriter(@NonNull List<HostSpec> hosts) {
        for (HostSpec hostSpec : hosts) {
            if (hostSpec.getRole() != HostRole.WRITER) continue;
            return hostSpec;
        }
        return null;
    }

    protected void updateTopology(boolean forceUpdate) throws SQLException {
        Connection connection = this.pluginService.getCurrentConnection();
        if (!this.isFailoverEnabled() || connection == null || connection.isClosed()) {
            return;
        }
        if (forceUpdate) {
            this.pluginService.forceRefreshHostList();
        } else {
            this.pluginService.refreshHostList();
        }
    }

    private boolean allowedOnClosedConnection(String methodName) {
        TargetDriverDialect dialect = this.pluginService.getTargetDriverDialect();
        return dialect.getAllowedOnConnectionMethodNames().contains(methodName);
    }

    private boolean canUpdateTopology(String methodName) {
        return METHODS_REQUIRING_UPDATED_TOPOLOGY.contains(methodName);
    }

    private void connectTo(HostSpec host) throws SQLException {
        try {
            this.pluginService.setCurrentConnection(this.createConnectionForHost(host), host);
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{host}));
        }
        catch (SQLException e) {
            if (this.pluginService.getCurrentConnection() != null) {
                String msg = "Connection to " + (this.isWriter(host) ? "writer" : "reader") + " host '" + host.getUrl() + "' failed";
                LOGGER.warning(() -> String.format("%s: %s", msg, e.getMessage()));
            }
            throw e;
        }
    }

    private boolean isWriter(HostSpec hostSpec) {
        return hostSpec.getRole() == HostRole.WRITER;
    }

    private void throwFailoverFailedException(String message) throws SQLException {
        LOGGER.severe(message);
        throw new FailoverFailedSQLException(message);
    }

    private boolean shouldAttemptReaderConnection() {
        List<HostSpec> topology = this.pluginService.getHosts();
        if (Utils.isNullOrEmpty(topology) || this.failoverMode == FailoverMode.STRICT_WRITER) {
            return false;
        }
        for (HostSpec hostSpec : topology) {
            if (hostSpec.getRole() != HostRole.READER) continue;
            return true;
        }
        return false;
    }

    private <E extends Exception> void dealWithOriginalException(Throwable originalException, Throwable wrapperException, Class<E> exceptionClass) throws E {
        Throwable exceptionToThrow = wrapperException;
        if (originalException != null) {
            LOGGER.finer(() -> Messages.get("Failover.detectedException", new Object[]{originalException.getMessage()}));
            if (this.lastExceptionDealtWith != originalException && this.shouldExceptionTriggerConnectionSwitch(originalException)) {
                this.invalidateCurrentConnection();
                this.pluginService.setAvailability(this.pluginService.getCurrentHostSpec().getAliases(), HostAvailability.NOT_AVAILABLE);
                try {
                    this.pickNewConnection();
                }
                catch (SQLException e) {
                    throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, e);
                }
                this.lastExceptionDealtWith = originalException;
            }
            if (originalException instanceof Error) {
                throw (Error)originalException;
            }
            exceptionToThrow = originalException;
        }
        if (exceptionToThrow instanceof Error) {
            throw (Error)exceptionToThrow;
        }
        throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, exceptionToThrow);
    }

    protected Connection createConnectionForHost(HostSpec baseHostSpec) throws SQLException {
        return this.pluginService.connect(baseHostSpec, this.properties);
    }

    protected <E extends Exception> void dealWithIllegalStateException(IllegalStateException e, Class<E> exceptionClass) throws E {
        this.dealWithOriginalException(e.getCause(), e, exceptionClass);
    }

    protected void failover(HostSpec failedHost) throws SQLException {
        this.pluginService.setAvailability(failedHost.asAliases(), HostAvailability.NOT_AVAILABLE);
        if (this.failoverMode == FailoverMode.STRICT_WRITER) {
            this.failoverWriter();
        } else {
            this.failoverReader(failedHost);
        }
    }

    protected void failoverReader(HostSpec failedHostSpec) throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_READER_FAILOVER, TelemetryTraceLevel.NESTED);
        if (this.failoverReaderTriggeredCounter != null) {
            this.failoverReaderTriggeredCounter.inc();
        }
        long failoverStartNano = System.nanoTime();
        try {
            SQLException exception;
            ReaderFailoverResult result;
            LOGGER.fine(() -> Messages.get("Failover.startReaderFailover"));
            HostSpec failedHost = null;
            Set<String> oldAliases = this.pluginService.getCurrentHostSpec().getAliases();
            if (failedHostSpec != null && failedHostSpec.getRawAvailability() == HostAvailability.AVAILABLE) {
                failedHost = failedHostSpec;
            }
            if ((result = this.readerFailoverHandler.failover(this.pluginService.getHosts(), failedHost)) != null && (exception = result.getException()) != null) {
                throw exception;
            }
            if (result == null || !result.isConnected()) {
                this.throwFailoverFailedException(Messages.get("Failover.unableToConnectToReader"));
                return;
            }
            this.pluginService.setCurrentConnection(result.getConnection(), result.getHost());
            this.pluginService.getCurrentHostSpec().removeAlias(oldAliases.toArray(new String[0]));
            this.updateTopology(true);
            LOGGER.info(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.throwFailoverSuccessException();
        }
        catch (FailoverSuccessSQLException ex) {
            if (this.failoverReaderSuccessCounter != null) {
                this.failoverReaderSuccessCounter.inc();
            }
            if (telemetryContext != null) {
                telemetryContext.setSuccess(true);
                telemetryContext.setException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(false);
                telemetryContext.setException(ex);
            }
            if (this.failoverReaderFailedCounter != null) {
                this.failoverReaderFailedCounter.inc();
            }
            throw ex;
        }
        finally {
            LOGGER.finest(() -> Messages.get("Failover.readerFailoverElapsed", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - failoverStartNano)}));
            if (telemetryContext != null) {
                telemetryContext.closeContext();
                if (this.telemetryFailoverAdditionalTopTraceSetting) {
                    telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
                }
            }
        }
    }

    protected void throwFailoverSuccessException() throws SQLException {
        if (this.isInTransaction || this.pluginService.isInTransaction()) {
            if (this.pluginManagerService != null) {
                this.pluginManagerService.setInTransaction(false);
            }
            String errorMessage = Messages.get("Failover.transactionResolutionUnknownError");
            LOGGER.info(errorMessage);
            throw new TransactionStateUnknownSQLException();
        }
        LOGGER.severe(() -> Messages.get("Failover.connectionChangedError"));
        throw new FailoverSuccessSQLException();
    }

    protected void failoverWriter() throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_WRITER_FAILOVER, TelemetryTraceLevel.NESTED);
        if (this.failoverWriterTriggeredCounter != null) {
            this.failoverWriterTriggeredCounter.inc();
        }
        long failoverStartTimeNano = System.nanoTime();
        try {
            SQLException exception;
            LOGGER.info(() -> Messages.get("Failover.startWriterFailover"));
            WriterFailoverResult failoverResult = this.writerFailoverHandler.failover(this.pluginService.getAllHosts());
            if (failoverResult != null && (exception = failoverResult.getException()) != null) {
                throw exception;
            }
            if (failoverResult == null || !failoverResult.isConnected()) {
                this.throwFailoverFailedException(Messages.get("Failover.unableToConnectToWriter"));
                return;
            }
            List<HostSpec> hosts = failoverResult.getTopology();
            HostSpec writerHostSpec = this.getWriter(hosts);
            if (writerHostSpec == null) {
                this.throwFailoverFailedException(Messages.get("Failover.noWriterHostAfterReconnecting", new Object[]{Utils.logTopology(hosts, "")}));
                return;
            }
            List<HostSpec> allowedHosts = this.pluginService.getHosts();
            if (!Utils.containsHostAndPort(allowedHosts, writerHostSpec.getHostAndPort())) {
                this.throwFailoverFailedException(Messages.get("Failover.newWriterNotAllowed", new Object[]{writerHostSpec.getUrl(), Utils.logTopology(allowedHosts, "")}));
                return;
            }
            this.pluginService.setCurrentConnection(failoverResult.getNewConnection(), writerHostSpec);
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.pluginService.refreshHostList();
            this.throwFailoverSuccessException();
        }
        catch (FailoverSuccessSQLException ex) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(true);
                telemetryContext.setException(ex);
            }
            if (this.failoverWriterSuccessCounter != null) {
                this.failoverWriterSuccessCounter.inc();
            }
            throw ex;
        }
        catch (Exception ex) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(false);
                telemetryContext.setException(ex);
            }
            if (this.failoverWriterFailedCounter != null) {
                this.failoverWriterFailedCounter.inc();
            }
            throw ex;
        }
        finally {
            LOGGER.finest(() -> Messages.get("Failover.writerFailoverElapsed", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - failoverStartTimeNano)}));
            if (telemetryContext != null) {
                telemetryContext.closeContext();
                if (this.telemetryFailoverAdditionalTopTraceSetting) {
                    telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
                }
            }
        }
    }

    protected void invalidateCurrentConnection() {
        Connection conn = this.pluginService.getCurrentConnection();
        if (conn == null) {
            return;
        }
        if (this.pluginService.isInTransaction()) {
            this.isInTransaction = this.pluginService.isInTransaction();
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly.get()) {
            LOGGER.fine(() -> Messages.get("Failover.transactionResolutionUnknownError"));
            return;
        }
        if (this.pluginService.getCurrentConnection() == null && !this.shouldAttemptReaderConnection()) {
            try {
                this.connectTo(this.getCurrentWriter());
            }
            catch (SQLException e) {
                this.failover(this.getCurrentWriter());
            }
        } else {
            this.failover(this.pluginService.getCurrentHostSpec());
        }
    }

    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (this.closedExplicitly.get()) {
            return false;
        }
        if (!this.isFailoverEnabled()) {
            LOGGER.fine(() -> Messages.get("Failover.failoverDisabled"));
            return false;
        }
        if (this.skipFailoverOnInterruptedThread && Thread.currentThread().isInterrupted()) {
            LOGGER.fine(() -> Messages.get("Failover.skipFailoverOnInterruptedThread"));
            return false;
        }
        String sqlState = null;
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        }
        if (sqlState == null) {
            return false;
        }
        return this.pluginService.isNetworkException(t, this.pluginService.getTargetDriverDialect());
    }

    private boolean canDirectExecute(String methodName) {
        return methodName.equals(JdbcMethod.CONNECTION_CLOSE.methodName) || methodName.equals(JdbcMethod.CONNECTION_ISCLOSED.methodName) || methodName.equals(JdbcMethod.CONNECTION_ABORT.methodName);
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        this.initFailoverMode();
        if (this.readerFailoverHandler == null) {
            if (this.readerFailoverHandlerSupplier == null) {
                throw new SQLException(Messages.get("Failover.nullReaderFailoverHandlerSupplier"));
            }
            this.readerFailoverHandler = this.readerFailoverHandlerSupplier.get();
        }
        if (this.writerFailoverHandler == null) {
            if (this.writerFailoverHandlerSupplier == null) {
                throw new SQLException(Messages.get("Failover.nullWriterFailoverHandlerSupplier"));
            }
            this.writerFailoverHandler = this.writerFailoverHandlerSupplier.get();
        }
        Connection conn = null;
        try {
            conn = this.staleDnsHelper.getVerifiedConnection(isInitialConnection, this.hostListProviderService, driverProtocol, hostSpec, props, connectFunc);
        }
        catch (SQLException e) {
            if (!this.enableConnectFailover || !this.shouldExceptionTriggerConnectionSwitch(e)) {
                throw e;
            }
            try {
                this.failover(this.pluginService.getCurrentHostSpec());
            }
            catch (FailoverSuccessSQLException failoverSuccessException) {
                conn = this.pluginService.getCurrentConnection();
            }
        }
        if (conn == null) {
            throw new SQLException(Messages.get("Failover.unableToConnect"));
        }
        if (isInitialConnection) {
            this.pluginService.refreshHostList(conn);
        }
        return conn;
    }

    void setRdsUrlType(RdsUrlType rdsUrlType) {
        this.rdsUrlType = rdsUrlType;
    }

    void setWriterFailoverHandler(WriterFailoverHandler writerFailoverHandler) {
        this.writerFailoverHandler = writerFailoverHandler;
    }

    void setReaderFailoverHandler(ReaderFailoverHandler readerFailoverHandler) {
        this.readerFailoverHandler = readerFailoverHandler;
    }

    static {
        PropertyDefinition.registerPluginProperties(FailoverConnectionPlugin.class);
    }
}

