/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package software.amazon.jdbc;

@SuppressWarnings("SpellCheckingInspection")
public enum JdbcMethod {
  ARRAY_GETBASETYPENAME(0, "Array.getBaseTypeName",
      false, false, true, false),
  ARRAY_GETBASETYPE(1, "Array.getBaseType",
      false, false, true, false),
  ARRAY_GETARRAY(2, "Array.getArray",
      false, false, true, false),
  ARRAY_GETRESULTSET(3, "Array.getResultSet",
      false, true, true, false),
  ARRAY_FREE(4, "Array.free",
      false, false, true, false),


  BLOB_LENGTH(5, "Blob.length",
      false, false, true, false),
  BLOB_GETBYTES(6, "Blob.getBytes",
      false, false, true, false),
  BLOB_GETBINARYSTREAM(7, "Blob.getBinaryStream",
      false, false, true, false),
  BLOB_POSITION(8, "Blob.position",
      false, false, true, false),
  BLOB_SETBYTES(9, "Blob.setBytes",
      false, false, true, false),
  BLOB_SETBINARYSTREAM(10, "Blob.setBinaryStream",
      false, false, true, false),
  BLOB_TRUNCATE(11, "Blob.truncate",
      false, false, true, false),
  BLOB_FREE(12, "Blob.free",
      false, false, true, false),


  CALLABLESTATEMENT_ADDBATCH(13, "CallableStatement.addBatch",
      false, false, true, false),
  CALLABLESTATEMENT_CANCEL(14, "CallableStatement.cancel",
      false, false, false, true),
  CALLABLESTATEMENT_CLEARBATCH(15, "CallableStatement.clearBatch",
      false, false, true, false),
  CALLABLESTATEMENT_CLEARPARAMETERS(16, "CallableStatement.clearParameters",
      false, false, true, false),
  CALLABLESTATEMENT_CLEARWARNINGS(17, "CallableStatement.clearWarnings",
      false, false, true, false),
  CALLABLESTATEMENT_CLOSE(18, "CallableStatement.close",
      false, false, true, false),
  CALLABLESTATEMENT_CLOSEONCOMPLETION(19, "CallableStatement.closeOnCompletion",
      false, false, true, false),
  CALLABLESTATEMENT_EXECUTE(20, "CallableStatement.execute",
      false, false, true, true),
  CALLABLESTATEMENT_EXECUTEBATCH(21, "CallableStatement.executeBatch",
      false, false, true, true),
  CALLABLESTATEMENT_EXECUTELARGEUPDATE(22, "CallableStatement.executeLargeUpdate",
      false, false, true, true),
  CALLABLESTATEMENT_EXECUTEQUERY(23, "CallableStatement.executeQuery",
      false, true, true, true),
  CALLABLESTATEMENT_EXECUTEUPDATE(24, "CallableStatement.executeUpdate",
      false, false, true, true),
  CALLABLESTATEMENT_GETARRAY(25, "CallableStatement.getArray",
      false, true, true, false),
  CALLABLESTATEMENT_GETBIGDECIMAL(26, "CallableStatement.getBigDecimal",
      false, false, true, false),
  CALLABLESTATEMENT_GETBLOB(27, "CallableStatement.getBlob",
      false, true, true, false),
  CALLABLESTATEMENT_GETBOOLEAN(28, "CallableStatement.getBoolean",
      false, false, true, false),
  CALLABLESTATEMENT_GETBYTE(29, "CallableStatement.getByte",
      false, false, true, false),
  CALLABLESTATEMENT_GETBYTES(30, "CallableStatement.getBytes",
      false, false, true, false),
  CALLABLESTATEMENT_GETCHARACTERSTREAM(31, "CallableStatement.getCharacterStream",
      false, false, true, false),
  CALLABLESTATEMENT_GETCLOB(32, "CallableStatement.getClob",
      false, true, true, false),
  CALLABLESTATEMENT_GETCONNECTION(33, "CallableStatement.getConnection",
      false, true, true, true),
  CALLABLESTATEMENT_GETDATE(34, "CallableStatement.getDate",
      false, false, true, false),
  CALLABLESTATEMENT_GETDOUBLE(35, "CallableStatement.getDouble",
      false, false, true, false),
  CALLABLESTATEMENT_GETFETCHDIRECTION(36, "CallableStatement.getFetchDirection",
      false, false, true, false),
  CALLABLESTATEMENT_GETFETCHSIZE(37, "CallableStatement.getFetchSize",
      false, false, true, false),
  CALLABLESTATEMENT_GETFLOAT(38, "CallableStatement.getFloat",
      false, false, true, false),
  CALLABLESTATEMENT_GETGENERATEDKEYS(39, "CallableStatement.getGeneratedKeys",
      false, true, true, false),
  CALLABLESTATEMENT_GETINT(40, "CallableStatement.getInt",
      false, false, true, false),
  CALLABLESTATEMENT_GETLONG(41, "CallableStatement.getLong",
      false, false, true, false),
  CALLABLESTATEMENT_GETMAXFIELDSIZE(42, "CallableStatement.getMaxFieldSize",
      false, false, true, false),
  CALLABLESTATEMENT_GETMAXROWS(43, "CallableStatement.getMaxRows",
      false, false, true, false),
  CALLABLESTATEMENT_GETMETADATA(44, "CallableStatement.getMetaData",
      false, true, true, false),
  CALLABLESTATEMENT_GETMORERESULTS(45, "CallableStatement.getMoreResults",
      false, false, true, true),
  CALLABLESTATEMENT_GETNCHARACTERSTREAM(46, "CallableStatement.getNCharacterStream",
      false, false, true, false),
  CALLABLESTATEMENT_GETNCLOB(47, "CallableStatement.getNClob",
      false, true, true, false),
  CALLABLESTATEMENT_GETNSTRING(48, "CallableStatement.getNString",
      false, false, true, false),
  CALLABLESTATEMENT_GETOBJECT(49, "CallableStatement.getObject",
      false, false, true, false),
  CALLABLESTATEMENT_GETPARAMETERMETADATA(50, "CallableStatement.getParameterMetaData",
      false, true, true, false),
  CALLABLESTATEMENT_GETQUERYTIMEOUT(51, "CallableStatement.getQueryTimeout",
      false, false, true, false),
  CALLABLESTATEMENT_GETREF(52, "CallableStatement.getRef",
      false, true, true, false),
  CALLABLESTATEMENT_GETRESULTSET(53, "CallableStatement.getResultSet",
      false, true, true, true),
  CALLABLESTATEMENT_GETRESULTSETCONCURRENCY(54, "CallableStatement.getResultSetConcurrency",
      false, false, true, false),
  CALLABLESTATEMENT_GETRESULTSETHOLDABILITY(55, "CallableStatement.getResultSetHoldability",
      false, false, true, false),
  CALLABLESTATEMENT_GETRESULTSETTYPE(56, "CallableStatement.getResultSetType",
      false, false, true, false),
  CALLABLESTATEMENT_GETROWID(57, "CallableStatement.getRowId",
      false, false, true, false),
  CALLABLESTATEMENT_GETSQLXML(58, "CallableStatement.getSQLXML",
      false, false, true, false),
  CALLABLESTATEMENT_GETSHORT(59, "CallableStatement.getShort",
      false, false, true, false),
  CALLABLESTATEMENT_GETSTRING(60, "CallableStatement.getString",
      false, false, true, false),
  CALLABLESTATEMENT_GETTIME(61, "CallableStatement.getTime",
      false, false, true, false),
  CALLABLESTATEMENT_GETTIMESTAMP(62, "CallableStatement.getTimestamp",
      false, false, true, false),
  CALLABLESTATEMENT_GETURL(63, "CallableStatement.getURL",
      false, false, true, false),
  CALLABLESTATEMENT_GETUPDATECOUNT(64, "CallableStatement.getUpdateCount",
      false, false, true, false),
  CALLABLESTATEMENT_GETWARNINGS(65, "CallableStatement.getWarnings",
      false, false, true, false),
  CALLABLESTATEMENT_ISCLOSEONCOMPLETION(66, "CallableStatement.isCloseOnCompletion",
      false, false, true, false),
  CALLABLESTATEMENT_ISCLOSED(67, "CallableStatement.isClosed",
      false, false, true, false),
  CALLABLESTATEMENT_ISPOOLABLE(68, "CallableStatement.isPoolable",
      false, false, true, false),
  CALLABLESTATEMENT_REGISTEROUTPARAMETER(69, "CallableStatement.registerOutParameter",
      false, false, true, false),
  CALLABLESTATEMENT_SETARRAY(70, "CallableStatement.setArray",
      false, false, true, false),
  CALLABLESTATEMENT_SETASCIISTREAM(71, "CallableStatement.setAsciiStream",
      false, false, true, false),
  CALLABLESTATEMENT_SETBIGDECIMAL(72, "CallableStatement.setBigDecimal",
      false, false, true, false),
  CALLABLESTATEMENT_SETBINARYSTREAM(73, "CallableStatement.setBinaryStream",
      false, false, true, false),
  CALLABLESTATEMENT_SETBLOB(74, "CallableStatement.setBlob",
      false, false, true, false),
  CALLABLESTATEMENT_SETBOOLEAN(75, "CallableStatement.setBoolean",
      false, false, true, false),
  CALLABLESTATEMENT_SETBYTE(76, "CallableStatement.setByte",
      false, false, true, false),
  CALLABLESTATEMENT_SETBYTES(77, "CallableStatement.setBytes",
      false, false, true, false),
  CALLABLESTATEMENT_SETCHARACTERSTREAM(78, "CallableStatement.setCharacterStream",
      false, false, true, false),
  CALLABLESTATEMENT_SETCLOB(79, "CallableStatement.setClob",
      false, false, true, false),
  CALLABLESTATEMENT_SETCURSORNAME(80, "CallableStatement.setCursorName",
      false, false, true, false),
  CALLABLESTATEMENT_SETDATE(81, "CallableStatement.setDate",
      false, false, true, false),
  CALLABLESTATEMENT_SETDOUBLE(82, "CallableStatement.setDouble",
      false, false, true, false),
  CALLABLESTATEMENT_SETESCAPEPROCESSING(83, "CallableStatement.setEscapeProcessing",
      false, false, true, false),
  CALLABLESTATEMENT_SETFETCHDIRECTION(84, "CallableStatement.setFetchDirection",
      false, false, true, false),
  CALLABLESTATEMENT_SETFETCHSIZE(85, "CallableStatement.setFetchSize",
      false, false, true, false),
  CALLABLESTATEMENT_SETFLOAT(86, "CallableStatement.setFloat",
      false, false, true, false),
  CALLABLESTATEMENT_SETINT(87, "CallableStatement.setInt",
      false, false, true, false),
  CALLABLESTATEMENT_SETLONG(88, "CallableStatement.setLong",
      false, false, true, false),
  CALLABLESTATEMENT_SETMAXFIELDSIZE(89, "CallableStatement.setMaxFieldSize",
      false, false, true, false),
  CALLABLESTATEMENT_SETMAXROWS(90, "CallableStatement.setMaxRows",
      false, false, true, false),
  CALLABLESTATEMENT_SETNCHARACTERSTREAM(91, "CallableStatement.setNCharacterStream",
      false, false, true, false),
  CALLABLESTATEMENT_SETNCLOB(92, "CallableStatement.setNClob",
      false, false, true, false),
  CALLABLESTATEMENT_SETNSTRING(93, "CallableStatement.setNString",
      false, false, true, false),
  CALLABLESTATEMENT_SETNULL(94, "CallableStatement.setNull",
      false, false, true, false),
  CALLABLESTATEMENT_SETOBJECT(95, "CallableStatement.setObject",
      false, false, true, false),
  CALLABLESTATEMENT_SETPOOLABLE(96, "CallableStatement.setPoolable",
      false, false, true, false),
  CALLABLESTATEMENT_SETQUERYTIMEOUT(97, "CallableStatement.setQueryTimeout",
      false, false, true, false),
  CALLABLESTATEMENT_SETREF(98, "CallableStatement.setRef",
      false, false, true, false),
  CALLABLESTATEMENT_SETROWID(99, "CallableStatement.setRowId",
      false, false, true, false),
  CALLABLESTATEMENT_SETSQLXML(100, "CallableStatement.setSQLXML",
      false, false, true, false),
  CALLABLESTATEMENT_SETSHORT(101, "CallableStatement.setShort",
      false, false, true, false),
  CALLABLESTATEMENT_SETSTRING(102, "CallableStatement.setString",
false, false, true, false),
  CALLABLESTATEMENT_SETTIME(103, "CallableStatement.setTime",
false, false, true, false),
  CALLABLESTATEMENT_SETTIMESTAMP(104, "CallableStatement.setTimestamp",
false, false, true, false),
  CALLABLESTATEMENT_SETURL(105, "CallableStatement.setURL",
false, false, true, false),
  CALLABLESTATEMENT_SETUNICODESTREAM(106, "CallableStatement.setUnicodeStream",
false, false, true, false),
  CALLABLESTATEMENT_WASNULL(107, "CallableStatement.wasNull",
false, false, true, false),


  CLOB_LENGTH(108, "Clob.length",
false, false, true, false),
  CLOB_GETSUBSTRING(109, "Clob.getSubString",
false, false, true, false),
  CLOB_GETCHARACTERSTREAM(110, "Clob.getCharacterStream",
false, false, true, false),
  CLOB_GETASCIISTREAM(111, "Clob.getAsciiStream",
false, false, true, false),
  CLOB_POSITION(112, "Clob.position",
false, false, true, false),
  CLOB_SETSTRING(113, "Clob.setString",
false, false, true, false),
  CLOB_SETASCIISTREAM(114, "Clob.setAsciiStream",
false, false, true, false),
  CLOB_SETCHARACTERSTREAM(115, "Clob.setCharacterStream",
false, false, true, false),
  CLOB_TRUNCATE(116, "Clob.truncate",
false, false, true, false),
  CLOB_FREE(117, "Clob.free",
false, false, true, false),


  CONNECTION_ABORT(118, "Connection.abort",
false, false, false, false),
  CONNECTION_CLEARWARNINGS(119, "Connection.clearWarnings",
false, false, true, false),
  CONNECTION_CLOSE(120, "Connection.close",
false, false, true, false),
  CONNECTION_COMMIT(121, "Connection.commit",
true, false, true, false),
  CONNECTION_CREATEARRAYOF(122, "Connection.createArrayOf",
false, true, true, false),
  CONNECTION_CREATEBLOB(123, "Connection.createBlob",
false, true, true, false),
  CONNECTION_CREATECLOB(124, "Connection.createClob",
false, true, true, false),
  CONNECTION_CREATENCLOB(125, "Connection.createNClob",
false, true, true, false),
  CONNECTION_CREATESQLXML(126, "Connection.createSQLXML",
false, false, true, false),
  CONNECTION_CREATESTATEMENT(127, "Connection.createStatement",
false, true, true, false),
  CONNECTION_CREATESTRUCT(128, "Connection.createStruct",
false, true, true, false),
  CONNECTION_SETREADONLY(129, "Connection.setReadOnly",
false, false, true, false),
  CONNECTION_GETCATALOG(130, "Connection.getCatalog",
false, false, true, false),
  CONNECTION_GETCLIENTINFO(131, "Connection.getClientInfo",
false, false, true, false),
  CONNECTION_GETHOLDABILITY(132, "Connection.getHoldability",
false, false, true, false),
  CONNECTION_GETMETADATA(133, "Connection.getMetaData",
false, true, true, false),
  CONNECTION_GETNETWORKTIMEOUT(134, "Connection.getNetworkTimeout",
false, false, true, false),
  CONNECTION_GETSCHEMA(135, "Connection.getSchema",
false, false, true, false),
  CONNECTION_GETTRANSACTIONISOLATION(136, "Connection.getTransactionIsolation",
false, false, true, false),
  CONNECTION_GETTYPEMAP(137, "Connection.getTypeMap",
false, false, true, false),
  CONNECTION_GETWARNINGS(138, "Connection.getWarnings",
false, false, true, false),
  CONNECTION_ISCLOSED(139, "Connection.isClosed",
false, false, true, false),
  CONNECTION_ISREADONLY(140, "Connection.isReadOnly",
false, false, true, false),
  CONNECTION_ISVALID(141, "Connection.isValid",
false, false, true, false),
  CONNECTION_NATIVESQL(142, "Connection.nativeSQL",
false, false, true, false),
  CONNECTION_PREPARECALL(143, "Connection.prepareCall",
false, true, true, false),
  CONNECTION_PREPARESTATEMENT(144, "Connection.prepareStatement",
false, true, true, false),
  CONNECTION_RELEASESAVEPOINT(145, "Connection.releaseSavepoint",
false, false, true, false),
  CONNECTION_ROLLBACK(146, "Connection.rollback",
true, false, true, false),
  CONNECTION_SETAUTOCOMMIT(147, "Connection.setAutoCommit",
false, false, true, false),
  CONNECTION_SETCATALOG(148, "Connection.setCatalog",
false, false, true, false),
  CONNECTION_SETCLIENTINFO(149, "Connection.setClientInfo",
false, false, true, false),
  CONNECTION_SETHOLDABILITY(150, "Connection.setHoldability",
false, false, true, false),
  CONNECTION_SETNETWORKTIMEOUT(151, "Connection.setNetworkTimeout",
false, false, true, false),
  CONNECTION_SETSAVEPOINT(152, "Connection.setSavepoint",
false, true, true, false),
  CONNECTION_SETSCHEMA(153, "Connection.setSchema",
false, false, true, false),
  CONNECTION_SETTRANSACTIONISOLATION(154, "Connection.setTransactionIsolation",
false, false, true, false),
  CONNECTION_SETTYPEMAP(155, "Connection.setTypeMap",
false, false, true, false),


  DATABASEMETADATA_ALLPROCEDURESARECALLABLE(156, "DatabaseMetaData.allProceduresAreCallable",
false, false, true, false),
  DATABASEMETADATA_ALLTABLESARESELECTABLE(157, "DatabaseMetaData.allTablesAreSelectable",
false, false, true, false),
  DATABASEMETADATA_GETURL(158, "DatabaseMetaData.getURL",
false, false, true, false),
  DATABASEMETADATA_GETUSERNAME(159, "DatabaseMetaData.getUserName",
false, false, true, false),
  DATABASEMETADATA_ISREADONLY(160, "DatabaseMetaData.isReadOnly",
false, false, true, false),
  DATABASEMETADATA_NULLSARESORTEDHIGH(161, "DatabaseMetaData.nullsAreSortedHigh",
false, false, true, false),
  DATABASEMETADATA_NULLSARESORTEDLOW(162, "DatabaseMetaData.nullsAreSortedLow",
false, false, true, false),
  DATABASEMETADATA_NULLSARESORTEDATSTART(163, "DatabaseMetaData.nullsAreSortedAtStart",
false, false, true, false),
  DATABASEMETADATA_NULLSARESORTEDATEND(164, "DatabaseMetaData.nullsAreSortedAtEnd",
false, false, true, false),
  DATABASEMETADATA_GETDATABASEPRODUCTNAME(165, "DatabaseMetaData.getDatabaseProductName",
false, false, true, false),
  DATABASEMETADATA_GETDATABASEPRODUCTVERSION(166, "DatabaseMetaData.getDatabaseProductVersion",
false, false, true, false),
  DATABASEMETADATA_GETDRIVERNAME(167, "DatabaseMetaData.getDriverName",
false, false, true, false),
  DATABASEMETADATA_USESLOCALFILES(168, "DatabaseMetaData.usesLocalFiles",
false, false, true, false),
  DATABASEMETADATA_USESLOCALFILEPERTABLE(169, "DatabaseMetaData.usesLocalFilePerTable",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMIXEDCASEIDENTIFIERS(170, "DatabaseMetaData.supportsMixedCaseIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESUPPERCASEIDENTIFIERS(171, "DatabaseMetaData.storesUpperCaseIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESLOWERCASEIDENTIFIERS(172, "DatabaseMetaData.storesLowerCaseIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESMIXEDCASEIDENTIFIERS(173, "DatabaseMetaData.storesMixedCaseIdentifiers",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMIXEDCASEQUOTEDIDENTIFIERS(174,
      "DatabaseMetaData.supportsMixedCaseQuotedIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESUPPERCASEQUOTEDIDENTIFIERS(175,
      "DatabaseMetaData.storesUpperCaseQuotedIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESLOWERCASEQUOTEDIDENTIFIERS(176,
      "DatabaseMetaData.storesLowerCaseQuotedIdentifiers",
false, false, true, false),
  DATABASEMETADATA_STORESMIXEDCASEQUOTEDIDENTIFIERS(177,
      "DatabaseMetaData.storesMixedCaseQuotedIdentifiers",
false, false, true, false),
  DATABASEMETADATA_GETIDENTIFIERQUOTESTRING(178, "DatabaseMetaData.getIdentifierQuoteString",
false, false, true, false),
  DATABASEMETADATA_GETSQLKEYWORDS(179, "DatabaseMetaData.getSQLKeywords",
false, false, true, false),
  DATABASEMETADATA_GETNUMERICFUNCTIONS(180, "DatabaseMetaData.getNumericFunctions",
false, false, true, false),
  DATABASEMETADATA_GETSTRINGFUNCTIONS(181, "DatabaseMetaData.getStringFunctions",
false, false, true, false),
  DATABASEMETADATA_GETSYSTEMFUNCTIONS(182, "DatabaseMetaData.getSystemFunctions",
false, false, true, false),
  DATABASEMETADATA_GETTIMEDATEFUNCTIONS(183, "DatabaseMetaData.getTimeDateFunctions",
false, false, true, false),
  DATABASEMETADATA_GETSEARCHSTRINGESCAPE(184, "DatabaseMetaData.getSearchStringEscape",
false, false, true, false),
  DATABASEMETADATA_GETEXTRANAMECHARACTERS(185, "DatabaseMetaData.getExtraNameCharacters",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSALTERTABLEWITHADDCOLUMN(186,
      "DatabaseMetaData.supportsAlterTableWithAddColumn",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSALTERTABLEWITHDROPCOLUMN(187,
      "DatabaseMetaData.supportsAlterTableWithDropColumn",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCOLUMNALIASING(188, "DatabaseMetaData.supportsColumnAliasing",
false, false, true, false),
  DATABASEMETADATA_NULLPLUSNONNULLISNULL(189, "DatabaseMetaData.nullPlusNonNullIsNull",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCONVERT(190, "DatabaseMetaData.supportsConvert",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSTABLECORRELATIONNAMES(191, "DatabaseMetaData.supportsTableCorrelationNames",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSDIFFERENTTABLECORRELATIONNAMES(192,
      "DatabaseMetaData.supportsDifferentTableCorrelationNames",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSEXPRESSIONSINORDERBY(193, "DatabaseMetaData.supportsExpressionsInOrderBy",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSORDERBYUNRELATED(194, "DatabaseMetaData.supportsOrderByUnrelated",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSGROUPBY(195, "DatabaseMetaData.supportsGroupBy",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSGROUPBYUNRELATED(196, "DatabaseMetaData.supportsGroupByUnrelated",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSGROUPBYBEYONDSELECT(197, "DatabaseMetaData.supportsGroupByBeyondSelect",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSLIKEESCAPECLAUSE(198, "DatabaseMetaData.supportsLikeEscapeClause",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMULTIPLERESULTSETS(199, "DatabaseMetaData.supportsMultipleResultSets",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMULTIPLETRANSACTIONS(200, "DatabaseMetaData.supportsMultipleTransactions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSNONNULLABLECOLUMNS(201, "DatabaseMetaData.supportsNonNullableColumns",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMINIMUMSQLGRAMMAR(202, "DatabaseMetaData.supportsMinimumSQLGrammar",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCORESQLGRAMMAR(203, "DatabaseMetaData.supportsCoreSQLGrammar",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSEXTENDEDSQLGRAMMAR(204, "DatabaseMetaData.supportsExtendedSQLGrammar",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSANSI92ENTRYLEVELSQL(205, "DatabaseMetaData.supportsANSI92EntryLevelSQL",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSANSI92INTERMEDIATESQL(206, "DatabaseMetaData.supportsANSI92IntermediateSQL",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSANSI92FULLSQL(207, "DatabaseMetaData.supportsANSI92FullSQL",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSINTEGRITYENHANCEMENTFACILITY(208,
      "DatabaseMetaData.supportsIntegrityEnhancementFacility",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSOUTERJOINS(209, "DatabaseMetaData.supportsOuterJoins",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSFULLOUTERJOINS(210, "DatabaseMetaData.supportsFullOuterJoins",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSLIMITEDOUTERJOINS(211, "DatabaseMetaData.supportsLimitedOuterJoins",
false, false, true, false),
  DATABASEMETADATA_GETSCHEMATERM(212, "DatabaseMetaData.getSchemaTerm",
false, false, true, false),
  DATABASEMETADATA_GETPROCEDURETERM(213, "DatabaseMetaData.getProcedureTerm",
false, false, true, false),
  DATABASEMETADATA_GETCATALOGTERM(214, "DatabaseMetaData.getCatalogTerm",
false, false, true, false),
  DATABASEMETADATA_ISCATALOGATSTART(215, "DatabaseMetaData.isCatalogAtStart",
false, false, true, false),
  DATABASEMETADATA_GETCATALOGSEPARATOR(216, "DatabaseMetaData.getCatalogSeparator",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSCHEMASINDATAMANIPULATION(217,
      "DatabaseMetaData.supportsSchemasInDataManipulation",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSCHEMASINPROCEDURECALLS(218,
      "DatabaseMetaData.supportsSchemasInProcedureCalls",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSCHEMASINTABLEDEFINITIONS(219,
      "DatabaseMetaData.supportsSchemasInTableDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSCHEMASININDEXDEFINITIONS(220,
      "DatabaseMetaData.supportsSchemasInIndexDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSCHEMASINPRIVILEGEDEFINITIONS(221,
      "DatabaseMetaData.supportsSchemasInPrivilegeDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCATALOGSINDATAMANIPULATION(222,
      "DatabaseMetaData.supportsCatalogsInDataManipulation",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCATALOGSINPROCEDURECALLS(223,
      "DatabaseMetaData.supportsCatalogsInProcedureCalls",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCATALOGSINTABLEDEFINITIONS(224,
      "DatabaseMetaData.supportsCatalogsInTableDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCATALOGSININDEXDEFINITIONS(225,
      "DatabaseMetaData.supportsCatalogsInIndexDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCATALOGSINPRIVILEGEDEFINITIONS(226,
      "DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSPOSITIONEDDELETE(227, "DatabaseMetaData.supportsPositionedDelete",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSPOSITIONEDUPDATE(228, "DatabaseMetaData.supportsPositionedUpdate",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSELECTFORUPDATE(229, "DatabaseMetaData.supportsSelectForUpdate",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSTOREDPROCEDURES(230, "DatabaseMetaData.supportsStoredProcedures",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSUBQUERIESINCOMPARISONS(231,
      "DatabaseMetaData.supportsSubqueriesInComparisons",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSUBQUERIESINEXISTS(232, "DatabaseMetaData.supportsSubqueriesInExists",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSUBQUERIESININS(233, "DatabaseMetaData.supportsSubqueriesInIns",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSUBQUERIESINQUANTIFIEDS(234,
      "DatabaseMetaData.supportsSubqueriesInQuantifieds",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSCORRELATEDSUBQUERIES(235, "DatabaseMetaData.supportsCorrelatedSubqueries",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSUNION(236, "DatabaseMetaData.supportsUnion",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSUNIONALL(237, "DatabaseMetaData.supportsUnionAll",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSOPENCURSORSACROSSCOMMIT(238,
      "DatabaseMetaData.supportsOpenCursorsAcrossCommit",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSOPENCURSORSACROSSROLLBACK(239,
      "DatabaseMetaData.supportsOpenCursorsAcrossRollback",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSOPENSTATEMENTSACROSSCOMMIT(240,
      "DatabaseMetaData.supportsOpenStatementsAcrossCommit",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSOPENSTATEMENTSACROSSROLLBACK(241,
      "DatabaseMetaData.supportsOpenStatementsAcrossRollback",
false, false, true, false),
  DATABASEMETADATA_GETMAXBINARYLITERALLENGTH(242, "DatabaseMetaData.getMaxBinaryLiteralLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXCHARLITERALLENGTH(243, "DatabaseMetaData.getMaxCharLiteralLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNNAMELENGTH(244, "DatabaseMetaData.getMaxColumnNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNSINGROUPBY(245, "DatabaseMetaData.getMaxColumnsInGroupBy",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNSININDEX(246, "DatabaseMetaData.getMaxColumnsInIndex",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNSINORDERBY(247, "DatabaseMetaData.getMaxColumnsInOrderBy",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNSINSELECT(248, "DatabaseMetaData.getMaxColumnsInSelect",
false, false, true, false),
  DATABASEMETADATA_GETMAXCOLUMNSINTABLE(249, "DatabaseMetaData.getMaxColumnsInTable",
false, false, true, false),
  DATABASEMETADATA_GETMAXCONNECTIONS(250, "DatabaseMetaData.getMaxConnections",
false, false, true, false),
  DATABASEMETADATA_GETMAXCURSORNAMELENGTH(251, "DatabaseMetaData.getMaxCursorNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXINDEXLENGTH(252, "DatabaseMetaData.getMaxIndexLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXSCHEMANAMELENGTH(253, "DatabaseMetaData.getMaxSchemaNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXPROCEDURENAMELENGTH(254, "DatabaseMetaData.getMaxProcedureNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXCATALOGNAMELENGTH(255, "DatabaseMetaData.getMaxCatalogNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXROWSIZE(256, "DatabaseMetaData.getMaxRowSize",
false, false, true, false),
  DATABASEMETADATA_DOESMAXROWSIZEINCLUDEBLOBS(257, "DatabaseMetaData.doesMaxRowSizeIncludeBlobs",
false, false, true, false),
  DATABASEMETADATA_GETMAXSTATEMENTLENGTH(258, "DatabaseMetaData.getMaxStatementLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXSTATEMENTS(259, "DatabaseMetaData.getMaxStatements",
false, false, true, false),
  DATABASEMETADATA_GETMAXTABLENAMELENGTH(260, "DatabaseMetaData.getMaxTableNameLength",
false, false, true, false),
  DATABASEMETADATA_GETMAXTABLESINSELECT(261, "DatabaseMetaData.getMaxTablesInSelect",
false, false, true, false),
  DATABASEMETADATA_GETMAXUSERNAMELENGTH(262, "DatabaseMetaData.getMaxUserNameLength",
false, false, true, false),
  DATABASEMETADATA_GETDEFAULTTRANSACTIONISOLATION(263,
      "DatabaseMetaData.getDefaultTransactionIsolation",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSTRANSACTIONS(264, "DatabaseMetaData.supportsTransactions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSTRANSACTIONISOLATIONLEVEL(265,
      "DatabaseMetaData.supportsTransactionIsolationLevel",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSDATADEFINITIONANDDATAMANIPULATIONTRANSACTIONS(266,
      "DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSDATAMANIPULATIONTRANSACTIONSONLY(267,
      "DatabaseMetaData.supportsDataManipulationTransactionsOnly",
false, false, true, false),
  DATABASEMETADATA_DATADEFINITIONCAUSESTRANSACTIONCOMMIT(268,
      "DatabaseMetaData.dataDefinitionCausesTransactionCommit",
false, false, true, false),
  DATABASEMETADATA_DATADEFINITIONIGNOREDINTRANSACTIONS(269,
      "DatabaseMetaData.dataDefinitionIgnoredInTransactions",
false, false, true, false),
  DATABASEMETADATA_GETPROCEDURES(270, "DatabaseMetaData.getProcedures",
false, true, true, false),
  DATABASEMETADATA_GETPROCEDURECOLUMNS(271, "DatabaseMetaData.getProcedureColumns",
false, true, true, false),
  DATABASEMETADATA_GETTABLES(272, "DatabaseMetaData.getTables",
false, true, true, false),
  DATABASEMETADATA_GETSCHEMAS(273, "DatabaseMetaData.getSchemas",
false, true, true, false),
  DATABASEMETADATA_GETCATALOGS(274, "DatabaseMetaData.getCatalogs",
false, true, true, false),
  DATABASEMETADATA_GETTABLETYPES(275, "DatabaseMetaData.getTableTypes",
false, true, true, false),
  DATABASEMETADATA_GETCOLUMNS(276, "DatabaseMetaData.getColumns",
false, true, true, false),
  DATABASEMETADATA_GETCOLUMNPRIVILEGES(277, "DatabaseMetaData.getColumnPrivileges",
true, false, true, false),
  DATABASEMETADATA_GETTABLEPRIVILEGES(278, "DatabaseMetaData.getTablePrivileges",
true, false, true, false),
  DATABASEMETADATA_GETBESTROWIDENTIFIER(279, "DatabaseMetaData.getBestRowIdentifier",
false, true, true, false),
  DATABASEMETADATA_GETVERSIONCOLUMNS(280, "DatabaseMetaData.getVersionColumns",
false, true, true, false),
  DATABASEMETADATA_GETPRIMARYKEYS(281, "DatabaseMetaData.getPrimaryKeys",
false, true, true, false),
  DATABASEMETADATA_GETIMPORTEDKEYS(282, "DatabaseMetaData.getImportedKeys",
false, true, true, false),
  DATABASEMETADATA_GETEXPORTEDKEYS(283, "DatabaseMetaData.getExportedKeys",
false, true, true, false),
  DATABASEMETADATA_GETCROSSREFERENCE(284, "DatabaseMetaData.getCrossReference",
false, true, true, false),
  DATABASEMETADATA_GETTYPEINFO(285, "DatabaseMetaData.getTypeInfo",
false, true, true, false),
  DATABASEMETADATA_GETINDEXINFO(286, "DatabaseMetaData.getIndexInfo",
false, true, true, false),
  DATABASEMETADATA_SUPPORTSRESULTSETTYPE(287, "DatabaseMetaData.supportsResultSetType",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSRESULTSETCONCURRENCY(288, "DatabaseMetaData.supportsResultSetConcurrency",
false, false, true, false),
  DATABASEMETADATA_OWNUPDATESAREVISIBLE(289, "DatabaseMetaData.ownUpdatesAreVisible",
false, false, true, false),
  DATABASEMETADATA_OWNDELETESAREVISIBLE(290, "DatabaseMetaData.ownDeletesAreVisible",
false, false, true, false),
  DATABASEMETADATA_OWNINSERTSAREVISIBLE(291, "DatabaseMetaData.ownInsertsAreVisible",
false, false, true, false),
  DATABASEMETADATA_OTHERSUPDATESAREVISIBLE(292, "DatabaseMetaData.othersUpdatesAreVisible",
false, false, true, false),
  DATABASEMETADATA_OTHERSDELETESAREVISIBLE(293, "DatabaseMetaData.othersDeletesAreVisible",
false, false, true, false),
  DATABASEMETADATA_OTHERSINSERTSAREVISIBLE(294, "DatabaseMetaData.othersInsertsAreVisible",
false, false, true, false),
  DATABASEMETADATA_UPDATESAREDETECTED(295, "DatabaseMetaData.updatesAreDetected",
false, false, true, false),
  DATABASEMETADATA_DELETESAREDETECTED(296, "DatabaseMetaData.deletesAreDetected",
false, false, true, false),
  DATABASEMETADATA_INSERTSAREDETECTED(297, "DatabaseMetaData.insertsAreDetected",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSBATCHUPDATES(298, "DatabaseMetaData.supportsBatchUpdates",
false, false, true, false),
  DATABASEMETADATA_GETUDTS(299, "DatabaseMetaData.getUDTs",
false, true, true, false),
  DATABASEMETADATA_GETCONNECTION(300, "DatabaseMetaData.getConnection",
false, true, true, true),
  DATABASEMETADATA_SUPPORTSSAVEPOINTS(301, "DatabaseMetaData.supportsSavepoints",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSNAMEDPARAMETERS(302, "DatabaseMetaData.supportsNamedParameters",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSMULTIPLEOPENRESULTS(303, "DatabaseMetaData.supportsMultipleOpenResults",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSGETGENERATEDKEYS(304, "DatabaseMetaData.supportsGetGeneratedKeys",
false, false, true, false),
  DATABASEMETADATA_GETSUPERTYPES(305, "DatabaseMetaData.getSuperTypes",
false, true, true, false),
  DATABASEMETADATA_GETSUPERTABLES(306, "DatabaseMetaData.getSuperTables",
false, true, true, false),
  DATABASEMETADATA_GETATTRIBUTES(307, "DatabaseMetaData.getAttributes",
false, true, true, false),
  DATABASEMETADATA_GETRESULTSETHOLDABILITY(308, "DatabaseMetaData.getResultSetHoldability",
false, false, true, false),
  DATABASEMETADATA_GETDATABASEMAJORVERSION(309, "DatabaseMetaData.getDatabaseMajorVersion",
false, false, true, false),
  DATABASEMETADATA_GETDATABASEMINORVERSION(310, "DatabaseMetaData.getDatabaseMinorVersion",
false, false, true, false),
  DATABASEMETADATA_GETJDBCMAJORVERSION(311, "DatabaseMetaData.getJDBCMajorVersion",
false, false, true, false),
  DATABASEMETADATA_GETJDBCMINORVERSION(312, "DatabaseMetaData.getJDBCMinorVersion",
false, false, true, false),
  DATABASEMETADATA_GETSQLSTATETYPE(313, "DatabaseMetaData.getSQLStateType",
false, false, true, false),
  DATABASEMETADATA_LOCATORSUPDATECOPY(314, "DatabaseMetaData.locatorsUpdateCopy",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSTATEMENTPOOLING(315, "DatabaseMetaData.supportsStatementPooling",
false, false, true, false),
  DATABASEMETADATA_GETROWIDLIFETIME(316, "DatabaseMetaData.getRowIdLifetime",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSSTOREDFUNCTIONSUSINGCALLSYNTAX(317,
      "DatabaseMetaData.supportsStoredFunctionsUsingCallSyntax", false, false, true, false),
  DATABASEMETADATA_AUTOCOMMITFAILURECLOSESALLRESULTSETS(318,
      "DatabaseMetaData.autoCommitFailureClosesAllResultSets", false, false, true, false),
  DATABASEMETADATA_GETCLIENTINFOPROPERTIES(319, "DatabaseMetaData.getClientInfoProperties",
false, true, true, false),
  DATABASEMETADATA_GETFUNCTIONS(320, "DatabaseMetaData.getFunctions",
false, true, true, false),
  DATABASEMETADATA_GETFUNCTIONCOLUMNS(321, "DatabaseMetaData.getFunctionColumns",
false, true, true, false),
  DATABASEMETADATA_GETPSEUDOCOLUMNS(322, "DatabaseMetaData.getPseudoColumns",
false, true, true, false),
  DATABASEMETADATA_GENERATEDKEYALWAYSRETURNED(323, "DatabaseMetaData.generatedKeyAlwaysReturned",
false, false, true, false),
  DATABASEMETADATA_GETMAXLOGICALLOBSIZE(324, "DatabaseMetaData.getMaxLogicalLobSize",
false, false, true, false),
  DATABASEMETADATA_SUPPORTSREFCURSORS(325, "DatabaseMetaData.supportsRefCursors",
false, false, true, false),



  NCLOB_LENGTH(326, "NClob.length",
false, false, true, false),
  NCLOB_GETSUBSTRING(327, "NClob.getSubString",
false, false, true, false),
  NCLOB_GETCHARACTERSTREAM(328, "NClob.getCharacterStream",
false, false, true, false),
  NCLOB_GETASCIISTREAM(329, "NClob.getAsciiStream",
false, false, true, false),
  NCLOB_POSITION(330, "NClob.position",
false, false, true, false),
  NCLOB_SETSTRING(331, "NClob.setString",
false, false, true, false),
  NCLOB_SETASCIISTREAM(332, "NClob.setAsciiStream",
false, false, true, false),
  NCLOB_SETCHARACTERSTREAM(333, "NClob.setCharacterStream",
false, false, true, false),
  NCLOB_TRUNCATE(334, "NClob.truncate",
false, false, true, false),
  NCLOB_FREE(335, "NClob.free",
false, false, true, false),


  PARAMETERMETADATA_GETPARAMETERCOUNT(336, "ParameterMetaData.getParameterCount",
false, false, true, false),
  PARAMETERMETADATA_ISNULLABLE(337, "ParameterMetaData.isNullable",
false, false, true, false),
  PARAMETERMETADATA_ISSIGNED(338, "ParameterMetaData.isSigned",
false, false, true, false),
  PARAMETERMETADATA_GETPRECISION(339, "ParameterMetaData.getPrecision",
false, false, true, false),
  PARAMETERMETADATA_GETSCALE(340, "ParameterMetaData.getScale",
false, false, true, false),
  PARAMETERMETADATA_GETPARAMETERTYPE(341, "ParameterMetaData.getParameterType",
false, false, true, false),
  PARAMETERMETADATA_GETPARAMETERTYPENAME(342, "ParameterMetaData.getParameterTypeName",
false, false, true, false),
  PARAMETERMETADATA_GETPARAMETERCLASSNAME(343, "ParameterMetaData.getParameterClassName",
false, false, true, false),
  PARAMETERMETADATA_GETPARAMETERMODE(344, "ParameterMetaData.getParameterMode",
false, false, true, false),


  PREPAREDSTATEMENT_ADDBATCH(345, "PreparedStatement.addBatch",
false, false, true, false),
  PREPAREDSTATEMENT_CANCEL(346, "PreparedStatement.cancel",
false, false, false, false),
  PREPAREDSTATEMENT_CLEARBATCH(347, "PreparedStatement.clearBatch",
false, false, true, false),
  PREPAREDSTATEMENT_CLEARPARAMETERS(348, "PreparedStatement.clearParameters",
false, false, true, false),
  PREPAREDSTATEMENT_CLEARWARNINGS(349, "PreparedStatement.clearWarnings",
false, false, true, false),
  PREPAREDSTATEMENT_CLOSE(350, "PreparedStatement.close",
false, false, true, false),
  PREPAREDSTATEMENT_CLOSEONCOMPLETION(351, "PreparedStatement.closeOnCompletion",
false, false, true, false),
  PREPAREDSTATEMENT_EXECUTE(352, "PreparedStatement.execute",
false, false, true, true),
  PREPAREDSTATEMENT_EXECUTEBATCH(353, "PreparedStatement.executeBatch",
false, false, true, true),
  PREPAREDSTATEMENT_EXECUTELARGEUPDATE(354, "PreparedStatement.executeLargeUpdate",
false, false, true, true),
  PREPAREDSTATEMENT_EXECUTEQUERY(355, "PreparedStatement.executeQuery",
false, true, true, true),
  PREPAREDSTATEMENT_EXECUTEUPDATE(356, "PreparedStatement.executeUpdate",
false, false, true, true),
  PREPAREDSTATEMENT_GETCONNECTION(357, "PreparedStatement.getConnection",
false, true, true, true),
  PREPAREDSTATEMENT_GETFETCHDIRECTION(358, "PreparedStatement.getFetchDirection",
false, false, true, false),
  PREPAREDSTATEMENT_GETFETCHSIZE(359, "PreparedStatement.getFetchSize",
false, false, true, false),
  PREPAREDSTATEMENT_GETGENERATEDKEYS(360, "PreparedStatement.getGeneratedKeys",
false, true, true, false),
  PREPAREDSTATEMENT_GETMAXFIELDSIZE(361, "PreparedStatement.getMaxFieldSize",
false, false, true, false),
  PREPAREDSTATEMENT_GETMAXROWS(362, "PreparedStatement.getMaxRows",
false, false, true, false),
  PREPAREDSTATEMENT_GETMETADATA(363, "PreparedStatement.getMetaData",
false, true, true, false),
  PREPAREDSTATEMENT_GETMORERESULTS(364, "PreparedStatement.getMoreResults",
false, false, true, false),
  PREPAREDSTATEMENT_GETPARAMETERMETADATA(365, "PreparedStatement.getParameterMetaData",
false, true, true, false),
  PREPAREDSTATEMENT_GETQUERYTIMEOUT(366, "PreparedStatement.getQueryTimeout",
false, false, true, false),
  PREPAREDSTATEMENT_GETRESULTSET(367, "PreparedStatement.getResultSet",
false, true, true, true),
  PREPAREDSTATEMENT_GETRESULTSETCONCURRENCY(368, "PreparedStatement.getResultSetConcurrency",
false, false, true, false),
  PREPAREDSTATEMENT_GETRESULTSETHOLDABILITY(369, "PreparedStatement.getResultSetHoldability",
false, false, true, false),
  PREPAREDSTATEMENT_GETRESULTSETTYPE(370, "PreparedStatement.getResultSetType",
false, false, true, false),
  PREPAREDSTATEMENT_GETUPDATECOUNT(371, "PreparedStatement.getUpdateCount",
false, false, true, false),
  PREPAREDSTATEMENT_GETWARNINGS(372, "PreparedStatement.getWarnings",
false, false, true, false),
  PREPAREDSTATEMENT_ISCLOSEONCOMPLETION(373, "PreparedStatement.isCloseOnCompletion",
false, false, true, false),
  PREPAREDSTATEMENT_ISCLOSED(374, "PreparedStatement.isClosed",
false, false, true, false),
  PREPAREDSTATEMENT_ISPOOLABLE(375, "PreparedStatement.isPoolable",
false, false, true, false),
  PREPAREDSTATEMENT_SETARRAY(376, "PreparedStatement.setArray",
false, false, true, false),
  PREPAREDSTATEMENT_SETASCIISTREAM(377, "PreparedStatement.setAsciiStream",
false, false, true, false),
  PREPAREDSTATEMENT_SETBIGDECIMAL(378, "PreparedStatement.setBigDecimal",
false, false, true, false),
  PREPAREDSTATEMENT_SETBINARYSTREAM(379, "PreparedStatement.setBinaryStream",
false, false, true, false),
  PREPAREDSTATEMENT_SETBLOB(380, "PreparedStatement.setBlob",
false, false, true, false),
  PREPAREDSTATEMENT_SETBOOLEAN(381, "PreparedStatement.setBoolean",
false, false, true, false),
  PREPAREDSTATEMENT_SETBYTE(382, "PreparedStatement.setByte",
false, false, true, false),
  PREPAREDSTATEMENT_SETBYTES(383, "PreparedStatement.setBytes",
false, false, true, false),
  PREPAREDSTATEMENT_SETCHARACTERSTREAM(384, "PreparedStatement.setCharacterStream",
false, false, true, false),
  PREPAREDSTATEMENT_SETCLOB(385, "PreparedStatement.setClob",
false, false, true, false),
  PREPAREDSTATEMENT_SETCURSORNAME(386, "PreparedStatement.setCursorName",
false, false, true, false),
  PREPAREDSTATEMENT_SETDATE(387, "PreparedStatement.setDate",
false, false, true, false),
  PREPAREDSTATEMENT_SETDOUBLE(388, "PreparedStatement.setDouble",
false, false, true, false),
  PREPAREDSTATEMENT_SETESCAPEPROCESSING(389, "PreparedStatement.setEscapeProcessing",
false, false, true, false),
  PREPAREDSTATEMENT_SETFETCHDIRECTION(390, "PreparedStatement.setFetchDirection",
false, false, true, false),
  PREPAREDSTATEMENT_SETFETCHSIZE(391, "PreparedStatement.setFetchSize",
false, false, true, false),
  PREPAREDSTATEMENT_SETFLOAT(392, "PreparedStatement.setFloat",
false, false, true, false),
  PREPAREDSTATEMENT_SETINT(393, "PreparedStatement.setInt",
false, false, true, false),
  PREPAREDSTATEMENT_SETLONG(394, "PreparedStatement.setLong",
false, false, true, false),
  PREPAREDSTATEMENT_SETMAXFIELDSIZE(395, "PreparedStatement.setMaxFieldSize",
false, false, true, false),
  PREPAREDSTATEMENT_SETMAXROWS(396, "PreparedStatement.setMaxRows",
false, false, true, false),
  PREPAREDSTATEMENT_SETNCHARACTERSTREAM(397, "PreparedStatement.setNCharacterStream",
false, false, true, false),
  PREPAREDSTATEMENT_SETNCLOB(398, "PreparedStatement.setNClob",
false, false, true, false),
  PREPAREDSTATEMENT_SETNSTRING(399, "PreparedStatement.setNString",
false, false, true, false),
  PREPAREDSTATEMENT_SETNULL(400, "PreparedStatement.setNull",
false, false, true, false),
  PREPAREDSTATEMENT_SETOBJECT(401, "PreparedStatement.setObject",
false, false, true, false),
  PREPAREDSTATEMENT_SETPOOLABLE(402, "PreparedStatement.setPoolable",
false, false, true, false),
  PREPAREDSTATEMENT_SETQUERYTIMEOUT(403, "PreparedStatement.setQueryTimeout",
false, false, true, false),
  PREPAREDSTATEMENT_SETREF(404, "PreparedStatement.setRef",
false, false, true, false),
  PREPAREDSTATEMENT_SETROWID(405, "PreparedStatement.setRowId",
false, false, true, false),
  PREPAREDSTATEMENT_SETSQLXML(406, "PreparedStatement.setSQLXML",
false, false, true, false),
  PREPAREDSTATEMENT_SETSHORT(407, "PreparedStatement.setShort",
false, false, true, false),
  PREPAREDSTATEMENT_SETSTRING(408, "PreparedStatement.setString",
false, false, true, false),
  PREPAREDSTATEMENT_SETTIME(409, "PreparedStatement.setTime",
false, false, true, false),
  PREPAREDSTATEMENT_SETTIMESTAMP(410, "PreparedStatement.setTimestamp",
false, false, true, false),
  PREPAREDSTATEMENT_SETURL(411, "PreparedStatement.setURL",
false, false, true, false),
  PREPAREDSTATEMENT_SETUNICODESTREAM(412, "PreparedStatement.setUnicodeStream",
false, false, true, false),


  REF_GETBASETYPENAME(413, "Ref.getBaseTypeName",
false, false, true, false),
  REF_GETOBJECT(414, "Ref.getObject",
false, false, true, false),
  REF_SETOBJECT(415, "Ref.setObject",
false, false, true, false),


  RESULTSETMETADATA_GETCOLUMNCOUNT(416, "ResultSetMetaData.getColumnCount",
false, false, true, false),
  RESULTSETMETADATA_ISAUTOINCREMENT(417, "ResultSetMetaData.isAutoIncrement",
false, false, true, false),
  RESULTSETMETADATA_ISCASESENSITIVE(418, "ResultSetMetaData.isCaseSensitive",
false, false, true, false),
  RESULTSETMETADATA_ISSEARCHABLE(419, "ResultSetMetaData.isSearchable",
false, false, true, false),
  RESULTSETMETADATA_ISCURRENCY(420, "ResultSetMetaData.isCurrency",
false, false, true, false),
  RESULTSETMETADATA_ISNULLABLE(421, "ResultSetMetaData.isNullable",
false, false, true, false),
  RESULTSETMETADATA_ISSIGNED(422, "ResultSetMetaData.isSigned",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNDISPLAYSIZE(423, "ResultSetMetaData.getColumnDisplaySize",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNLABEL(424, "ResultSetMetaData.getColumnLabel",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNNAME(425, "ResultSetMetaData.getColumnName",
false, false, true, false),
  RESULTSETMETADATA_GETSCHEMANAME(426, "ResultSetMetaData.getSchemaName",
false, false, true, false),
  RESULTSETMETADATA_GETPRECISION(427, "ResultSetMetaData.getPrecision",
false, false, true, false),
  RESULTSETMETADATA_GETSCALE(428, "ResultSetMetaData.getScale",
false, false, true, false),
  RESULTSETMETADATA_GETTABLENAME(429, "ResultSetMetaData.getTableName",
false, false, true, false),
  RESULTSETMETADATA_GETCATALOGNAME(430, "ResultSetMetaData.getCatalogName",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNTYPE(431, "ResultSetMetaData.getColumnType",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNTYPENAME(432, "ResultSetMetaData.getColumnTypeName",
false, false, true, false),
  RESULTSETMETADATA_ISREADONLY(433, "ResultSetMetaData.isReadOnly",
false, false, true, false),
  RESULTSETMETADATA_ISWRITABLE(434, "ResultSetMetaData.isWritable",
false, false, true, false),
  RESULTSETMETADATA_ISDEFINITELYWRITABLE(435, "ResultSetMetaData.isDefinitelyWritable",
false, false, true, false),
  RESULTSETMETADATA_GETCOLUMNCLASSNAME(436, "ResultSetMetaData.getColumnClassName",
false, false, true, false),


  RESULTSET_ABSOLUTE(437, "ResultSet.absolute",
false, false, true, false),
  RESULTSET_AFTERLAST(438, "ResultSet.afterLast",
false, false, true, false),
  RESULTSET_BEFOREFIRST(439, "ResultSet.beforeFirst",
false, false, true, false),
  RESULTSET_CANCELROWUPDATES(440, "ResultSet.cancelRowUpdates",
false, false, true, false),
  RESULTSET_CLEARWARNINGS(441, "ResultSet.clearWarnings",
false, false, true, false),
  RESULTSET_CLOSE(442, "ResultSet.close",
false, false, true, false),
  RESULTSET_DELETEROW(443, "ResultSet.deleteRow",
false, false, true, false),
  RESULTSET_FINDCOLUMN(444, "ResultSet.findColumn",
false, false, true, false),
  RESULTSET_FIRST(445, "ResultSet.first",
false, false, true, false),
  RESULTSET_GETARRAY(446, "ResultSet.getArray",
false, true, true, false),
  RESULTSET_GETASCIISTREAM(447, "ResultSet.getAsciiStream",
false, false, true, false),
  RESULTSET_GETBIGDECIMAL(448, "ResultSet.getBigDecimal",
false, false, true, false),
  RESULTSET_GETBINARYSTREAM(449, "ResultSet.getBinaryStream",
false, false, true, false),
  RESULTSET_GETBLOB(450, "ResultSet.getBlob",
false, true, true, false),
  RESULTSET_GETBOOLEAN(451, "ResultSet.getBoolean",
false, false, true, false),
  RESULTSET_GETBYTE(452, "ResultSet.getByte",
false, false, true, false),
  RESULTSET_GETBYTES(453, "ResultSet.getBytes",
false, false, true, false),
  RESULTSET_GETCHARACTERSTREAM(454, "ResultSet.getCharacterStream",
false, false, true, false),
  RESULTSET_GETCLOB(455, "ResultSet.getClob",
false, true, true, false),
  RESULTSET_GETCONCURRENCY(456, "ResultSet.getConcurrency",
false, false, true, false),
  RESULTSET_GETCURSORNAME(457, "ResultSet.getCursorName",
false, false, true, false),
  RESULTSET_GETDATE(458, "ResultSet.getDate",
false, false, true, false),
  RESULTSET_GETDOUBLE(459, "ResultSet.getDouble",
false, false, true, false),
  RESULTSET_GETFETCHDIRECTION(460, "ResultSet.getFetchDirection",
false, false, true, false),
  RESULTSET_GETFETCHSIZE(461, "ResultSet.getFetchSize",
false, false, true, false),
  RESULTSET_GETFLOAT(462, "ResultSet.getFloat",
false, false, true, false),
  RESULTSET_GETHOLDABILITY(463, "ResultSet.getHoldability",
false, false, true, false),
  RESULTSET_GETINT(464, "ResultSet.getInt",
false, false, true, false),
  RESULTSET_GETLONG(465, "ResultSet.getLong",
false, false, true, false),
  RESULTSET_GETMETADATA(466, "ResultSet.getMetaData",
false, true, true, false),
  RESULTSET_GETNCHARACTERSTREAM(467, "ResultSet.getNCharacterStream",
false, false, true, false),
  RESULTSET_GETNCLOB(468, "ResultSet.getNClob",
false, true, true, false),
  RESULTSET_GETNSTRING(469, "ResultSet.getNString",
false, false, true, false),
  RESULTSET_GETOBJECT(470, "ResultSet.getObject",
false, false, true, false),
  RESULTSET_GETREF(471, "ResultSet.getRef",
false, true, true, false),
  RESULTSET_GETROW(472, "ResultSet.getRow",
false, false, true, false),
  RESULTSET_GETROWID(473, "ResultSet.getRowId",
false, false, true, false),
  RESULTSET_GETSQLXML(474, "ResultSet.getSQLXML",
false, false, true, false),
  RESULTSET_GETSHORT(475, "ResultSet.getShort",
false, false, true, false),
  RESULTSET_GETSTATEMENT(476, "ResultSet.getStatement",
false, true, true, true),
  RESULTSET_GETSTRING(477, "ResultSet.getString",
false, false, true, false),
  RESULTSET_GETTIME(478, "ResultSet.getTime",
false, false, true, false),
  RESULTSET_GETTIMESTAMP(479, "ResultSet.getTimestamp",
false, false, true, false),
  RESULTSET_GETTYPE(480, "ResultSet.getType",
false, false, true, false),
  RESULTSET_GETURL(481, "ResultSet.getURL",
false, false, true, false),
  RESULTSET_GETUNICODESTREAM(482, "ResultSet.getUnicodeStream",
false, false, true, false),
  RESULTSET_GETWARNINGS(483, "ResultSet.getWarnings",
false, false, true, false),
  RESULTSET_INSERTROW(484, "ResultSet.insertRow",
false, false, true, false),
  RESULTSET_ISAFTERLAST(485, "ResultSet.isAfterLast",
false, false, true, false),
  RESULTSET_ISBEFOREFIRST(486, "ResultSet.isBeforeFirst",
false, false, true, false),
  RESULTSET_ISCLOSED(487, "ResultSet.isClosed",
false, false, true, false),
  RESULTSET_ISFIRST(488, "ResultSet.isFirst",
false, false, true, false),
  RESULTSET_ISLAST(489, "ResultSet.isLast",
false, false, true, false),
  RESULTSET_LAST(490, "ResultSet.last",
false, false, true, false),
  RESULTSET_MOVETOCURRENTROW(491, "ResultSet.moveToCurrentRow",
false, false, true, false),
  RESULTSET_MOVETOINSERTROW(492, "ResultSet.moveToInsertRow",
false, false, true, false),
  RESULTSET_NEXT(493, "ResultSet.next",
false, false, true, false),
  RESULTSET_PREVIOUS(494, "ResultSet.previous",
false, false, true, false),
  RESULTSET_REFRESHROW(495, "ResultSet.refreshRow",
false, false, true, false),
  RESULTSET_RELATIVE(496, "ResultSet.relative",
false, false, true, false),
  RESULTSET_ROWDELETED(497, "ResultSet.rowDeleted",
false, false, true, false),
  RESULTSET_ROWINSERTED(498, "ResultSet.rowInserted",
false, false, true, false),
  RESULTSET_ROWUPDATED(499, "ResultSet.rowUpdated",
false, false, true, false),
  RESULTSET_SETFETCHDIRECTION(500, "ResultSet.setFetchDirection",
false, false, true, false),
  RESULTSET_SETFETCHSIZE(501, "ResultSet.setFetchSize",
false, false, true, false),
  RESULTSET_UPDATEARRAY(502, "ResultSet.updateArray",
false, false, true, false),
  RESULTSET_UPDATEASCIISTREAM(503, "ResultSet.updateAsciiStream",
false, false, true, false),
  RESULTSET_UPDATEBIGDECIMAL(504, "ResultSet.updateBigDecimal",
false, false, true, false),
  RESULTSET_UPDATEBINARYSTREAM(505, "ResultSet.updateBinaryStream",
false, false, true, false),
  RESULTSET_UPDATEBLOB(506, "ResultSet.updateBlob",
false, false, true, false),
  RESULTSET_UPDATEBOOLEAN(507, "ResultSet.updateBoolean",
false, false, true, false),
  RESULTSET_UPDATEBYTE(508, "ResultSet.updateByte",
false, false, true, false),
  RESULTSET_UPDATEBYTES(509, "ResultSet.updateBytes",
false, false, true, false),
  RESULTSET_UPDATECHARACTERSTREAM(510, "ResultSet.updateCharacterStream",
false, false, true, false),
  RESULTSET_UPDATECLOB(511, "ResultSet.updateClob",
false, false, true, false),
  RESULTSET_UPDATEDATE(512, "ResultSet.updateDate",
false, false, true, false),
  RESULTSET_UPDATEDOUBLE(513, "ResultSet.updateDouble",
false, false, true, false),
  RESULTSET_UPDATEFLOAT(514, "ResultSet.updateFloat",
false, false, true, false),
  RESULTSET_UPDATEINT(515, "ResultSet.updateInt",
false, false, true, false),
  RESULTSET_UPDATELONG(516, "ResultSet.updateLong",
false, false, true, false),
  RESULTSET_UPDATENCHARACTERSTREAM(517, "ResultSet.updateNCharacterStream",
false, false, true, false),
  RESULTSET_UPDATENCLOB(518, "ResultSet.updateNClob",
false, false, true, false),
  RESULTSET_UPDATENSTRING(519, "ResultSet.updateNString",
false, false, true, false),
  RESULTSET_UPDATENULL(520, "ResultSet.updateNull",
false, false, true, false),
  RESULTSET_UPDATEOBJECT(521, "ResultSet.updateObject",
false, false, true, false),
  RESULTSET_UPDATEREF(522, "ResultSet.updateRef",
false, false, true, false),
  RESULTSET_UPDATEROW(523, "ResultSet.updateRow",
false, false, true, false),
  RESULTSET_UPDATEROWID(524, "ResultSet.updateRowId",
false, false, true, false),
  RESULTSET_UPDATESQLXML(525, "ResultSet.updateSQLXML",
false, false, true, false),
  RESULTSET_UPDATESHORT(526, "ResultSet.updateShort",
false, false, true, false),
  RESULTSET_UPDATESTRING(527, "ResultSet.updateString",
false, false, true, false),
  RESULTSET_UPDATETIME(528, "ResultSet.updateTime",
false, false, true, false),
  RESULTSET_UPDATETIMESTAMP(529, "ResultSet.updateTimestamp",
false, false, true, false),
  RESULTSET_WASNULL(530, "ResultSet.wasNull",
false, false, true, false),


  SAVEPOINT_GETSAVEPOINTID(531, "Savepoint.getSavepointId",
false, false, true, false),
  SAVEPOINT_GETSAVEPOINTNAME(532, "Savepoint.getSavepointName",
false, false, true, false),


  SQLDATA_GETSQLTYPENAME(533, "SQLData.getSQLTypeName",
false, false, true, false),
  SQLDATA_READSQL(534, "SQLData.readSQL",
false, false, true, false),
  SQLDATA_WRITESQL(535, "SQLData.writeSQL",
false, false, true, false),


  SQLINPUT_READSTRING(536, "SQLInput.readString",
false, false, true, false),
  SQLINPUT_READBOOLEAN(537, "SQLInput.readBoolean",
false, false, true, false),
  SQLINPUT_READBYTE(538, "SQLInput.readByte",
false, false, true, false),
  SQLINPUT_READSHORT(539, "SQLInput.readShort",
false, false, true, false),
  SQLINPUT_READINT(540, "SQLInput.readInt",
false, false, true, false),
  SQLINPUT_READLONG(541, "SQLInput.readLong",
false, false, true, false),
  SQLINPUT_READFLOAT(542, "SQLInput.readFloat",
false, false, true, false),
  SQLINPUT_READDOUBLE(543, "SQLInput.readDouble",
false, false, true, false),
  SQLINPUT_READBIGDECIMAL(544, "SQLInput.readBigDecimal",
false, false, true, false),
  SQLINPUT_READBYTES(545, "SQLInput.readBytes",
false, false, true, false),
  SQLINPUT_READDATE(546, "SQLInput.readDate",
false, false, true, false),
  SQLINPUT_READTIME(547, "SQLInput.readTime",
false, false, true, false),
  SQLINPUT_READTIMESTAMP(548, "SQLInput.readTimestamp",
false, false, true, false),
  SQLINPUT_READCHARACTERSTREAM(549, "SQLInput.readCharacterStream",
false, false, true, false),
  SQLINPUT_READASCIISTREAM(550, "SQLInput.readAsciiStream",
false, false, true, false),
  SQLINPUT_READBINARYSTREAM(551, "SQLInput.readBinaryStream",
false, false, true, false),
  SQLINPUT_READOBJECT(552, "SQLInput.readObject",
false, false, true, false),
  SQLINPUT_READREF(553, "SQLInput.readRef",
false, true, true, false),
  SQLINPUT_READBLOB(554, "SQLInput.readBlob",
false, true, true, false),
  SQLINPUT_READCLOB(555, "SQLInput.readClob",
false, true, true, false),
  SQLINPUT_READARRAY(556, "SQLInput.readArray",
false, true, true, false),
  SQLINPUT_WASNULL(557, "SQLInput.wasNull",
false, false, true, false),
  SQLINPUT_READURL(558, "SQLInput.readURL",
false, false, true, false),
  SQLINPUT_READNCLOB(559, "SQLInput.readNClob",
false, true, true, false),
  SQLINPUT_READNSTRING(560, "SQLInput.readNString",
false, false, true, false),
  SQLINPUT_READSQLXML(561, "SQLInput.readSQLXML",
false, false, true, false),
  SQLINPUT_READROWID(562, "SQLInput.readRowId",
false, false, true, false),


  SQLOUTPUT_WRITESTRING(563, "SQLOutput.writeString",
false, false, true, false),
  SQLOUTPUT_WRITEBOOLEAN(564, "SQLOutput.writeBoolean",
false, false, true, false),
  SQLOUTPUT_WRITEBYTE(565, "SQLOutput.writeByte",
false, false, true, false),
  SQLOUTPUT_WRITESHORT(566, "SQLOutput.writeShort",
false, false, true, false),
  SQLOUTPUT_WRITEINT(567, "SQLOutput.writeInt",
false, false, true, false),
  SQLOUTPUT_WRITELONG(568, "SQLOutput.writeLong",
false, false, true, false),
  SQLOUTPUT_WRITEFLOAT(569, "SQLOutput.writeFloat",
false, false, true, false),
  SQLOUTPUT_WRITEDOUBLE(570, "SQLOutput.writeDouble",
false, false, true, false),
  SQLOUTPUT_WRITEBIGDECIMAL(571, "SQLOutput.writeBigDecimal",
false, false, true, false),
  SQLOUTPUT_WRITEBYTES(572, "SQLOutput.writeBytes",
false, false, true, false),
  SQLOUTPUT_WRITEDATE(573, "SQLOutput.writeDate",
false, false, true, false),
  SQLOUTPUT_WRITETIME(574, "SQLOutput.writeTime",
false, false, true, false),
  SQLOUTPUT_WRITETIMESTAMP(575, "SQLOutput.writeTimestamp",
false, false, true, false),
  SQLOUTPUT_WRITECHARACTERSTREAM(576, "SQLOutput.writeCharacterStream",
false, false, true, false),
  SQLOUTPUT_WRITEASCIISTREAM(577, "SQLOutput.writeAsciiStream",
false, false, true, false),
  SQLOUTPUT_WRITEBINARYSTREAM(578, "SQLOutput.writeBinaryStream",
false, false, true, false),
  SQLOUTPUT_WRITEOBJECT(579, "SQLOutput.writeObject",
false, false, true, false),
  SQLOUTPUT_WRITEREF(580, "SQLOutput.writeRef",
false, false, true, false),
  SQLOUTPUT_WRITEBLOB(581, "SQLOutput.writeBlob",
false, false, true, false),
  SQLOUTPUT_WRITECLOB(582, "SQLOutput.writeClob",
false, false, true, false),
  SQLOUTPUT_WRITESTRUCT(583, "SQLOutput.writeStruct",
false, false, true, false),
  SQLOUTPUT_WRITEARRAY(584, "SQLOutput.writeArray",
false, false, true, false),
  SQLOUTPUT_WRITEURL(585, "SQLOutput.writeURL",
false, false, true, false),
  SQLOUTPUT_WRITENSTRING(586, "SQLOutput.writeNString",
false, false, true, false),
  SQLOUTPUT_WRITENCLOB(587, "SQLOutput.writeNClob",
false, false, true, false),
  SQLOUTPUT_WRITEROWID(588, "SQLOutput.writeRowId",
false, false, true, false),
  SQLOUTPUT_WRITESQLXML(589, "SQLOutput.writeSQLXML",
false, false, true, false),


  SQLTYPE_GETNAME(590, "SQLType.getName",
false, false, true, false),
  SQLTYPE_GETVENDOR(591, "SQLType.getVendor",
false, false, true, false),
  SQLTYPE_GETVENDORTYPENUMBER(592, "SQLType.getVendorTypeNumber",
false, false, true, false),


  STATEMENT_EXECUTEQUERY(593, "Statement.executeQuery",
false, true, true, true),
  STATEMENT_EXECUTEUPDATE(594, "Statement.executeUpdate",
false, false, true, true),
  STATEMENT_CLOSE(595, "Statement.close",
false, false, true, false),
  STATEMENT_GETMAXFIELDSIZE(596, "Statement.getMaxFieldSize",
false, false, true, false),
  STATEMENT_SETMAXFIELDSIZE(597, "Statement.setMaxFieldSize",
false, false, true, false),
  STATEMENT_GETMAXROWS(598, "Statement.getMaxRows",
false, false, true, false),
  STATEMENT_SETMAXROWS(599, "Statement.setMaxRows",
false, false, true, false),
  STATEMENT_SETESCAPEPROCESSING(600, "Statement.setEscapeProcessing",
false, false, true, false),
  STATEMENT_GETQUERYTIMEOUT(601, "Statement.getQueryTimeout",
false, false, true, false),
  STATEMENT_SETQUERYTIMEOUT(602, "Statement.setQueryTimeout",
false, false, true, false),
  STATEMENT_CANCEL(603, "Statement.cancel",
false, false, false, false),
  STATEMENT_GETWARNINGS(604, "Statement.getWarnings",
false, false, true, false),
  STATEMENT_CLEARWARNINGS(605, "Statement.clearWarnings",
false, false, true, false),
  STATEMENT_SETCURSORNAME(606, "Statement.setCursorName",
false, false, true, false),
  STATEMENT_EXECUTE(607, "Statement.execute",
false, false, true, true),
  STATEMENT_GETRESULTSET(608, "Statement.getResultSet",
false, true, true, false),
  STATEMENT_GETUPDATECOUNT(609, "Statement.getUpdateCount",
false, false, true, false),
  STATEMENT_GETMORERESULTS(610, "Statement.getMoreResults",
false, false, true, false),
  STATEMENT_GETFETCHDIRECTION(611, "Statement.getFetchDirection",
false, false, true, false),
  STATEMENT_SETFETCHDIRECTION(612, "Statement.setFetchDirection",
false, false, true, false),
  STATEMENT_GETFETCHSIZE(613, "Statement.getFetchSize",
false, false, true, false),
  STATEMENT_SETFETCHSIZE(614, "Statement.setFetchSize",
false, false, true, false),
  STATEMENT_GETRESULTSETCONCURRENCY(615, "Statement.getResultSetConcurrency",
false, false, true, false),
  STATEMENT_GETRESULTSETTYPE(616, "Statement.getResultSetType",
false, false, true, false),
  STATEMENT_ADDBATCH(617, "Statement.addBatch",
false, false, true, false),
  STATEMENT_CLEARBATCH(618, "Statement.clearBatch",
false, false, true, false),
  STATEMENT_EXECUTEBATCH(619, "Statement.executeBatch",
false, false, true, true),
  STATEMENT_GETCONNECTION(620, "Statement.getConnection",
false, true, true, true),
  STATEMENT_GETGENERATEDKEYS(621, "Statement.getGeneratedKeys",
false, true, true, false),
  STATEMENT_GETRESULTSETHOLDABILITY(622, "Statement.getResultSetHoldability",
false, false, true, false),
  STATEMENT_ISCLOSED(623, "Statement.isClosed",
false, false, true, false),
  STATEMENT_ISPOOLABLE(624, "Statement.isPoolable",
false, false, true, false),
  STATEMENT_SETPOOLABLE(625, "Statement.setPoolable",
false, false, true, false),
  STATEMENT_CLOSEONCOMPLETION(626, "Statement.closeOnCompletion",
false, false, true, false),
  STATEMENT_ISCLOSEONCOMPLETION(627, "Statement.isCloseOnCompletion",
false, false, true, false),


  STRUCT_GETSQLTYPENAME(628, "Struct.getSQLTypeName",
false, false, true, false),
  STRUCT_GETATTRIBUTES(629, "Struct.getAttributes",
false, false, true, false),


  DATABASEMETADATA_SUPPORTSRESULTSETHOLDABILITY(630, "DatabaseMetaData.supportsResultSetHoldability",
false, false, true, false),
  CONNECTION_GETAUTOCOMMIT(631, "Connection.getAutoCommit",
      false, false, true, false),


  // Additional calls to pipelines are below.
  // These calls are not associated with JDBC calls but they're needed for plugins to subscribe.
  // Only "id", "methodName" and "alwaysUsePipeline" are applicable for the following call desciptions.
  // Other fields are ignored in the code.

  CONNECT(632, "connect",
true, false, false, false),
  FORCECONNECT(633, "forceConnect",
true, false, false, false),
  ACCEPTSSTRATEGY(634, "acceptsStrategy",
true, false, true, false),
  GETHOSTSPECBYSTRATEGY(635, "getHostSpecByStrategy",
true, false, true, false),
  INITHOSTPROVIDER(636, "initHostProvider",
true, false, true, false),
  NOTIFYCONNECTIONCHANGED(637, "notifyConnectionChanged",
true, false, true, false),
  NOTIFYNODELISTCHANGED(638, "notifyNodeListChanged",
true, false, true, false),
  ALL(639, "*",
      false, false, true, false);



  public final int id;
  public final String methodName;
  public final boolean alwaysUsePipeline;
  public final boolean wrapResults;
  public final boolean shouldLockConnection;
  public final boolean checkBoundedConnection;

  JdbcMethod(
      int id,
      String methodName,
      boolean alwaysUsePipeline,
      boolean wrapResults,
      boolean shouldLockConnection,
      boolean checkBoundedConnection) {
    this.id = id;
    this.methodName = methodName;
    this.alwaysUsePipeline = alwaysUsePipeline;
    this.wrapResults = wrapResults;
    this.shouldLockConnection = shouldLockConnection;
    this.checkBoundedConnection = checkBoundedConnection;
  }
}
