/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MariadbTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MysqlConnectorJTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.PgTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectProvider;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public class TargetDriverDialectManager
implements TargetDriverDialectProvider {
    private static final Logger LOGGER = Logger.getLogger(TargetDriverDialectManager.class.getName());
    protected static TargetDriverDialect customDialect;
    public static final AwsWrapperProperty TARGET_DRIVER_DIALECT;
    protected static final Map<String, TargetDriverDialect> knownDialectsByCode;

    public static void setCustomDialect(@NonNull TargetDriverDialect targetDriverDialect) {
        customDialect = targetDriverDialect;
    }

    public static void resetCustomDialect() {
        customDialect = null;
    }

    @Override
    public TargetDriverDialect getDialect(@NonNull Driver driver, @NonNull Properties props) throws SQLException {
        return this.getDialect(props, (TargetDriverDialect targetDriverDialect) -> targetDriverDialect.isDialect(driver));
    }

    @Override
    public TargetDriverDialect getDialect(@NonNull String dataSourceClass, @NonNull Properties props) throws SQLException {
        return this.getDialect(props, (TargetDriverDialect targetDriverDialect) -> targetDriverDialect.isDialect(dataSourceClass));
    }

    private TargetDriverDialect getDialect(@NonNull Properties props, Function<TargetDriverDialect, Boolean> checkFunc) throws SQLException {
        String dialectCode;
        if (customDialect != null) {
            if (checkFunc.apply(customDialect).booleanValue()) {
                this.logDialect("custom", customDialect);
                return customDialect;
            }
            LOGGER.warning(() -> Messages.get("TargetDriverDialectManager.customDialectNotSupported"));
        }
        if (!StringUtils.isNullOrEmpty(dialectCode = TARGET_DRIVER_DIALECT.getString(props))) {
            TargetDriverDialect result = knownDialectsByCode.get(dialectCode);
            if (result == null) {
                throw new SQLException(Messages.get("TargetDriverDialectManager.unknownDialectCode", new Object[]{dialectCode}));
            }
            this.logDialect(dialectCode, result);
            return result;
        }
        for (Map.Entry<String, TargetDriverDialect> entry : knownDialectsByCode.entrySet()) {
            if (!checkFunc.apply(entry.getValue()).booleanValue()) continue;
            this.logDialect(entry.getKey(), entry.getValue());
            return entry.getValue();
        }
        TargetDriverDialect result = knownDialectsByCode.get("generic");
        this.logDialect("generic", result);
        return result;
    }

    private void logDialect(String dialectCode, TargetDriverDialect targetDriverDialect) {
        LOGGER.finest(() -> Messages.get("TargetDriverDialectManager.useDialect", new Object[]{dialectCode, targetDriverDialect}));
    }

    static {
        TARGET_DRIVER_DIALECT = new AwsWrapperProperty("wrapperTargetDriverDialect", "", "A unique identifier for the target driver dialect.");
        knownDialectsByCode = new HashMap<String, TargetDriverDialect>(){
            {
                this.put("pgjdbc", new PgTargetDriverDialect());
                this.put("mysql-connector-j", new MysqlConnectorJTargetDriverDialect());
                this.put("mariadb-connector-j-3", new MariadbTargetDriverDialect());
                this.put("generic", new GenericTargetDriverDialect());
            }
        };
    }
}

