/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.ds;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import software.amazon.jdbc.ds.AwsWrapperDataSource;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;

public class AwsWrapperDataSourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        List<String> dataSourcePropertyNames = Arrays.asList("user", "password", "jdbcUrl", "targetDataSourceClassName", "jdbcProtocol", "serverName", "serverPort", "database");
        Reference reference = (Reference)obj;
        AwsWrapperDataSource ds = new AwsWrapperDataSource();
        List<Method> dsMethods = Arrays.asList(AwsWrapperDataSource.class.getMethods());
        for (String dataSourceProperty : dataSourcePropertyNames) {
            String referencePropertyContent = (String)reference.get(dataSourceProperty).getContent();
            if (StringUtils.isNullOrEmpty(referencePropertyContent)) continue;
            PropertyUtils.setPropertyOnTarget(ds, dataSourceProperty, referencePropertyContent, dsMethods);
        }
        ArrayList<RefAddr> refAddrList = Collections.list(reference.getAll());
        Properties props = new Properties();
        for (RefAddr refAddr : refAddrList) {
            if (dataSourcePropertyNames.contains(refAddr.getType())) continue;
            props.setProperty(refAddr.getType(), (String)refAddr.getContent());
        }
        ds.setTargetDataSourceProperties(props);
        return ds;
    }
}

