/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package software.amazon.jdbc.util;

public final class DriverInfo {

  // Driver name
  public static final String DRIVER_NAME = "Amazon Web Services (AWS) Advanced JDBC Wrapper";
  public static final String DRIVER_VERSION = "2.2.5";

  // Driver version
  public static final int MAJOR_VERSION = 2;
  public static final int MINOR_VERSION = 2;
  public static final int PATCH_VERSION = 5;
  public static final String REVISION_VERSION = "1fa465368c285cd569e39f08447609150240447c";

  // JDBC specification
  public static final String JDBC_VERSION = "4.2";
  public static final int JDBC_MAJOR_VERSION = JDBC_VERSION.charAt(0) - '0';
  public static final int JDBC_MINOR_VERSION = JDBC_VERSION.charAt(2) - '0';

  private DriverInfo() {
  }
}
