/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.encryption.s3.internal.MultiFileOutputStream;
import software.amazon.encryption.s3.internal.UploadObjectObserver;

public class MultipartConfiguration {
    private final long _partSize;
    private final int _maxConnections;
    private final long _diskLimit;
    private final UploadObjectObserver _observer;
    private final ExecutorService _es;
    private final boolean _usingDefaultExecutorService;
    private final MultiFileOutputStream _outputStream;

    public MultipartConfiguration(Builder builder) {
        this._maxConnections = builder._maxConnections;
        this._partSize = builder._partSize;
        this._diskLimit = builder._diskLimit;
        this._observer = builder._observer;
        this._es = builder._es;
        this._usingDefaultExecutorService = builder._usingDefaultExecutorService;
        this._outputStream = builder._outputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int maxConnections() {
        return this._maxConnections;
    }

    public long partSize() {
        return this._partSize;
    }

    public long diskLimit() {
        return this._diskLimit;
    }

    public MultiFileOutputStream multiFileOutputStream() {
        return this._outputStream;
    }

    public UploadObjectObserver uploadObjectObserver() {
        return this._observer;
    }

    public ExecutorService executorService() {
        return this._es;
    }

    public boolean usingDefaultExecutorService() {
        return this._usingDefaultExecutorService;
    }

    public static class Builder {
        private final long MIN_PART_SIZE = 0x500000L;
        private MultiFileOutputStream _outputStream = new MultiFileOutputStream();
        private int _maxConnections = 50;
        private long _partSize = 0x500000L;
        private long _diskLimit = Long.MAX_VALUE;
        private UploadObjectObserver _observer = new UploadObjectObserver();
        private ExecutorService _es = null;
        private boolean _usingDefaultExecutorService;

        private Builder() {
        }

        public Builder maxConnections(int maxConnections) {
            this._maxConnections = maxConnections;
            return this;
        }

        public Builder partSize(long partSize) {
            if (partSize < 0x500000L) {
                throw new IllegalArgumentException("partSize must be at least 5242880");
            }
            this._partSize = partSize;
            return this;
        }

        public Builder diskLimit(long diskLimit) {
            this._diskLimit = diskLimit;
            return this;
        }

        public Builder uploadObjectObserver(UploadObjectObserver observer) {
            this._observer = observer;
            return this;
        }

        public Builder executorService(ExecutorService es) {
            this._es = es;
            return this;
        }

        public Builder multiFileOutputStream(MultiFileOutputStream outputStream) {
            this._outputStream = outputStream;
            return this;
        }

        public MultipartConfiguration build() {
            if (this._es == null) {
                this._es = Executors.newFixedThreadPool(this._maxConnections);
                this._usingDefaultExecutorService = true;
            } else {
                this._usingDefaultExecutorService = false;
            }
            return new MultipartConfiguration(this);
        }
    }
}

