/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

public class EncryptedDataKey {
    private final String _keyProviderId;
    private final byte[] _keyProviderInfo;
    private final byte[] _encryptedDataKey;

    private EncryptedDataKey(Builder builder) {
        this._keyProviderId = builder._keyProviderId;
        this._keyProviderInfo = builder._keyProviderInfo;
        this._encryptedDataKey = builder._encryptedDataKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String keyProviderId() {
        return this._keyProviderId;
    }

    public byte[] keyProviderInfo() {
        if (this._keyProviderInfo == null) {
            return null;
        }
        return (byte[])this._keyProviderInfo.clone();
    }

    public byte[] encryptedDatakey() {
        if (this._encryptedDataKey == null) {
            return null;
        }
        return (byte[])this._encryptedDataKey.clone();
    }

    public static class Builder {
        private String _keyProviderId = null;
        private byte[] _keyProviderInfo = null;
        private byte[] _encryptedDataKey = null;

        private Builder() {
        }

        public Builder keyProviderId(String keyProviderId) {
            this._keyProviderId = keyProviderId;
            return this;
        }

        public Builder keyProviderInfo(byte[] keyProviderInfo) {
            this._keyProviderInfo = keyProviderInfo == null ? null : (byte[])keyProviderInfo.clone();
            return this;
        }

        public Builder encryptedDataKey(byte[] encryptedDataKey) {
            this._encryptedDataKey = encryptedDataKey == null ? null : (byte[])encryptedDataKey.clone();
            return this;
        }

        public EncryptedDataKey build() {
            return new EncryptedDataKey(this);
        }
    }
}

