/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.legacy.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.legacy.internal.AdjustedRangeSubscriber;

public class RangedGetUtils {
    public static long[] getRange(String range) {
        if (range == null) {
            return null;
        }
        if (!range.matches("^bytes=(\\d+-\\d+|\\d+-)$")) {
            return null;
        }
        String[] rangeSplit = range.substring(6).split("-");
        long[] adjustedRange = new long[]{Long.parseLong(rangeSplit[0]), rangeSplit.length < 2 || rangeSplit[1].isEmpty() ? Long.MAX_VALUE : Long.parseLong(rangeSplit[1])};
        return adjustedRange;
    }

    public static String getCryptoRangeAsString(String desiredRange) {
        long[] cryptoRange = RangedGetUtils.getCryptoRange(desiredRange);
        return cryptoRange == null ? null : "bytes=" + cryptoRange[0] + "-" + cryptoRange[1];
    }

    public static long[] getCryptoRange(String desiredRange) {
        long[] range = RangedGetUtils.getRange(desiredRange);
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{RangedGetUtils.getCipherBlockLowerBound(range[0]), RangedGetUtils.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherBlockSizeBytes();
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        return lowerBound < 0L ? 0L : lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherBlockSizeBytes();
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        long upperBound = rightmostBytePosition + offset + cipherBlockSize;
        return upperBound < 0L ? Long.MAX_VALUE : upperBound;
    }

    private static long calculateMaxOffset(String contentRange, int cipherTagLengthBits) {
        int pos = contentRange.lastIndexOf("/");
        long instanceLength = Long.parseLong(contentRange.substring(pos + 1));
        return instanceLength - (long)(cipherTagLengthBits / 8) - 1L;
    }

    public static Subscriber<? super ByteBuffer> adjustToDesiredRange(Subscriber<? super ByteBuffer> subscriber, long[] cryptoRange, String contentRange, int cipherTagLengthBits) {
        if (cryptoRange == null || contentRange == null) {
            return subscriber;
        }
        long maxOffset = RangedGetUtils.calculateMaxOffset(contentRange, cipherTagLengthBits);
        if (cryptoRange[1] > maxOffset) {
            cryptoRange[1] = maxOffset;
            if (cryptoRange[0] > cryptoRange[1]) {
                try {
                    return new AdjustedRangeSubscriber(subscriber, cryptoRange[0], cryptoRange[1]);
                }
                catch (IOException e) {
                    throw new S3EncryptionClientException(e.getMessage());
                }
            }
        }
        if (cryptoRange[0] > cryptoRange[1]) {
            return subscriber;
        }
        try {
            return new AdjustedRangeSubscriber(subscriber, cryptoRange[0], cryptoRange[1]);
        }
        catch (IOException e) {
            throw new S3EncryptionClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }
}

