/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.SdkPartType;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.ConvertSDKRequests;
import software.amazon.encryption.s3.internal.NoRetriesAsyncRequestBody;
import software.amazon.encryption.s3.internal.OnFileDelete;
import software.amazon.encryption.s3.internal.PartCreationEvent;

public class UploadObjectObserver {
    private final List<Future<Map<Integer, UploadPartResponse>>> futures = new ArrayList<Future<Map<Integer, UploadPartResponse>>>();
    private PutObjectRequest request;
    private String uploadId;
    private S3AsyncClient s3AsyncClient;
    private S3EncryptionClient s3EncryptionClient;
    private ExecutorService es;

    public UploadObjectObserver init(PutObjectRequest req, S3AsyncClient s3AsyncClient, S3EncryptionClient s3EncryptionClient, ExecutorService es) {
        this.request = req;
        this.s3AsyncClient = s3AsyncClient;
        this.s3EncryptionClient = s3EncryptionClient;
        this.es = es;
        return this;
    }

    public String onUploadCreation(PutObjectRequest req) {
        CreateMultipartUploadResponse res = this.s3EncryptionClient.createMultipartUpload(ConvertSDKRequests.convertRequest(req));
        this.uploadId = res.uploadId();
        return this.uploadId;
    }

    public void onPartCreate(PartCreationEvent event) {
        final File part = event.getPart();
        final UploadPartRequest reqUploadPart = this.newUploadPartRequest(event);
        final OnFileDelete fileDeleteObserver = event.getFileDeleteObserver();
        this.futures.add(this.es.submit(new Callable<Map<Integer, UploadPartResponse>>(){

            @Override
            public Map<Integer, UploadPartResponse> call() {
                try {
                    NoRetriesAsyncRequestBody noRetriesBody = new NoRetriesAsyncRequestBody(AsyncRequestBody.fromFile((File)part));
                    Map<Integer, UploadPartResponse> map = UploadObjectObserver.this.uploadPart(reqUploadPart, noRetriesBody);
                    return map;
                }
                catch (CompletionException e) {
                    throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
                }
                finally {
                    if (!part.delete()) {
                        LogFactory.getLog(this.getClass()).debug((Object)("Ignoring failure to delete file " + part + " which has already been uploaded"));
                    } else if (fileDeleteObserver != null) {
                        fileDeleteObserver.onFileDelete(null);
                    }
                }
            }
        }));
    }

    public CompleteMultipartUploadResponse onCompletion(List<CompletedPart> partETags) {
        return this.s3EncryptionClient.completeMultipartUpload(builder -> builder.bucket(this.request.bucket()).key(this.request.key()).uploadId(this.uploadId).multipartUpload(partBuilder -> partBuilder.parts((Collection)partETags)));
    }

    public void onAbort() {
        for (Future<Map<Integer, UploadPartResponse>> future : this.futures()) {
            future.cancel(true);
        }
        if (this.uploadId != null) {
            try {
                this.s3EncryptionClient.abortMultipartUpload(builder -> builder.bucket(this.request.bucket()).key(this.request.key()).uploadId(this.uploadId));
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).debug((Object)("Failed to abort multi-part upload: " + this.uploadId), (Throwable)e);
            }
        }
    }

    protected UploadPartRequest newUploadPartRequest(PartCreationEvent event) {
        SdkPartType partType = event.isLastPart() ? SdkPartType.LAST : SdkPartType.DEFAULT;
        return (UploadPartRequest)UploadPartRequest.builder().bucket(this.request.bucket()).key(this.request.key()).partNumber(Integer.valueOf(event.getPartNumber())).sdkPartType(partType).uploadId(this.uploadId).build();
    }

    protected Map<Integer, UploadPartResponse> uploadPart(UploadPartRequest reqUploadPart, AsyncRequestBody requestBody) {
        return Collections.singletonMap(reqUploadPart.partNumber(), (UploadPartResponse)this.s3AsyncClient.uploadPart(reqUploadPart, requestBody).join());
    }

    public List<Future<Map<Integer, UploadPartResponse>>> futures() {
        return this.futures;
    }
}

