/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;

public class ApiNameVersion {
    private static final ApiName API_NAME = ApiNameVersion.apiNameWithVersion();
    public static final Consumer<AwsRequestOverrideConfiguration.Builder> API_NAME_INTERCEPTOR = builder -> builder.addApiName(API_NAME);
    public static final String NAME = "AmazonS3Encrypt";
    public static final String API_VERSION_UNKNOWN = "3-unknown";

    public static ApiName apiNameWithVersion() {
        return ApiName.builder().name(NAME).version(ApiNameVersion.apiVersion()).build();
    }

    private static String apiVersion() {
        try {
            Properties properties = new Properties();
            ClassLoader loader = ApiNameVersion.class.getClassLoader();
            InputStream inputStream = loader.getResourceAsStream("project.properties");
            if (inputStream == null) {
                return API_VERSION_UNKNOWN;
            }
            properties.load(inputStream);
            return properties.getProperty("version");
        }
        catch (IOException ex) {
            return API_VERSION_UNKNOWN;
        }
    }
}

