/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InsightImpactGraphEdgeListCopier {
    static List<InsightImpactGraphEdge> copy(Collection<? extends InsightImpactGraphEdge> insightImpactGraphEdgeListParam) {
        List<InsightImpactGraphEdge> list;
        if (insightImpactGraphEdgeListParam == null || insightImpactGraphEdgeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InsightImpactGraphEdge> modifiableList = new ArrayList<>();
            insightImpactGraphEdgeListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InsightImpactGraphEdge> copyFromBuilder(
            Collection<? extends InsightImpactGraphEdge.Builder> insightImpactGraphEdgeListParam) {
        List<InsightImpactGraphEdge> list;
        if (insightImpactGraphEdgeListParam == null || insightImpactGraphEdgeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InsightImpactGraphEdge> modifiableList = new ArrayList<>();
            insightImpactGraphEdgeListParam.forEach(entry -> {
                InsightImpactGraphEdge member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InsightImpactGraphEdge.Builder> copyToBuilder(
            Collection<? extends InsightImpactGraphEdge> insightImpactGraphEdgeListParam) {
        List<InsightImpactGraphEdge.Builder> list;
        if (insightImpactGraphEdgeListParam == null || insightImpactGraphEdgeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InsightImpactGraphEdge.Builder> modifiableList = new ArrayList<>();
            insightImpactGraphEdgeListParam.forEach(entry -> {
                InsightImpactGraphEdge.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
