/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Value of a segment annotation. Has one of three value types: Number, Boolean, or String.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationValue implements SdkPojo, Serializable, ToCopyableBuilder<AnnotationValue.Builder, AnnotationValue> {
    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("NumberValue").getter(getter(AnnotationValue::numberValue)).setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BooleanValue").getter(getter(AnnotationValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(AnnotationValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_VALUE_FIELD,
            BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double numberValue;

    private final Boolean booleanValue;

    private final String stringValue;

    private final Type type;

    private AnnotationValue(BuilderImpl builder) {
        this.numberValue = builder.numberValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * Value for a Number annotation.
     * </p>
     * 
     * @return Value for a Number annotation.
     */
    public final Double numberValue() {
        return numberValue;
    }

    /**
     * <p>
     * Value for a Boolean annotation.
     * </p>
     * 
     * @return Value for a Boolean annotation.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * Value for a String annotation.
     * </p>
     * 
     * @return Value for a String annotation.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue) obj;
        return Objects.equals(numberValue(), other.numberValue()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationValue").add("NumberValue", numberValue()).add("BooleanValue", booleanValue())
                .add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        case "BooleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #numberValue()} initialized to the given value.
     *
     * <p>
     * Value for a Number annotation.
     * </p>
     * 
     * @param numberValue
     *        Value for a Number annotation.
     */
    public static AnnotationValue fromNumberValue(Double numberValue) {
        return builder().numberValue(numberValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * Value for a Boolean annotation.
     * </p>
     * 
     * @param booleanValue
     *        Value for a Boolean annotation.
     */
    public static AnnotationValue fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * Value for a String annotation.
     * </p>
     * 
     * @param stringValue
     *        Value for a String annotation.
     */
    public static AnnotationValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnnotationValue, T> g) {
        return obj -> g.apply((AnnotationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationValue> {
        /**
         * <p>
         * Value for a Number annotation.
         * </p>
         * 
         * @param numberValue
         *        Value for a Number annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(Double numberValue);

        /**
         * <p>
         * Value for a Boolean annotation.
         * </p>
         * 
         * @param booleanValue
         *        Value for a Boolean annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * Value for a String annotation.
         * </p>
         * 
         * @param stringValue
         *        Value for a String annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Double numberValue;

        private Boolean booleanValue;

        private String stringValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationValue model) {
            numberValue(model.numberValue);
            booleanValue(model.booleanValue);
            stringValue(model.stringValue);
        }

        public final Double getNumberValue() {
            return numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        @Override
        public AnnotationValue build() {
            return new AnnotationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnnotationValue#type()
     */
    public enum Type {
        NUMBER_VALUE,

        BOOLEAN_VALUE,

        STRING_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
