/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;

public class ListUserSettingsPublisher
implements SdkPublisher<ListUserSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListUserSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserSettingsPublisher(WorkSpacesWebAsyncClient client, ListUserSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserSettingsPublisher(WorkSpacesWebAsyncClient client, ListUserSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUserSettingsResponseFetcher
    implements AsyncPageFetcher<ListUserSettingsResponse> {
        private ListUserSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserSettingsResponse> nextPage(ListUserSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListUserSettingsPublisher.this.client.listUserSettings(ListUserSettingsPublisher.this.firstRequest);
            }
            return ListUserSettingsPublisher.this.client.listUserSettings((ListUserSettingsRequest)((Object)ListUserSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

