/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;

public class ListPortalsPublisher
implements SdkPublisher<ListPortalsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListPortalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortalsPublisher(WorkSpacesWebAsyncClient client, ListPortalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortalsPublisher(WorkSpacesWebAsyncClient client, ListPortalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPortalsResponseFetcher
    implements AsyncPageFetcher<ListPortalsResponse> {
        private ListPortalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPortalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPortalsResponse> nextPage(ListPortalsResponse previousPage) {
            if (previousPage == null) {
                return ListPortalsPublisher.this.client.listPortals(ListPortalsPublisher.this.firstRequest);
            }
            return ListPortalsPublisher.this.client.listPortals((ListPortalsRequest)((Object)ListPortalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

