/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmailmessageflow;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workmailmessageflow.DefaultWorkMailMessageFlowBaseClientBuilder;
import software.amazon.awssdk.services.workmailmessageflow.DefaultWorkMailMessageFlowClient;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowClient;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowClientBuilder;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowServiceClientConfiguration;
import software.amazon.awssdk.services.workmailmessageflow.endpoints.WorkMailMessageFlowEndpointProvider;

@SdkInternalApi
final class DefaultWorkMailMessageFlowClientBuilder
extends DefaultWorkMailMessageFlowBaseClientBuilder<WorkMailMessageFlowClientBuilder, WorkMailMessageFlowClient>
implements WorkMailMessageFlowClientBuilder {
    DefaultWorkMailMessageFlowClientBuilder() {
    }

    @Override
    public DefaultWorkMailMessageFlowClientBuilder endpointProvider(WorkMailMessageFlowEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkMailMessageFlowClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkMailMessageFlowClientBuilder.validateClientOptions(clientConfiguration);
        WorkMailMessageFlowServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkMailMessageFlowClient client = new DefaultWorkMailMessageFlowClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkMailMessageFlowServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkMailMessageFlowServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

