/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.ImpersonationRole;
import software.amazon.awssdk.services.workmail.model.ImpersonationRoleListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImpersonationRolesResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListImpersonationRolesResponse> {
    private static final SdkField<List<ImpersonationRole>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roles").getter(ListImpersonationRolesResponse.getter(ListImpersonationRolesResponse::roles)).setter(ListImpersonationRolesResponse.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpersonationRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImpersonationRolesResponse.getter(ListImpersonationRolesResponse::nextToken)).setter(ListImpersonationRolesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImpersonationRole> roles;
    private final String nextToken;

    private ListImpersonationRolesResponse(BuilderImpl builder) {
        super(builder);
        this.roles = builder.roles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<ImpersonationRole> roles() {
        return this.roles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImpersonationRolesResponse)) {
            return false;
        }
        ListImpersonationRolesResponse other = (ListImpersonationRolesResponse)((Object)obj);
        return this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImpersonationRolesResponse").add("Roles", this.hasRoles() ? this.roles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImpersonationRolesResponse, T> g) {
        return obj -> g.apply((ListImpersonationRolesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<ImpersonationRole> roles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImpersonationRolesResponse model) {
            super(model);
            this.roles(model.roles);
            this.nextToken(model.nextToken);
        }

        public final List<ImpersonationRole.Builder> getRoles() {
            List<ImpersonationRole.Builder> result = ImpersonationRoleListCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<ImpersonationRole.BuilderImpl> roles) {
            this.roles = ImpersonationRoleListCopier.copyFromBuilder(roles);
        }

        @Override
        public final Builder roles(Collection<ImpersonationRole> roles) {
            this.roles = ImpersonationRoleListCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(ImpersonationRole ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<ImpersonationRole.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (ImpersonationRole)((ImpersonationRole.Builder)ImpersonationRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImpersonationRolesResponse build() {
            return new ListImpersonationRolesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImpersonationRolesResponse> {
        public Builder roles(Collection<ImpersonationRole> var1);

        public Builder roles(ImpersonationRole ... var1);

        public Builder roles(Consumer<ImpersonationRole.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

