/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;

public class ListOrganizationsPublisher
implements SdkPublisher<ListOrganizationsResponse> {
    private final WorkMailAsyncClient client;
    private final ListOrganizationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationsPublisher(WorkMailAsyncClient client, ListOrganizationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationsPublisher(WorkMailAsyncClient client, ListOrganizationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListOrganizationsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationsResponse> {
        private ListOrganizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationsResponse> nextPage(ListOrganizationsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationsPublisher.this.client.listOrganizations(ListOrganizationsPublisher.this.firstRequest);
            }
            return ListOrganizationsPublisher.this.client.listOrganizations((ListOrganizationsRequest)((Object)ListOrganizationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

