/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workmail.DefaultWorkMailBaseClientBuilder;
import software.amazon.awssdk.services.workmail.DefaultWorkMailClient;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.WorkMailClientBuilder;
import software.amazon.awssdk.services.workmail.WorkMailServiceClientConfiguration;
import software.amazon.awssdk.services.workmail.endpoints.WorkMailEndpointProvider;

@SdkInternalApi
final class DefaultWorkMailClientBuilder
extends DefaultWorkMailBaseClientBuilder<WorkMailClientBuilder, WorkMailClient>
implements WorkMailClientBuilder {
    DefaultWorkMailClientBuilder() {
    }

    @Override
    public DefaultWorkMailClientBuilder endpointProvider(WorkMailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkMailClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkMailClientBuilder.validateClientOptions(clientConfiguration);
        WorkMailServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkMailClient client = new DefaultWorkMailClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkMailServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkMailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

