/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse;

public class ListImpersonationRolesIterable
implements SdkIterable<ListImpersonationRolesResponse> {
    private final WorkMailClient client;
    private final ListImpersonationRolesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImpersonationRolesIterable(WorkMailClient client, ListImpersonationRolesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImpersonationRolesResponseFetcher();
    }

    public Iterator<ListImpersonationRolesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImpersonationRolesResponseFetcher
    implements SyncPageFetcher<ListImpersonationRolesResponse> {
        private ListImpersonationRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListImpersonationRolesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImpersonationRolesResponse nextPage(ListImpersonationRolesResponse previousPage) {
            if (previousPage == null) {
                return ListImpersonationRolesIterable.this.client.listImpersonationRoles(ListImpersonationRolesIterable.this.firstRequest);
            }
            return ListImpersonationRolesIterable.this.client.listImpersonationRoles((ListImpersonationRolesRequest)((Object)ListImpersonationRolesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

