/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;

public class ListMailboxPermissionsPublisher
implements SdkPublisher<ListMailboxPermissionsResponse> {
    private final WorkMailAsyncClient client;
    private final ListMailboxPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMailboxPermissionsPublisher(WorkMailAsyncClient client, ListMailboxPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMailboxPermissionsPublisher(WorkMailAsyncClient client, ListMailboxPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMailboxPermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMailboxPermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMailboxPermissionsResponseFetcher
    implements AsyncPageFetcher<ListMailboxPermissionsResponse> {
        private ListMailboxPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailboxPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMailboxPermissionsResponse> nextPage(ListMailboxPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListMailboxPermissionsPublisher.this.client.listMailboxPermissions(ListMailboxPermissionsPublisher.this.firstRequest);
            }
            return ListMailboxPermissionsPublisher.this.client.listMailboxPermissions((ListMailboxPermissionsRequest)((Object)ListMailboxPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

