/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the website authorization provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebsiteAuthorizationProviderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WebsiteAuthorizationProviderSummary.Builder, WebsiteAuthorizationProviderSummary> {
    private static final SdkField<String> AUTHORIZATION_PROVIDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationProviderId").getter(getter(WebsiteAuthorizationProviderSummary::authorizationProviderId))
            .setter(setter(Builder::authorizationProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderId").build())
            .build();

    private static final SdkField<String> AUTHORIZATION_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationProviderType")
            .getter(getter(WebsiteAuthorizationProviderSummary::authorizationProviderTypeAsString))
            .setter(setter(Builder::authorizationProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderType").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(WebsiteAuthorizationProviderSummary::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(WebsiteAuthorizationProviderSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZATION_PROVIDER_ID_FIELD, AUTHORIZATION_PROVIDER_TYPE_FIELD, DOMAIN_NAME_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authorizationProviderId;

    private final String authorizationProviderType;

    private final String domainName;

    private final Instant createdTime;

    private WebsiteAuthorizationProviderSummary(BuilderImpl builder) {
        this.authorizationProviderId = builder.authorizationProviderId;
        this.authorizationProviderType = builder.authorizationProviderType;
        this.domainName = builder.domainName;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * A unique identifier for the authorization provider.
     * </p>
     * 
     * @return A unique identifier for the authorization provider.
     */
    public final String authorizationProviderId() {
        return authorizationProviderId;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationProviderType} will return {@link AuthorizationProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authorizationProviderTypeAsString}.
     * </p>
     * 
     * @return The authorization provider type.
     * @see AuthorizationProviderType
     */
    public final AuthorizationProviderType authorizationProviderType() {
        return AuthorizationProviderType.fromValue(authorizationProviderType);
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationProviderType} will return {@link AuthorizationProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authorizationProviderTypeAsString}.
     * </p>
     * 
     * @return The authorization provider type.
     * @see AuthorizationProviderType
     */
    public final String authorizationProviderTypeAsString() {
        return authorizationProviderType;
    }

    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     * 
     * @return The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The time of creation.
     * </p>
     * 
     * @return The time of creation.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteAuthorizationProviderSummary)) {
            return false;
        }
        WebsiteAuthorizationProviderSummary other = (WebsiteAuthorizationProviderSummary) obj;
        return Objects.equals(authorizationProviderId(), other.authorizationProviderId())
                && Objects.equals(authorizationProviderTypeAsString(), other.authorizationProviderTypeAsString())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebsiteAuthorizationProviderSummary").add("AuthorizationProviderId", authorizationProviderId())
                .add("AuthorizationProviderType", authorizationProviderTypeAsString()).add("DomainName", domainName())
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationProviderId":
            return Optional.ofNullable(clazz.cast(authorizationProviderId()));
        case "AuthorizationProviderType":
            return Optional.ofNullable(clazz.cast(authorizationProviderTypeAsString()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebsiteAuthorizationProviderSummary, T> g) {
        return obj -> g.apply((WebsiteAuthorizationProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebsiteAuthorizationProviderSummary> {
        /**
         * <p>
         * A unique identifier for the authorization provider.
         * </p>
         * 
         * @param authorizationProviderId
         *        A unique identifier for the authorization provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationProviderId(String authorizationProviderId);

        /**
         * <p>
         * The authorization provider type.
         * </p>
         * 
         * @param authorizationProviderType
         *        The authorization provider type.
         * @see AuthorizationProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationProviderType
         */
        Builder authorizationProviderType(String authorizationProviderType);

        /**
         * <p>
         * The authorization provider type.
         * </p>
         * 
         * @param authorizationProviderType
         *        The authorization provider type.
         * @see AuthorizationProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationProviderType
         */
        Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType);

        /**
         * <p>
         * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
         * </p>
         * 
         * @param domainName
         *        The domain name of the authorization provider. This applies only to SAML-based authorization
         *        providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The time of creation.
         * </p>
         * 
         * @param createdTime
         *        The time of creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationProviderId;

        private String authorizationProviderType;

        private String domainName;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteAuthorizationProviderSummary model) {
            authorizationProviderId(model.authorizationProviderId);
            authorizationProviderType(model.authorizationProviderType);
            domainName(model.domainName);
            createdTime(model.createdTime);
        }

        public final String getAuthorizationProviderId() {
            return authorizationProviderId;
        }

        public final void setAuthorizationProviderId(String authorizationProviderId) {
            this.authorizationProviderId = authorizationProviderId;
        }

        @Override
        public final Builder authorizationProviderId(String authorizationProviderId) {
            this.authorizationProviderId = authorizationProviderId;
            return this;
        }

        public final String getAuthorizationProviderType() {
            return authorizationProviderType;
        }

        public final void setAuthorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
        }

        @Override
        public final Builder authorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
            return this;
        }

        @Override
        public final Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType) {
            this.authorizationProviderType(authorizationProviderType == null ? null : authorizationProviderType.toString());
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public WebsiteAuthorizationProviderSummary build() {
            return new WebsiteAuthorizationProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
