/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSummary implements SdkPojo, Serializable, ToCopyableBuilder<DeviceSummary.Builder, DeviceSummary> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DeviceSummary::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceStatus").getter(getter(DeviceSummary::deviceStatusAsString)).setter(setter(Builder::deviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            DEVICE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceId;

    private final String deviceStatus;

    private DeviceSummary(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.deviceStatus = builder.deviceStatus;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final String deviceStatusAsString() {
        return deviceStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary) obj;
        return Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSummary").add("DeviceId", deviceId()).add("DeviceStatus", deviceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "DeviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSummary> {
        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private String deviceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            deviceId(model.deviceId);
            deviceStatus(model.deviceStatus);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        @Override
        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
