/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuditStreamConfigurationResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeAuditStreamConfigurationResponse.Builder, DescribeAuditStreamConfigurationResponse> {
    private static final SdkField<String> AUDIT_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditStreamArn").getter(getter(DescribeAuditStreamConfigurationResponse::auditStreamArn))
            .setter(setter(Builder::auditStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditStreamArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_STREAM_ARN_FIELD));

    private final String auditStreamArn;

    private DescribeAuditStreamConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.auditStreamArn = builder.auditStreamArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Kinesis data stream that will receive the audit events.
     * </p>
     * 
     * @return The ARN of the Amazon Kinesis data stream that will receive the audit events.
     */
    public final String auditStreamArn() {
        return auditStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(auditStreamArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditStreamConfigurationResponse)) {
            return false;
        }
        DescribeAuditStreamConfigurationResponse other = (DescribeAuditStreamConfigurationResponse) obj;
        return Objects.equals(auditStreamArn(), other.auditStreamArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAuditStreamConfigurationResponse").add("AuditStreamArn", auditStreamArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditStreamArn":
            return Optional.ofNullable(clazz.cast(auditStreamArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditStreamConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAuditStreamConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAuditStreamConfigurationResponse> {
        /**
         * <p>
         * The ARN of the Amazon Kinesis data stream that will receive the audit events.
         * </p>
         * 
         * @param auditStreamArn
         *        The ARN of the Amazon Kinesis data stream that will receive the audit events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditStreamArn(String auditStreamArn);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String auditStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditStreamConfigurationResponse model) {
            super(model);
            auditStreamArn(model.auditStreamArn);
        }

        public final String getAuditStreamArn() {
            return auditStreamArn;
        }

        public final void setAuditStreamArn(String auditStreamArn) {
            this.auditStreamArn = auditStreamArn;
        }

        @Override
        public final Builder auditStreamArn(String auditStreamArn) {
            this.auditStreamArn = auditStreamArn;
            return this;
        }

        @Override
        public DescribeAuditStreamConfigurationResponse build() {
            return new DescribeAuditStreamConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
