/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.AuthorizationProviderType;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateWebsiteAuthorizationProviderRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, AssociateWebsiteAuthorizationProviderRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(AssociateWebsiteAuthorizationProviderRequest.getter(AssociateWebsiteAuthorizationProviderRequest::fleetArn)).setter(AssociateWebsiteAuthorizationProviderRequest.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> AUTHORIZATION_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationProviderType").getter(AssociateWebsiteAuthorizationProviderRequest.getter(AssociateWebsiteAuthorizationProviderRequest::authorizationProviderTypeAsString)).setter(AssociateWebsiteAuthorizationProviderRequest.setter(Builder::authorizationProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderType").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AssociateWebsiteAuthorizationProviderRequest.getter(AssociateWebsiteAuthorizationProviderRequest::domainName)).setter(AssociateWebsiteAuthorizationProviderRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, AUTHORIZATION_PROVIDER_TYPE_FIELD, DOMAIN_NAME_FIELD));
    private final String fleetArn;
    private final String authorizationProviderType;
    private final String domainName;

    private AssociateWebsiteAuthorizationProviderRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.authorizationProviderType = builder.authorizationProviderType;
        this.domainName = builder.domainName;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final AuthorizationProviderType authorizationProviderType() {
        return AuthorizationProviderType.fromValue(this.authorizationProviderType);
    }

    public final String authorizationProviderTypeAsString() {
        return this.authorizationProviderType;
    }

    public final String domainName() {
        return this.domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebsiteAuthorizationProviderRequest)) {
            return false;
        }
        AssociateWebsiteAuthorizationProviderRequest other = (AssociateWebsiteAuthorizationProviderRequest)((Object)obj);
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.authorizationProviderTypeAsString(), other.authorizationProviderTypeAsString()) && Objects.equals(this.domainName(), other.domainName());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateWebsiteAuthorizationProviderRequest").add("FleetArn", (Object)this.fleetArn()).add("AuthorizationProviderType", (Object)this.authorizationProviderTypeAsString()).add("DomainName", (Object)this.domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "AuthorizationProviderType": {
                return Optional.ofNullable(clazz.cast(this.authorizationProviderTypeAsString()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWebsiteAuthorizationProviderRequest, T> g) {
        return obj -> g.apply((AssociateWebsiteAuthorizationProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetArn;
        private String authorizationProviderType;
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebsiteAuthorizationProviderRequest model) {
            super(model);
            this.fleetArn(model.fleetArn);
            this.authorizationProviderType(model.authorizationProviderType);
            this.domainName(model.domainName);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getAuthorizationProviderType() {
            return this.authorizationProviderType;
        }

        public final void setAuthorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
        }

        @Override
        public final Builder authorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
            return this;
        }

        @Override
        public final Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType) {
            this.authorizationProviderType(authorizationProviderType == null ? null : authorizationProviderType.toString());
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWebsiteAuthorizationProviderRequest build() {
            return new AssociateWebsiteAuthorizationProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateWebsiteAuthorizationProviderRequest> {
        public Builder fleetArn(String var1);

        public Builder authorizationProviderType(String var1);

        public Builder authorizationProviderType(AuthorizationProviderType var1);

        public Builder domainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

