/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.ConcurrentModificationException;
import software.amazon.awssdk.services.workdocs.model.ConflictingOperationException;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivatingLastSystemUserException;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentLockedForCommentsException;
import software.amazon.awssdk.services.workdocs.model.DraftUploadOutOfSyncException;
import software.amazon.awssdk.services.workdocs.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.workdocs.model.EntityNotExistsException;
import software.amazon.awssdk.services.workdocs.model.FailedDependencyException;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.GetResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.GetResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.IllegalUserStateException;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.InvalidArgumentException;
import software.amazon.awssdk.services.workdocs.model.InvalidCommentOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidPasswordException;
import software.amazon.awssdk.services.workdocs.model.LimitExceededException;
import software.amazon.awssdk.services.workdocs.model.ProhibitedStateException;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.RequestedEntityTooLargeException;
import software.amazon.awssdk.services.workdocs.model.ResourceAlreadyCheckedOutException;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitWillExceedException;
import software.amazon.awssdk.services.workdocs.model.TooManyLabelsException;
import software.amazon.awssdk.services.workdocs.model.TooManySubscriptionsException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedResourceAccessException;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable;
import software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable;
import software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable;

/**
 * Service client for accessing Amazon WorkDocs. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amazon WorkDocs API is designed for the following use cases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * File Migration: File migration applications are supported for users who want to migrate their files from an
 * on-premises or off-premises file system or service. Users can insert files into a user directory structure, as well
 * as allow for basic metadata changes, such as modifications to the permissions of files.
 * </p>
 * </li>
 * <li>
 * <p>
 * Security: Support security applications are supported for users who have additional security needs, such as antivirus
 * or data loss prevention. The API actions, along with CloudTrail, allow these applications to detect when changes
 * occur in Amazon WorkDocs. Then, the application can take the necessary actions and replace the target file. If the
 * target file violates the policy, the application can also choose to email the user.
 * </p>
 * </li>
 * <li>
 * <p>
 * eDiscovery/Analytics: General administrative applications are supported, such as eDiscovery and analytics. These
 * applications can choose to mimic or record the actions in an Amazon WorkDocs site, along with CloudTrail, to
 * replicate data for eDiscovery, backup, or analytical applications.
 * </p>
 * </li>
 * </ul>
 * <p>
 * All Amazon WorkDocs API actions are Amazon authenticated and certificate-signed. They not only require the use of the
 * Amazon Web Services SDK, but also allow for the exclusive use of IAM users and roles to help facilitate access,
 * trust, and permission policies. By creating a role and allowing an IAM user to access the Amazon WorkDocs site, the
 * IAM user gains full administrative visibility into the entire Amazon WorkDocs site (or as set in the IAM policy).
 * This includes, but is not limited to, the ability to modify file permissions and upload any file to any user. This
 * allows developers to perform the three use cases above, as well as give users the ability to grant access on a
 * selective basis using the IAM model.
 * </p>
 * <note>
 * <p>
 * The pricing for Amazon WorkDocs APIs varies depending on the API call type for these actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>READ (Get*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WRITE (Activate*, Add*, Create*, Deactivate*, Initiate*, Update*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LIST (Describe*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELETE*, CANCEL</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about Amazon WorkDocs API pricing, see <a href="https://aws.amazon.com/workdocs/pricing/">Amazon
 * WorkDocs Pricing</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkDocsClient extends AwsClient {
    String SERVICE_NAME = "workdocs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workdocs";

    /**
     * <p>
     * Aborts the upload of the specified document version that was previously initiated by
     * <a>InitiateDocumentVersionUpload</a>. The client should make this call only when it no longer intends to upload
     * the document version, or fails to do so.
     * </p>
     *
     * @param abortDocumentVersionUploadRequest
     * @return Result of the AbortDocumentVersionUpload operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.AbortDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default AbortDocumentVersionUploadResponse abortDocumentVersionUpload(
            AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) throws EntityNotExistsException,
            ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Aborts the upload of the specified document version that was previously initiated by
     * <a>InitiateDocumentVersionUpload</a>. The client should make this call only when it no longer intends to upload
     * the document version, or fails to do so.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortDocumentVersionUploadRequest.Builder} avoiding
     * the need to create one manually via {@link AbortDocumentVersionUploadRequest#builder()}
     * </p>
     *
     * @param abortDocumentVersionUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest.Builder} to create
     *        a request.
     * @return Result of the AbortDocumentVersionUpload operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.AbortDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default AbortDocumentVersionUploadResponse abortDocumentVersionUpload(
            Consumer<AbortDocumentVersionUploadRequest.Builder> abortDocumentVersionUploadRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, WorkDocsException {
        return abortDocumentVersionUpload(AbortDocumentVersionUploadRequest.builder()
                .applyMutation(abortDocumentVersionUploadRequest).build());
    }

    /**
     * <p>
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     * </p>
     *
     * @param activateUserRequest
     * @return Result of the ActivateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.ActivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ActivateUserResponse activateUser(ActivateUserRequest activateUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateUserRequest.Builder} avoiding the need to
     * create one manually via {@link ActivateUserRequest#builder()}
     * </p>
     *
     * @param activateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.ActivateUserRequest.Builder} to create a request.
     * @return Result of the ActivateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.ActivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ActivateUserResponse activateUser(Consumer<ActivateUserRequest.Builder> activateUserRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return activateUser(ActivateUserRequest.builder().applyMutation(activateUserRequest).build());
    }

    /**
     * <p>
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if
     * the principals already have different permissions.
     * </p>
     *
     * @param addResourcePermissionsRequest
     * @return Result of the AddResourcePermissions operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.AddResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default AddResourcePermissionsResponse addResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if
     * the principals already have different permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddResourcePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link AddResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param addResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the AddResourcePermissions operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.AddResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default AddResourcePermissionsResponse addResourcePermissions(
            Consumer<AddResourcePermissionsRequest.Builder> addResourcePermissionsRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException,
            ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        return addResourcePermissions(AddResourcePermissionsRequest.builder().applyMutation(addResourcePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Adds a new comment to the specified document version.
     * </p>
     *
     * @param createCommentRequest
     * @return Result of the CreateComment operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DocumentLockedForCommentsException
     *         This exception is thrown when the document is locked for comments and user tries to create or delete a
     *         comment on that document.
     * @throws InvalidCommentOperationException
     *         The requested operation is not allowed on the specified comment object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCommentResponse createComment(CreateCommentRequest createCommentRequest) throws EntityNotExistsException,
            ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException,
            InvalidCommentOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new comment to the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCommentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCommentRequest#builder()}
     * </p>
     *
     * @param createCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateCommentRequest.Builder} to create a request.
     * @return Result of the CreateComment operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DocumentLockedForCommentsException
     *         This exception is thrown when the document is locked for comments and user tries to create or delete a
     *         comment on that document.
     * @throws InvalidCommentOperationException
     *         The requested operation is not allowed on the specified comment object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCommentResponse createComment(Consumer<CreateCommentRequest.Builder> createCommentRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException,
            DocumentLockedForCommentsException, InvalidCommentOperationException, AwsServiceException, SdkClientException,
            WorkDocsException {
        return createComment(CreateCommentRequest.builder().applyMutation(createCommentRequest).build());
    }

    /**
     * <p>
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     * </p>
     *
     * @param createCustomMetadataRequest
     * @return Result of the CreateCustomMetadata operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws CustomMetadataLimitExceededException
     *         The limit has been reached on the number of custom properties for the specified resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCustomMetadataResponse createCustomMetadata(CreateCustomMetadataRequest createCustomMetadataRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            ProhibitedStateException, CustomMetadataLimitExceededException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomMetadataRequest#builder()}
     * </p>
     *
     * @param createCustomMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCustomMetadata operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws CustomMetadataLimitExceededException
     *         The limit has been reached on the number of custom properties for the specified resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCustomMetadataResponse createCustomMetadata(
            Consumer<CreateCustomMetadataRequest.Builder> createCustomMetadataRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException,
            CustomMetadataLimitExceededException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return createCustomMetadata(CreateCustomMetadataRequest.builder().applyMutation(createCustomMetadataRequest).build());
    }

    /**
     * <p>
     * Creates a folder with the specified name and parent folder.
     * </p>
     *
     * @param createFolderRequest
     * @return Result of the CreateFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) throws EntityNotExistsException,
            EntityAlreadyExistsException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, LimitExceededException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a folder with the specified name and parent folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFolderRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFolderRequest#builder()}
     * </p>
     *
     * @param createFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateFolderRequest.Builder} to create a request.
     * @return Result of the CreateFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFolderResponse createFolder(Consumer<CreateFolderRequest.Builder> createFolderRequest)
            throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException,
            ConflictingOperationException, ConcurrentModificationException, LimitExceededException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return createFolder(CreateFolderRequest.builder().applyMutation(createFolderRequest).build());
    }

    /**
     * <p>
     * Adds the specified list of labels to the given resource (a document or folder)
     * </p>
     *
     * @param createLabelsRequest
     * @return Result of the CreateLabels operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws TooManyLabelsException
     *         The limit has been reached on the number of labels for the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLabelsResponse createLabels(CreateLabelsRequest createLabelsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, TooManyLabelsException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified list of labels to the given resource (a document or folder)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLabelsRequest#builder()}
     * </p>
     *
     * @param createLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest.Builder} to create a request.
     * @return Result of the CreateLabels operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws TooManyLabelsException
     *         The limit has been reached on the number of labels for the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLabelsResponse createLabels(Consumer<CreateLabelsRequest.Builder> createLabelsRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, TooManyLabelsException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return createLabels(CreateLabelsRequest.builder().applyMutation(createLabelsRequest).build());
    }

    /**
     * <p>
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must
     * confirm the subscription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html">Setting up
     * notifications for an IAM user or role</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param createNotificationSubscriptionRequest
     * @return Result of the CreateNotificationSubscription operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws TooManySubscriptionsException
     *         You've reached the limit on the number of subscriptions for the WorkDocs instance.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationSubscriptionResponse createNotificationSubscription(
            CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest)
            throws UnauthorizedResourceAccessException, TooManySubscriptionsException, ServiceUnavailableException,
            InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must
     * confirm the subscription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html">Setting up
     * notifications for an IAM user or role</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationSubscriptionRequest#builder()}
     * </p>
     *
     * @param createNotificationSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateNotificationSubscription operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws TooManySubscriptionsException
     *         You've reached the limit on the number of subscriptions for the WorkDocs instance.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationSubscriptionResponse createNotificationSubscription(
            Consumer<CreateNotificationSubscriptionRequest.Builder> createNotificationSubscriptionRequest)
            throws UnauthorizedResourceAccessException, TooManySubscriptionsException, ServiceUnavailableException,
            InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        return createNotificationSubscription(CreateNotificationSubscriptionRequest.builder()
                .applyMutation(createNotificationSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New
     * users can access Amazon WorkDocs.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws EntityAlreadyExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New
     * users can access Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws EntityAlreadyExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     * </p>
     *
     * @param deactivateUserRequest
     * @return Result of the DeactivateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeactivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeactivateUserResponse deactivateUser(DeactivateUserRequest deactivateUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeactivateUserRequest#builder()}
     * </p>
     *
     * @param deactivateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest.Builder} to create a request.
     * @return Result of the DeactivateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeactivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeactivateUserResponse deactivateUser(Consumer<DeactivateUserRequest.Builder> deactivateUserRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return deactivateUser(DeactivateUserRequest.builder().applyMutation(deactivateUserRequest).build());
    }

    /**
     * <p>
     * Deletes the specified comment from the document version.
     * </p>
     *
     * @param deleteCommentRequest
     * @return Result of the DeleteComment operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DocumentLockedForCommentsException
     *         This exception is thrown when the document is locked for comments and user tries to create or delete a
     *         comment on that document.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCommentResponse deleteComment(DeleteCommentRequest deleteCommentRequest) throws EntityNotExistsException,
            ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified comment from the document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCommentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCommentRequest#builder()}
     * </p>
     *
     * @param deleteCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest.Builder} to create a request.
     * @return Result of the DeleteComment operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DocumentLockedForCommentsException
     *         This exception is thrown when the document is locked for comments and user tries to create or delete a
     *         comment on that document.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCommentResponse deleteComment(Consumer<DeleteCommentRequest.Builder> deleteCommentRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException,
            DocumentLockedForCommentsException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteComment(DeleteCommentRequest.builder().applyMutation(deleteCommentRequest).build());
    }

    /**
     * <p>
     * Deletes custom metadata from the specified resource.
     * </p>
     *
     * @param deleteCustomMetadataRequest
     * @return Result of the DeleteCustomMetadata operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCustomMetadataResponse deleteCustomMetadata(DeleteCustomMetadataRequest deleteCustomMetadataRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            ProhibitedStateException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes custom metadata from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomMetadataRequest#builder()}
     * </p>
     *
     * @param deleteCustomMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCustomMetadata operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCustomMetadataResponse deleteCustomMetadata(
            Consumer<DeleteCustomMetadataRequest.Builder> deleteCustomMetadataRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteCustomMetadata(DeleteCustomMetadataRequest.builder().applyMutation(deleteCustomMetadataRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified document and its associated metadata.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest) throws EntityNotExistsException,
            LimitExceededException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified document and its associated metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDocumentRequest#builder()}
     * </p>
     *
     * @param deleteDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest.Builder} to create a request.
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDocumentResponse deleteDocument(Consumer<DeleteDocumentRequest.Builder> deleteDocumentRequest)
            throws EntityNotExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteDocument(DeleteDocumentRequest.builder().applyMutation(deleteDocumentRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a document.
     * </p>
     *
     * @param deleteDocumentVersionRequest
     * @return Result of the DeleteDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentVersionResponse deleteDocumentVersion(DeleteDocumentVersionRequest deleteDocumentVersionRequest)
            throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, UnauthorizedResourceAccessException, FailedDependencyException,
            InvalidOperationException, UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDocumentVersionRequest#builder()}
     * </p>
     *
     * @param deleteDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentVersionResponse deleteDocumentVersion(
            Consumer<DeleteDocumentVersionRequest.Builder> deleteDocumentVersionRequest) throws EntityNotExistsException,
            ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException,
            UnauthorizedResourceAccessException, FailedDependencyException, InvalidOperationException,
            UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteDocumentVersion(DeleteDocumentVersionRequest.builder().applyMutation(deleteDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified folder and its contents.
     * </p>
     *
     * @param deleteFolderRequest
     * @return Result of the DeleteFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFolderResponse deleteFolder(DeleteFolderRequest deleteFolderRequest) throws EntityNotExistsException,
            LimitExceededException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified folder and its contents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFolderRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFolderRequest#builder()}
     * </p>
     *
     * @param deleteFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest.Builder} to create a request.
     * @return Result of the DeleteFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFolderResponse deleteFolder(Consumer<DeleteFolderRequest.Builder> deleteFolderRequest)
            throws EntityNotExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteFolder(DeleteFolderRequest.builder().applyMutation(deleteFolderRequest).build());
    }

    /**
     * <p>
     * Deletes the contents of the specified folder.
     * </p>
     *
     * @param deleteFolderContentsRequest
     * @return Result of the DeleteFolderContents operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFolderContentsResponse deleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest)
            throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the contents of the specified folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFolderContentsRequest#builder()}
     * </p>
     *
     * @param deleteFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFolderContents operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFolderContentsResponse deleteFolderContents(
            Consumer<DeleteFolderContentsRequest.Builder> deleteFolderContentsRequest) throws EntityNotExistsException,
            ProhibitedStateException, ConflictingOperationException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return deleteFolderContents(DeleteFolderContentsRequest.builder().applyMutation(deleteFolderContentsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified list of labels from a resource.
     * </p>
     *
     * @param deleteLabelsRequest
     * @return Result of the DeleteLabels operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLabelsResponse deleteLabels(DeleteLabelsRequest deleteLabelsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified list of labels from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelsRequest#builder()}
     * </p>
     *
     * @param deleteLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest.Builder} to create a request.
     * @return Result of the DeleteLabels operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLabelsResponse deleteLabels(Consumer<DeleteLabelsRequest.Builder> deleteLabelsRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return deleteLabels(DeleteLabelsRequest.builder().applyMutation(deleteLabelsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified subscription from the specified organization.
     * </p>
     *
     * @param deleteNotificationSubscriptionRequest
     * @return Result of the DeleteNotificationSubscription operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationSubscriptionResponse deleteNotificationSubscription(
            DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified subscription from the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteNotificationSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteNotificationSubscription operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationSubscriptionResponse deleteNotificationSubscription(
            Consumer<DeleteNotificationSubscriptionRequest.Builder> deleteNotificationSubscriptionRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteNotificationSubscription(DeleteNotificationSubscriptionRequest.builder()
                .applyMutation(deleteNotificationSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     * </p>
     * <important>
     * <p>
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention
     * policies do NOT apply to this type of deletion.
     * </p>
     * </important>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     * </p>
     * <important>
     * <p>
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention
     * policies do NOT apply to this type of deletion.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     *
     * @param describeActivitiesRequest
     * @return Result of the DescribeActivities operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesResponse describeActivities(DescribeActivitiesRequest describeActivitiesRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivitiesRequest#builder()}
     * </p>
     *
     * @param describeActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeActivities operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesResponse describeActivities(Consumer<DescribeActivitiesRequest.Builder> describeActivitiesRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeActivities(DescribeActivitiesRequest.builder().applyMutation(describeActivitiesRequest).build());
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client.describeActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client
     *             .describeActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client.describeActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActivitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesIterable describeActivitiesPaginator(DescribeActivitiesRequest describeActivitiesRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeActivitiesIterable(this, describeActivitiesRequest);
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client.describeActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client
     *             .describeActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesIterable responses = client.describeActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivitiesRequest#builder()}
     * </p>
     *
     * @param describeActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesIterable describeActivitiesPaginator(
            Consumer<DescribeActivitiesRequest.Builder> describeActivitiesRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeActivitiesPaginator(DescribeActivitiesRequest.builder().applyMutation(describeActivitiesRequest).build());
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     *
     * @param describeCommentsRequest
     * @return Result of the DescribeComments operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsResponse describeComments(DescribeCommentsRequest describeCommentsRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommentsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCommentsRequest#builder()}
     * </p>
     *
     * @param describeCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeComments operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsResponse describeComments(Consumer<DescribeCommentsRequest.Builder> describeCommentsRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return describeComments(DescribeCommentsRequest.builder().applyMutation(describeCommentsRequest).build());
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client.describeCommentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client
     *             .describeCommentsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client.describeCommentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation.</b>
     * </p>
     *
     * @param describeCommentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsIterable describeCommentsPaginator(DescribeCommentsRequest describeCommentsRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return new DescribeCommentsIterable(this, describeCommentsRequest);
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client.describeCommentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client
     *             .describeCommentsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsIterable responses = client.describeCommentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommentsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCommentsRequest#builder()}
     * </p>
     *
     * @param describeCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsIterable describeCommentsPaginator(Consumer<DescribeCommentsRequest.Builder> describeCommentsRequest)
            throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return describeCommentsPaginator(DescribeCommentsRequest.builder().applyMutation(describeCommentsRequest).build());
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     *
     * @param describeDocumentVersionsRequest
     * @return Result of the DescribeDocumentVersions operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsResponse describeDocumentVersions(
            DescribeDocumentVersionsRequest describeDocumentVersionsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param describeDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDocumentVersions operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsResponse describeDocumentVersions(
            Consumer<DescribeDocumentVersionsRequest.Builder> describeDocumentVersionsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeDocumentVersions(DescribeDocumentVersionsRequest.builder().applyMutation(describeDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client.describeDocumentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client
     *             .describeDocumentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client.describeDocumentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDocumentVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsIterable describeDocumentVersionsPaginator(
            DescribeDocumentVersionsRequest describeDocumentVersionsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeDocumentVersionsIterable(this, describeDocumentVersionsRequest);
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client.describeDocumentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client
     *             .describeDocumentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsIterable responses = client.describeDocumentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param describeDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsIterable describeDocumentVersionsPaginator(
            Consumer<DescribeDocumentVersionsRequest.Builder> describeDocumentVersionsRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeDocumentVersionsPaginator(DescribeDocumentVersionsRequest.builder()
                .applyMutation(describeDocumentVersionsRequest).build());
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     *
     * @param describeFolderContentsRequest
     * @return Result of the DescribeFolderContents operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsResponse describeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest)
            throws EntityNotExistsException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFolderContentsRequest#builder()}
     * </p>
     *
     * @param describeFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFolderContents operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsResponse describeFolderContents(
            Consumer<DescribeFolderContentsRequest.Builder> describeFolderContentsRequest) throws EntityNotExistsException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeFolderContents(DescribeFolderContentsRequest.builder().applyMutation(describeFolderContentsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client.describeFolderContentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client
     *             .describeFolderContentsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client.describeFolderContentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFolderContentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsIterable describeFolderContentsPaginator(
            DescribeFolderContentsRequest describeFolderContentsRequest) throws EntityNotExistsException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeFolderContentsIterable(this, describeFolderContentsRequest);
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client.describeFolderContentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client
     *             .describeFolderContentsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsIterable responses = client.describeFolderContentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFolderContentsRequest#builder()}
     * </p>
     *
     * @param describeFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsIterable describeFolderContentsPaginator(
            Consumer<DescribeFolderContentsRequest.Builder> describeFolderContentsRequest) throws EntityNotExistsException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeFolderContentsPaginator(DescribeFolderContentsRequest.builder()
                .applyMutation(describeFolderContentsRequest).build());
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     *
     * @param describeGroupsRequest
     * @return Result of the DescribeGroups operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsResponse describeGroups(DescribeGroupsRequest describeGroupsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupsRequest#builder()}
     * </p>
     *
     * @param describeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest.Builder} to create a request.
     * @return Result of the DescribeGroups operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsResponse describeGroups(Consumer<DescribeGroupsRequest.Builder> describeGroupsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeGroups(DescribeGroupsRequest.builder().applyMutation(describeGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client.describeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client
     *             .describeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client.describeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describeGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsIterable describeGroupsPaginator(DescribeGroupsRequest describeGroupsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeGroupsIterable(this, describeGroupsRequest);
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client.describeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client
     *             .describeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsIterable responses = client.describeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupsRequest#builder()}
     * </p>
     *
     * @param describeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsIterable describeGroupsPaginator(Consumer<DescribeGroupsRequest.Builder> describeGroupsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeGroupsPaginator(DescribeGroupsRequest.builder().applyMutation(describeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     * @return Result of the DescribeNotificationSubscriptions operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsResponse describeNotificationSubscriptions(
            DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationSubscriptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeNotificationSubscriptions operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsResponse describeNotificationSubscriptions(
            Consumer<DescribeNotificationSubscriptionsRequest.Builder> describeNotificationSubscriptionsRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest.builder()
                .applyMutation(describeNotificationSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client.describeNotificationSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client
     *             .describeNotificationSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client.describeNotificationSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsIterable describeNotificationSubscriptionsPaginator(
            DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeNotificationSubscriptionsIterable(this, describeNotificationSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client.describeNotificationSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client
     *             .describeNotificationSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsIterable responses = client.describeNotificationSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationSubscriptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsIterable describeNotificationSubscriptionsPaginator(
            Consumer<DescribeNotificationSubscriptionsRequest.Builder> describeNotificationSubscriptionsRequest)
            throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeNotificationSubscriptionsPaginator(DescribeNotificationSubscriptionsRequest.builder()
                .applyMutation(describeNotificationSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     *
     * @param describeResourcePermissionsRequest
     * @return Result of the DescribeResourcePermissions operation returned by the service.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsResponse describeResourcePermissions(
            DescribeResourcePermissionsRequest describeResourcePermissionsRequest) throws InvalidArgumentException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeResourcePermissions operation returned by the service.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsResponse describeResourcePermissions(
            Consumer<DescribeResourcePermissionsRequest.Builder> describeResourcePermissionsRequest)
            throws InvalidArgumentException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeResourcePermissions(DescribeResourcePermissionsRequest.builder()
                .applyMutation(describeResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client.describeResourcePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client
     *             .describeResourcePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client.describeResourcePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeResourcePermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsIterable describeResourcePermissionsPaginator(
            DescribeResourcePermissionsRequest describeResourcePermissionsRequest) throws InvalidArgumentException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeResourcePermissionsIterable(this, describeResourcePermissionsRequest);
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client.describeResourcePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client
     *             .describeResourcePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsIterable responses = client.describeResourcePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsIterable describeResourcePermissionsPaginator(
            Consumer<DescribeResourcePermissionsRequest.Builder> describeResourcePermissionsRequest)
            throws InvalidArgumentException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeResourcePermissionsPaginator(DescribeResourcePermissionsRequest.builder()
                .applyMutation(describeResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param describeRootFoldersRequest
     * @return Result of the DescribeRootFolders operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersResponse describeRootFolders(DescribeRootFoldersRequest describeRootFoldersRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRootFoldersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRootFoldersRequest#builder()}
     * </p>
     *
     * @param describeRootFoldersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRootFolders operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersResponse describeRootFolders(
            Consumer<DescribeRootFoldersRequest.Builder> describeRootFoldersRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeRootFolders(DescribeRootFoldersRequest.builder().applyMutation(describeRootFoldersRequest).build());
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client.describeRootFoldersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client
     *             .describeRootFoldersPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client.describeRootFoldersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRootFoldersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersIterable describeRootFoldersPaginator(DescribeRootFoldersRequest describeRootFoldersRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeRootFoldersIterable(this, describeRootFoldersRequest);
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client.describeRootFoldersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client
     *             .describeRootFoldersPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersIterable responses = client.describeRootFoldersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRootFoldersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRootFoldersRequest#builder()}
     * </p>
     *
     * @param describeRootFoldersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersIterable describeRootFoldersPaginator(
            Consumer<DescribeRootFoldersRequest.Builder> describeRootFoldersRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return describeRootFoldersPaginator(DescribeRootFoldersRequest.builder().applyMutation(describeRootFoldersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws RequestedEntityTooLargeException
     *         The response is too large to return. The request must include a filter to reduce the size of the
     *         response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, InvalidArgumentException, RequestedEntityTooLargeException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest.Builder} to create a request.
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws RequestedEntityTooLargeException
     *         The response is too large to return. The request must include a filter to reduce the size of the
     *         response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, InvalidArgumentException, RequestedEntityTooLargeException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)} operation.</b>
     * </p>
     *
     * @param describeUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws RequestedEntityTooLargeException
     *         The response is too large to return. The request must include a filter to reduce the size of the
     *         response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersIterable describeUsersPaginator(DescribeUsersRequest describeUsersRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, InvalidArgumentException, RequestedEntityTooLargeException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return new DescribeUsersIterable(this, describeUsersRequest);
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws RequestedEntityTooLargeException
     *         The response is too large to return. The request must include a filter to reduce the size of the
     *         response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersIterable describeUsersPaginator(Consumer<DescribeUsersRequest.Builder> describeUsersRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, InvalidArgumentException, RequestedEntityTooLargeException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return describeUsersPaginator(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action
     * for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param getCurrentUserRequest
     * @return Result of the GetCurrentUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetCurrentUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCurrentUserResponse getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action
     * for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserRequest.Builder} avoiding the need to
     * create one manually via {@link GetCurrentUserRequest#builder()}
     * </p>
     *
     * @param getCurrentUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest.Builder} to create a request.
     * @return Result of the GetCurrentUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetCurrentUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCurrentUserResponse getCurrentUser(Consumer<GetCurrentUserRequest.Builder> getCurrentUserRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return getCurrentUser(GetCurrentUserRequest.builder().applyMutation(getCurrentUserRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a document.
     * </p>
     *
     * @param getDocumentRequest
     * @return Result of the GetDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, InvalidPasswordException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDocumentRequest#builder()}
     * </p>
     *
     * @param getDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentRequest.Builder} to create a request.
     * @return Result of the GetDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentResponse getDocument(Consumer<GetDocumentRequest.Builder> getDocumentRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return getDocument(GetDocumentRequest.builder().applyMutation(getDocumentRequest).build());
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * names of the parent folders.
     * </p>
     *
     * @param getDocumentPathRequest
     * @return Result of the GetDocumentPath operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocumentPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentPathResponse getDocumentPath(GetDocumentPathRequest getDocumentPathRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * names of the parent folders.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentPathRequest.Builder} avoiding the need
     * to create one manually via {@link GetDocumentPathRequest#builder()}
     * </p>
     *
     * @param getDocumentPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest.Builder} to create a request.
     * @return Result of the GetDocumentPath operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocumentPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentPathResponse getDocumentPath(Consumer<GetDocumentPathRequest.Builder> getDocumentPathRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return getDocumentPath(GetDocumentPathRequest.builder().applyMutation(getDocumentPathRequest).build());
    }

    /**
     * <p>
     * Retrieves version metadata for the specified document.
     * </p>
     *
     * @param getDocumentVersionRequest
     * @return Result of the GetDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDocumentVersionResponse getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves version metadata for the specified document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentVersionRequest#builder()}
     * </p>
     *
     * @param getDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDocumentVersionResponse getDocumentVersion(Consumer<GetDocumentVersionRequest.Builder> getDocumentVersionRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException,
            AwsServiceException, SdkClientException, WorkDocsException {
        return getDocumentVersion(GetDocumentVersionRequest.builder().applyMutation(getDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata of the specified folder.
     * </p>
     *
     * @param getFolderRequest
     * @return Result of the GetFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFolderResponse getFolder(GetFolderRequest getFolderRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata of the specified folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFolderRequest.Builder} avoiding the need to
     * create one manually via {@link GetFolderRequest#builder()}
     * </p>
     *
     * @param getFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetFolderRequest.Builder} to create a request.
     * @return Result of the GetFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFolderResponse getFolder(Consumer<GetFolderRequest.Builder> getFolderRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return getFolder(GetFolderRequest.builder().applyMutation(getFolderRequest).build());
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * parent folder names.
     * </p>
     *
     * @param getFolderPathRequest
     * @return Result of the GetFolderPath operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetFolderPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFolderPathResponse getFolderPath(GetFolderPathRequest getFolderPathRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * parent folder names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFolderPathRequest.Builder} avoiding the need to
     * create one manually via {@link GetFolderPathRequest#builder()}
     * </p>
     *
     * @param getFolderPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest.Builder} to create a request.
     * @return Result of the GetFolderPath operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetFolderPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFolderPathResponse getFolderPath(Consumer<GetFolderPathRequest.Builder> getFolderPathRequest)
            throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return getFolderPath(GetFolderPathRequest.builder().applyMutation(getFolderPathRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of resources, including folders and documents. The only <code>CollectionType</code>
     * supported is <code>SHARED_WITH_ME</code>.
     * </p>
     *
     * @param getResourcesRequest
     * @return Result of the GetResources operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest)
            throws UnauthorizedResourceAccessException, UnauthorizedOperationException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of resources, including folders and documents. The only <code>CollectionType</code>
     * supported is <code>SHARED_WITH_ME</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetResourcesRequest.Builder} to create a request.
     * @return Result of the GetResources operation returned by the service.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.GetResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcesResponse getResources(Consumer<GetResourcesRequest.Builder> getResourcesRequest)
            throws UnauthorizedResourceAccessException, UnauthorizedOperationException, InvalidArgumentException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return getResources(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * Creates a new document object and version object.
     * </p>
     * <p>
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when
     * creating a new version of an existing document. This is the first step to upload a document. Next, upload the
     * document to the URL returned from the call, and then call <a>UpdateDocumentVersion</a>.
     * </p>
     * <p>
     * To cancel the document upload, call <a>AbortDocumentVersionUpload</a>.
     * </p>
     *
     * @param initiateDocumentVersionUploadRequest
     * @return Result of the InitiateDocumentVersionUpload operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws StorageLimitExceededException
     *         The storage limit has been exceeded.
     * @throws StorageLimitWillExceedException
     *         The storage limit will be exceeded.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DraftUploadOutOfSyncException
     *         This exception is thrown when a valid checkout ID is not presented on document version upload calls for a
     *         document that has been checked out from Web client.
     * @throws ResourceAlreadyCheckedOutException
     *         The resource is already checked out.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.InitiateDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default InitiateDocumentVersionUploadResponse initiateDocumentVersionUpload(
            InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) throws EntityNotExistsException,
            EntityAlreadyExistsException, StorageLimitExceededException, StorageLimitWillExceedException, LimitExceededException,
            ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, DraftUploadOutOfSyncException,
            ResourceAlreadyCheckedOutException, InvalidPasswordException, InvalidArgumentException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document object and version object.
     * </p>
     * <p>
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when
     * creating a new version of an existing document. This is the first step to upload a document. Next, upload the
     * document to the URL returned from the call, and then call <a>UpdateDocumentVersion</a>.
     * </p>
     * <p>
     * To cancel the document upload, call <a>AbortDocumentVersionUpload</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateDocumentVersionUploadRequest.Builder}
     * avoiding the need to create one manually via {@link InitiateDocumentVersionUploadRequest#builder()}
     * </p>
     *
     * @param initiateDocumentVersionUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest.Builder} to
     *        create a request.
     * @return Result of the InitiateDocumentVersionUpload operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws StorageLimitExceededException
     *         The storage limit has been exceeded.
     * @throws StorageLimitWillExceedException
     *         The storage limit will be exceeded.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DraftUploadOutOfSyncException
     *         This exception is thrown when a valid checkout ID is not presented on document version upload calls for a
     *         document that has been checked out from Web client.
     * @throws ResourceAlreadyCheckedOutException
     *         The resource is already checked out.
     * @throws InvalidPasswordException
     *         The password is invalid.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.InitiateDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default InitiateDocumentVersionUploadResponse initiateDocumentVersionUpload(
            Consumer<InitiateDocumentVersionUploadRequest.Builder> initiateDocumentVersionUploadRequest)
            throws EntityNotExistsException, EntityAlreadyExistsException, StorageLimitExceededException,
            StorageLimitWillExceedException, LimitExceededException, ProhibitedStateException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException,
            DraftUploadOutOfSyncException, ResourceAlreadyCheckedOutException, InvalidPasswordException,
            InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        return initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest.builder()
                .applyMutation(initiateDocumentVersionUploadRequest).build());
    }

    /**
     * <p>
     * Removes all the permissions from the specified resource.
     * </p>
     *
     * @param removeAllResourcePermissionsRequest
     * @return Result of the RemoveAllResourcePermissions operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RemoveAllResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAllResourcePermissionsResponse removeAllResourcePermissions(
            RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all the permissions from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAllResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveAllResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param removeAllResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return Result of the RemoveAllResourcePermissions operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RemoveAllResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAllResourcePermissionsResponse removeAllResourcePermissions(
            Consumer<RemoveAllResourcePermissionsRequest.Builder> removeAllResourcePermissionsRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return removeAllResourcePermissions(RemoveAllResourcePermissionsRequest.builder()
                .applyMutation(removeAllResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Removes the permission for the specified principal from the specified resource.
     * </p>
     *
     * @param removeResourcePermissionRequest
     * @return Result of the RemoveResourcePermission operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RemoveResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveResourcePermissionResponse removeResourcePermission(
            RemoveResourcePermissionRequest removeResourcePermissionRequest) throws UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the permission for the specified principal from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveResourcePermissionRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveResourcePermissionRequest#builder()}
     * </p>
     *
     * @param removeResourcePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveResourcePermission operation returned by the service.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RemoveResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveResourcePermissionResponse removeResourcePermission(
            Consumer<RemoveResourcePermissionRequest.Builder> removeResourcePermissionRequest)
            throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return removeResourcePermission(RemoveResourcePermissionRequest.builder().applyMutation(removeResourcePermissionRequest)
                .build());
    }

    /**
     * <p>
     * Recovers a deleted version of an Amazon WorkDocs document.
     * </p>
     *
     * @param restoreDocumentVersionsRequest
     * @return Result of the RestoreDocumentVersions operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RestoreDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RestoreDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDocumentVersionsResponse restoreDocumentVersions(RestoreDocumentVersionsRequest restoreDocumentVersionsRequest)
            throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, UnauthorizedResourceAccessException, FailedDependencyException,
            InvalidOperationException, UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recovers a deleted version of an Amazon WorkDocs document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param restoreDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the RestoreDocumentVersions operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.RestoreDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RestoreDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDocumentVersionsResponse restoreDocumentVersions(
            Consumer<RestoreDocumentVersionsRequest.Builder> restoreDocumentVersionsRequest) throws EntityNotExistsException,
            ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException,
            UnauthorizedResourceAccessException, FailedDependencyException, InvalidOperationException,
            UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        return restoreDocumentVersions(RestoreDocumentVersionsRequest.builder().applyMutation(restoreDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     *
     * @param searchResourcesRequest
     * @return Result of the SearchResources operation returned by the service.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesResponse searchResources(SearchResourcesRequest searchResourcesRequest)
            throws InvalidArgumentException, UnauthorizedResourceAccessException, UnauthorizedOperationException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest.Builder} to create a request.
     * @return Result of the SearchResources operation returned by the service.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesResponse searchResources(Consumer<SearchResourcesRequest.Builder> searchResourcesRequest)
            throws InvalidArgumentException, UnauthorizedResourceAccessException, UnauthorizedOperationException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return searchResources(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client.searchResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client
     *             .searchResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client.searchResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation.</b>
     * </p>
     *
     * @param searchResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesIterable searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest)
            throws InvalidArgumentException, UnauthorizedResourceAccessException, UnauthorizedOperationException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return new SearchResourcesIterable(this, searchResourcesRequest);
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client.searchResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client
     *             .searchResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesIterable responses = client.searchResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesIterable searchResourcesPaginator(Consumer<SearchResourcesRequest.Builder> searchResourcesRequest)
            throws InvalidArgumentException, UnauthorizedResourceAccessException, UnauthorizedOperationException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return searchResourcesPaginator(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of a document. The user must have access to both the document and its parent
     * folder, if applicable.
     * </p>
     *
     * @param updateDocumentRequest
     * @return Result of the UpdateDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDocumentResponse updateDocument(UpdateDocumentRequest updateDocumentRequest) throws EntityNotExistsException,
            EntityAlreadyExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of a document. The user must have access to both the document and its parent
     * folder, if applicable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDocumentRequest#builder()}
     * </p>
     *
     * @param updateDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest.Builder} to create a request.
     * @return Result of the UpdateDocument operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDocumentResponse updateDocument(Consumer<UpdateDocumentRequest.Builder> updateDocumentRequest)
            throws EntityNotExistsException, EntityAlreadyExistsException, LimitExceededException, ProhibitedStateException,
            ConflictingOperationException, ConcurrentModificationException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return updateDocument(UpdateDocumentRequest.builder().applyMutation(updateDocumentRequest).build());
    }

    /**
     * <p>
     * Changes the status of the document version to ACTIVE.
     * </p>
     * <p>
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the
     * client uploads the document to an S3-presigned URL returned by <a>InitiateDocumentVersionUpload</a>.
     * </p>
     *
     * @param updateDocumentVersionRequest
     * @return Result of the UpdateDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDocumentVersionResponse updateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest)
            throws EntityNotExistsException, ProhibitedStateException, ConcurrentModificationException,
            InvalidOperationException, UnauthorizedOperationException, UnauthorizedResourceAccessException,
            FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the status of the document version to ACTIVE.
     * </p>
     * <p>
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the
     * client uploads the document to an S3-presigned URL returned by <a>InitiateDocumentVersionUpload</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDocumentVersionRequest#builder()}
     * </p>
     *
     * @param updateDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDocumentVersion operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws InvalidOperationException
     *         The operation is invalid.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDocumentVersionResponse updateDocumentVersion(
            Consumer<UpdateDocumentVersionRequest.Builder> updateDocumentVersionRequest) throws EntityNotExistsException,
            ProhibitedStateException, ConcurrentModificationException, InvalidOperationException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        return updateDocumentVersion(UpdateDocumentVersionRequest.builder().applyMutation(updateDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its
     * parent folder, if applicable.
     * </p>
     *
     * @param updateFolderRequest
     * @return Result of the UpdateFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFolderResponse updateFolder(UpdateFolderRequest updateFolderRequest) throws EntityNotExistsException,
            EntityAlreadyExistsException, ProhibitedStateException, ConflictingOperationException,
            ConcurrentModificationException, LimitExceededException, UnauthorizedOperationException,
            UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its
     * parent folder, if applicable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFolderRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFolderRequest#builder()}
     * </p>
     *
     * @param updateFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest.Builder} to create a request.
     * @return Result of the UpdateFolder operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws EntityAlreadyExistsException
     *         The resource already exists.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws ConflictingOperationException
     *         Another operation is in progress on the resource that conflicts with the current operation.
     * @throws ConcurrentModificationException
     *         The resource hierarchy is changing.
     * @throws LimitExceededException
     *         The maximum of 100,000 files and folders under the parent folder has been exceeded.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFolderResponse updateFolder(Consumer<UpdateFolderRequest.Builder> updateFolderRequest)
            throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException,
            ConflictingOperationException, ConcurrentModificationException, LimitExceededException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        return updateFolder(UpdateFolderRequest.builder().applyMutation(updateFolderRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the
     * Amazon WorkDocs site.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws IllegalUserStateException
     *         The user is undergoing transfer of ownership.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DeactivatingLastSystemUserException
     *         The last user in the organization is being deactivated.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, IllegalUserStateException,
            ProhibitedStateException, FailedDependencyException, ServiceUnavailableException,
            DeactivatingLastSystemUserException, InvalidArgumentException, AwsServiceException, SdkClientException,
            WorkDocsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the
     * Amazon WorkDocs site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws EntityNotExistsException
     *         The resource does not exist.
     * @throws UnauthorizedOperationException
     *         The operation is not permitted.
     * @throws UnauthorizedResourceAccessException
     *         The caller does not have access to perform the action on the resource.
     * @throws IllegalUserStateException
     *         The user is undergoing transfer of ownership.
     * @throws ProhibitedStateException
     *         The specified document version is not in the INITIALIZED state.
     * @throws FailedDependencyException
     *         The Directory Service cannot reach an on-premises instance. Or a dependency under the control of the
     *         organization is failing, such as a connected Active Directory.
     * @throws ServiceUnavailableException
     *         One or more of the dependencies is unavailable.
     * @throws DeactivatingLastSystemUserException
     *         The last user in the organization is being deactivated.
     * @throws InvalidArgumentException
     *         The pagination marker or limit fields are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkDocsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkDocsClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws EntityNotExistsException,
            UnauthorizedOperationException, UnauthorizedResourceAccessException, IllegalUserStateException,
            ProhibitedStateException, FailedDependencyException, ServiceUnavailableException,
            DeactivatingLastSystemUserException, InvalidArgumentException, AwsServiceException, SdkClientException,
            WorkDocsException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * Create a {@link WorkDocsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkDocsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkDocsClient}.
     */
    static WorkDocsClientBuilder builder() {
        return new DefaultWorkDocsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default WorkDocsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
