/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.GetResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.GetResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher;
import software.amazon.awssdk.services.workdocs.paginators.SearchResourcesPublisher;

/**
 * Service client for accessing Amazon WorkDocs asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon WorkDocs API is designed for the following use cases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * File Migration: File migration applications are supported for users who want to migrate their files from an
 * on-premises or off-premises file system or service. Users can insert files into a user directory structure, as well
 * as allow for basic metadata changes, such as modifications to the permissions of files.
 * </p>
 * </li>
 * <li>
 * <p>
 * Security: Support security applications are supported for users who have additional security needs, such as antivirus
 * or data loss prevention. The API actions, along with CloudTrail, allow these applications to detect when changes
 * occur in Amazon WorkDocs. Then, the application can take the necessary actions and replace the target file. If the
 * target file violates the policy, the application can also choose to email the user.
 * </p>
 * </li>
 * <li>
 * <p>
 * eDiscovery/Analytics: General administrative applications are supported, such as eDiscovery and analytics. These
 * applications can choose to mimic or record the actions in an Amazon WorkDocs site, along with CloudTrail, to
 * replicate data for eDiscovery, backup, or analytical applications.
 * </p>
 * </li>
 * </ul>
 * <p>
 * All Amazon WorkDocs API actions are Amazon authenticated and certificate-signed. They not only require the use of the
 * Amazon Web Services SDK, but also allow for the exclusive use of IAM users and roles to help facilitate access,
 * trust, and permission policies. By creating a role and allowing an IAM user to access the Amazon WorkDocs site, the
 * IAM user gains full administrative visibility into the entire Amazon WorkDocs site (or as set in the IAM policy).
 * This includes, but is not limited to, the ability to modify file permissions and upload any file to any user. This
 * allows developers to perform the three use cases above, as well as give users the ability to grant access on a
 * selective basis using the IAM model.
 * </p>
 * <note>
 * <p>
 * The pricing for Amazon WorkDocs APIs varies depending on the API call type for these actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>READ (Get*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WRITE (Activate*, Add*, Create*, Deactivate*, Initiate*, Update*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LIST (Describe*)</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELETE*, CANCEL</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about Amazon WorkDocs API pricing, see <a href="https://aws.amazon.com/workdocs/pricing/">Amazon
 * WorkDocs Pricing</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkDocsAsyncClient extends AwsClient {
    String SERVICE_NAME = "workdocs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workdocs";

    /**
     * <p>
     * Aborts the upload of the specified document version that was previously initiated by
     * <a>InitiateDocumentVersionUpload</a>. The client should make this call only when it no longer intends to upload
     * the document version, or fails to do so.
     * </p>
     *
     * @param abortDocumentVersionUploadRequest
     * @return A Java Future containing the result of the AbortDocumentVersionUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.AbortDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortDocumentVersionUploadResponse> abortDocumentVersionUpload(
            AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Aborts the upload of the specified document version that was previously initiated by
     * <a>InitiateDocumentVersionUpload</a>. The client should make this call only when it no longer intends to upload
     * the document version, or fails to do so.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortDocumentVersionUploadRequest.Builder} avoiding
     * the need to create one manually via {@link AbortDocumentVersionUploadRequest#builder()}
     * </p>
     *
     * @param abortDocumentVersionUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AbortDocumentVersionUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.AbortDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortDocumentVersionUploadResponse> abortDocumentVersionUpload(
            Consumer<AbortDocumentVersionUploadRequest.Builder> abortDocumentVersionUploadRequest) {
        return abortDocumentVersionUpload(AbortDocumentVersionUploadRequest.builder()
                .applyMutation(abortDocumentVersionUploadRequest).build());
    }

    /**
     * <p>
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     * </p>
     *
     * @param activateUserRequest
     * @return A Java Future containing the result of the ActivateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.ActivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ActivateUserResponse> activateUser(ActivateUserRequest activateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateUserRequest.Builder} avoiding the need to
     * create one manually via {@link ActivateUserRequest#builder()}
     * </p>
     *
     * @param activateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.ActivateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ActivateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.ActivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ActivateUserResponse> activateUser(Consumer<ActivateUserRequest.Builder> activateUserRequest) {
        return activateUser(ActivateUserRequest.builder().applyMutation(activateUserRequest).build());
    }

    /**
     * <p>
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if
     * the principals already have different permissions.
     * </p>
     *
     * @param addResourcePermissionsRequest
     * @return A Java Future containing the result of the AddResourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.AddResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddResourcePermissionsResponse> addResourcePermissions(
            AddResourcePermissionsRequest addResourcePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if
     * the principals already have different permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddResourcePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link AddResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param addResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddResourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.AddResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddResourcePermissionsResponse> addResourcePermissions(
            Consumer<AddResourcePermissionsRequest.Builder> addResourcePermissionsRequest) {
        return addResourcePermissions(AddResourcePermissionsRequest.builder().applyMutation(addResourcePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Adds a new comment to the specified document version.
     * </p>
     *
     * @param createCommentRequest
     * @return A Java Future containing the result of the CreateComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DocumentLockedForCommentsException This exception is thrown when the document is locked for comments
     *         and user tries to create or delete a comment on that document.</li>
     *         <li>InvalidCommentOperationException The requested operation is not allowed on the specified comment
     *         object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCommentResponse> createComment(CreateCommentRequest createCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new comment to the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCommentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCommentRequest#builder()}
     * </p>
     *
     * @param createCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateCommentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DocumentLockedForCommentsException This exception is thrown when the document is locked for comments
     *         and user tries to create or delete a comment on that document.</li>
     *         <li>InvalidCommentOperationException The requested operation is not allowed on the specified comment
     *         object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCommentResponse> createComment(Consumer<CreateCommentRequest.Builder> createCommentRequest) {
        return createComment(CreateCommentRequest.builder().applyMutation(createCommentRequest).build());
    }

    /**
     * <p>
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     * </p>
     *
     * @param createCustomMetadataRequest
     * @return A Java Future containing the result of the CreateCustomMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>CustomMetadataLimitExceededException The limit has been reached on the number of custom properties
     *         for the specified resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCustomMetadataResponse> createCustomMetadata(
            CreateCustomMetadataRequest createCustomMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomMetadataRequest#builder()}
     * </p>
     *
     * @param createCustomMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>CustomMetadataLimitExceededException The limit has been reached on the number of custom properties
     *         for the specified resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCustomMetadataResponse> createCustomMetadata(
            Consumer<CreateCustomMetadataRequest.Builder> createCustomMetadataRequest) {
        return createCustomMetadata(CreateCustomMetadataRequest.builder().applyMutation(createCustomMetadataRequest).build());
    }

    /**
     * <p>
     * Creates a folder with the specified name and parent folder.
     * </p>
     *
     * @param createFolderRequest
     * @return A Java Future containing the result of the CreateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFolderResponse> createFolder(CreateFolderRequest createFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a folder with the specified name and parent folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFolderRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFolderRequest#builder()}
     * </p>
     *
     * @param createFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateFolderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFolderResponse> createFolder(Consumer<CreateFolderRequest.Builder> createFolderRequest) {
        return createFolder(CreateFolderRequest.builder().applyMutation(createFolderRequest).build());
    }

    /**
     * <p>
     * Adds the specified list of labels to the given resource (a document or folder)
     * </p>
     *
     * @param createLabelsRequest
     * @return A Java Future containing the result of the CreateLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>TooManyLabelsException The limit has been reached on the number of labels for the specified resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLabelsResponse> createLabels(CreateLabelsRequest createLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified list of labels to the given resource (a document or folder)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLabelsRequest#builder()}
     * </p>
     *
     * @param createLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>TooManyLabelsException The limit has been reached on the number of labels for the specified resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLabelsResponse> createLabels(Consumer<CreateLabelsRequest.Builder> createLabelsRequest) {
        return createLabels(CreateLabelsRequest.builder().applyMutation(createLabelsRequest).build());
    }

    /**
     * <p>
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must
     * confirm the subscription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html">Setting up
     * notifications for an IAM user or role</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param createNotificationSubscriptionRequest
     * @return A Java Future containing the result of the CreateNotificationSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>TooManySubscriptionsException You've reached the limit on the number of subscriptions for the
     *         WorkDocs instance.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationSubscriptionResponse> createNotificationSubscription(
            CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must
     * confirm the subscription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html">Setting up
     * notifications for an IAM user or role</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationSubscriptionRequest#builder()}
     * </p>
     *
     * @param createNotificationSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateNotificationSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>TooManySubscriptionsException You've reached the limit on the number of subscriptions for the
     *         WorkDocs instance.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationSubscriptionResponse> createNotificationSubscription(
            Consumer<CreateNotificationSubscriptionRequest.Builder> createNotificationSubscriptionRequest) {
        return createNotificationSubscription(CreateNotificationSubscriptionRequest.builder()
                .applyMutation(createNotificationSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New
     * users can access Amazon WorkDocs.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New
     * users can access Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     * </p>
     *
     * @param deactivateUserRequest
     * @return A Java Future containing the result of the DeactivateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeactivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeactivateUserResponse> deactivateUser(DeactivateUserRequest deactivateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeactivateUserRequest#builder()}
     * </p>
     *
     * @param deactivateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeactivateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeactivateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeactivateUserResponse> deactivateUser(Consumer<DeactivateUserRequest.Builder> deactivateUserRequest) {
        return deactivateUser(DeactivateUserRequest.builder().applyMutation(deactivateUserRequest).build());
    }

    /**
     * <p>
     * Deletes the specified comment from the document version.
     * </p>
     *
     * @param deleteCommentRequest
     * @return A Java Future containing the result of the DeleteComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DocumentLockedForCommentsException This exception is thrown when the document is locked for comments
     *         and user tries to create or delete a comment on that document.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCommentResponse> deleteComment(DeleteCommentRequest deleteCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified comment from the document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCommentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCommentRequest#builder()}
     * </p>
     *
     * @param deleteCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DocumentLockedForCommentsException This exception is thrown when the document is locked for comments
     *         and user tries to create or delete a comment on that document.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCommentResponse> deleteComment(Consumer<DeleteCommentRequest.Builder> deleteCommentRequest) {
        return deleteComment(DeleteCommentRequest.builder().applyMutation(deleteCommentRequest).build());
    }

    /**
     * <p>
     * Deletes custom metadata from the specified resource.
     * </p>
     *
     * @param deleteCustomMetadataRequest
     * @return A Java Future containing the result of the DeleteCustomMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCustomMetadataResponse> deleteCustomMetadata(
            DeleteCustomMetadataRequest deleteCustomMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes custom metadata from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomMetadataRequest#builder()}
     * </p>
     *
     * @param deleteCustomMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteCustomMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCustomMetadataResponse> deleteCustomMetadata(
            Consumer<DeleteCustomMetadataRequest.Builder> deleteCustomMetadataRequest) {
        return deleteCustomMetadata(DeleteCustomMetadataRequest.builder().applyMutation(deleteCustomMetadataRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified document and its associated metadata.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified document and its associated metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDocumentRequest#builder()}
     * </p>
     *
     * @param deleteDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(Consumer<DeleteDocumentRequest.Builder> deleteDocumentRequest) {
        return deleteDocument(DeleteDocumentRequest.builder().applyMutation(deleteDocumentRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a document.
     * </p>
     *
     * @param deleteDocumentVersionRequest
     * @return A Java Future containing the result of the DeleteDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDocumentVersionResponse> deleteDocumentVersion(
            DeleteDocumentVersionRequest deleteDocumentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDocumentVersionRequest#builder()}
     * </p>
     *
     * @param deleteDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDocumentVersionResponse> deleteDocumentVersion(
            Consumer<DeleteDocumentVersionRequest.Builder> deleteDocumentVersionRequest) {
        return deleteDocumentVersion(DeleteDocumentVersionRequest.builder().applyMutation(deleteDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified folder and its contents.
     * </p>
     *
     * @param deleteFolderRequest
     * @return A Java Future containing the result of the DeleteFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFolderResponse> deleteFolder(DeleteFolderRequest deleteFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified folder and its contents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFolderRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFolderRequest#builder()}
     * </p>
     *
     * @param deleteFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFolderResponse> deleteFolder(Consumer<DeleteFolderRequest.Builder> deleteFolderRequest) {
        return deleteFolder(DeleteFolderRequest.builder().applyMutation(deleteFolderRequest).build());
    }

    /**
     * <p>
     * Deletes the contents of the specified folder.
     * </p>
     *
     * @param deleteFolderContentsRequest
     * @return A Java Future containing the result of the DeleteFolderContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFolderContentsResponse> deleteFolderContents(
            DeleteFolderContentsRequest deleteFolderContentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the contents of the specified folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFolderContentsRequest#builder()}
     * </p>
     *
     * @param deleteFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFolderContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFolderContentsResponse> deleteFolderContents(
            Consumer<DeleteFolderContentsRequest.Builder> deleteFolderContentsRequest) {
        return deleteFolderContents(DeleteFolderContentsRequest.builder().applyMutation(deleteFolderContentsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified list of labels from a resource.
     * </p>
     *
     * @param deleteLabelsRequest
     * @return A Java Future containing the result of the DeleteLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLabelsResponse> deleteLabels(DeleteLabelsRequest deleteLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified list of labels from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelsRequest#builder()}
     * </p>
     *
     * @param deleteLabelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLabelsResponse> deleteLabels(Consumer<DeleteLabelsRequest.Builder> deleteLabelsRequest) {
        return deleteLabels(DeleteLabelsRequest.builder().applyMutation(deleteLabelsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified subscription from the specified organization.
     * </p>
     *
     * @param deleteNotificationSubscriptionRequest
     * @return A Java Future containing the result of the DeleteNotificationSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationSubscriptionResponse> deleteNotificationSubscription(
            DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified subscription from the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteNotificationSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteNotificationSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteNotificationSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationSubscriptionResponse> deleteNotificationSubscription(
            Consumer<DeleteNotificationSubscriptionRequest.Builder> deleteNotificationSubscriptionRequest) {
        return deleteNotificationSubscription(DeleteNotificationSubscriptionRequest.builder()
                .applyMutation(deleteNotificationSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     * </p>
     * <important>
     * <p>
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention
     * policies do NOT apply to this type of deletion.
     * </p>
     * </important>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     * </p>
     * <important>
     * <p>
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention
     * policies do NOT apply to this type of deletion.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     *
     * @param describeActivitiesRequest
     * @return A Java Future containing the result of the DescribeActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeActivitiesResponse> describeActivities(DescribeActivitiesRequest describeActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivitiesRequest#builder()}
     * </p>
     *
     * @param describeActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeActivitiesResponse> describeActivities(
            Consumer<DescribeActivitiesRequest.Builder> describeActivitiesRequest) {
        return describeActivities(DescribeActivitiesRequest.builder().applyMutation(describeActivitiesRequest).build());
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesPublisher publisher = client.describeActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesPublisher publisher = client.describeActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesPublisher describeActivitiesPaginator(DescribeActivitiesRequest describeActivitiesRequest) {
        return new DescribeActivitiesPublisher(this, describeActivitiesRequest);
    }

    /**
     * <p>
     * Describes the user activities in a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesPublisher publisher = client.describeActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeActivitiesPublisher publisher = client.describeActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivities(software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivitiesRequest#builder()}
     * </p>
     *
     * @param describeActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeActivitiesPublisher describeActivitiesPaginator(
            Consumer<DescribeActivitiesRequest.Builder> describeActivitiesRequest) {
        return describeActivitiesPaginator(DescribeActivitiesRequest.builder().applyMutation(describeActivitiesRequest).build());
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     *
     * @param describeCommentsRequest
     * @return A Java Future containing the result of the DescribeComments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCommentsResponse> describeComments(DescribeCommentsRequest describeCommentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommentsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCommentsRequest#builder()}
     * </p>
     *
     * @param describeCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeComments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCommentsResponse> describeComments(
            Consumer<DescribeCommentsRequest.Builder> describeCommentsRequest) {
        return describeComments(DescribeCommentsRequest.builder().applyMutation(describeCommentsRequest).build());
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsPublisher publisher = client.describeCommentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsPublisher publisher = client.describeCommentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation.</b>
     * </p>
     *
     * @param describeCommentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsPublisher describeCommentsPaginator(DescribeCommentsRequest describeCommentsRequest) {
        return new DescribeCommentsPublisher(this, describeCommentsRequest);
    }

    /**
     * <p>
     * List all the comments for the specified document version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsPublisher publisher = client.describeCommentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeCommentsPublisher publisher = client.describeCommentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComments(software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommentsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCommentsRequest#builder()}
     * </p>
     *
     * @param describeCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCommentsPublisher describeCommentsPaginator(Consumer<DescribeCommentsRequest.Builder> describeCommentsRequest) {
        return describeCommentsPaginator(DescribeCommentsRequest.builder().applyMutation(describeCommentsRequest).build());
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     *
     * @param describeDocumentVersionsRequest
     * @return A Java Future containing the result of the DescribeDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentVersionsResponse> describeDocumentVersions(
            DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param describeDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentVersionsResponse> describeDocumentVersions(
            Consumer<DescribeDocumentVersionsRequest.Builder> describeDocumentVersionsRequest) {
        return describeDocumentVersions(DescribeDocumentVersionsRequest.builder().applyMutation(describeDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher publisher = client.describeDocumentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher publisher = client.describeDocumentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDocumentVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsPublisher describeDocumentVersionsPaginator(
            DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        return new DescribeDocumentVersionsPublisher(this, describeDocumentVersionsRequest);
    }

    /**
     * <p>
     * Retrieves the document versions for the specified document.
     * </p>
     * <p>
     * By default, only active versions are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher publisher = client.describeDocumentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher publisher = client.describeDocumentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDocumentVersions(software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param describeDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentVersionsPublisher describeDocumentVersionsPaginator(
            Consumer<DescribeDocumentVersionsRequest.Builder> describeDocumentVersionsRequest) {
        return describeDocumentVersionsPaginator(DescribeDocumentVersionsRequest.builder()
                .applyMutation(describeDocumentVersionsRequest).build());
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     *
     * @param describeFolderContentsRequest
     * @return A Java Future containing the result of the DescribeFolderContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFolderContentsResponse> describeFolderContents(
            DescribeFolderContentsRequest describeFolderContentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFolderContentsRequest#builder()}
     * </p>
     *
     * @param describeFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFolderContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFolderContentsResponse> describeFolderContents(
            Consumer<DescribeFolderContentsRequest.Builder> describeFolderContentsRequest) {
        return describeFolderContents(DescribeFolderContentsRequest.builder().applyMutation(describeFolderContentsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher publisher = client.describeFolderContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher publisher = client.describeFolderContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFolderContentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsPublisher describeFolderContentsPaginator(
            DescribeFolderContentsRequest describeFolderContentsRequest) {
        return new DescribeFolderContentsPublisher(this, describeFolderContentsRequest);
    }

    /**
     * <p>
     * Describes the contents of the specified folder, including its documents and subfolders.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more
     * results, the response includes a marker that you can use to request the next set of results. You can also request
     * initialized documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher publisher = client.describeFolderContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher publisher = client.describeFolderContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFolderContents(software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFolderContentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFolderContentsRequest#builder()}
     * </p>
     *
     * @param describeFolderContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeFolderContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFolderContentsPublisher describeFolderContentsPaginator(
            Consumer<DescribeFolderContentsRequest.Builder> describeFolderContentsRequest) {
        return describeFolderContentsPaginator(DescribeFolderContentsRequest.builder()
                .applyMutation(describeFolderContentsRequest).build());
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     *
     * @param describeGroupsRequest
     * @return A Java Future containing the result of the DescribeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupsResponse> describeGroups(DescribeGroupsRequest describeGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupsRequest#builder()}
     * </p>
     *
     * @param describeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupsResponse> describeGroups(Consumer<DescribeGroupsRequest.Builder> describeGroupsRequest) {
        return describeGroups(DescribeGroupsRequest.builder().applyMutation(describeGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsPublisher publisher = client.describeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsPublisher publisher = client.describeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describeGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsPublisher describeGroupsPaginator(DescribeGroupsRequest describeGroupsRequest) {
        return new DescribeGroupsPublisher(this, describeGroupsRequest);
    }

    /**
     * <p>
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsPublisher publisher = client.describeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeGroupsPublisher publisher = client.describeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGroups(software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupsRequest#builder()}
     * </p>
     *
     * @param describeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupsPublisher describeGroupsPaginator(Consumer<DescribeGroupsRequest.Builder> describeGroupsRequest) {
        return describeGroupsPaginator(DescribeGroupsRequest.builder().applyMutation(describeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeNotificationSubscriptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationSubscriptionsResponse> describeNotificationSubscriptions(
            DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationSubscriptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeNotificationSubscriptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationSubscriptionsResponse> describeNotificationSubscriptions(
            Consumer<DescribeNotificationSubscriptionsRequest.Builder> describeNotificationSubscriptionsRequest) {
        return describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest.builder()
                .applyMutation(describeNotificationSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsPublisher publisher = client.describeNotificationSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsPublisher publisher = client.describeNotificationSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsPublisher describeNotificationSubscriptionsPaginator(
            DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) {
        return new DescribeNotificationSubscriptionsPublisher(this, describeNotificationSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists the specified notification subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsPublisher publisher = client.describeNotificationSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeNotificationSubscriptionsPublisher publisher = client.describeNotificationSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationSubscriptions(software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationSubscriptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeNotificationSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeNotificationSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationSubscriptionsPublisher describeNotificationSubscriptionsPaginator(
            Consumer<DescribeNotificationSubscriptionsRequest.Builder> describeNotificationSubscriptionsRequest) {
        return describeNotificationSubscriptionsPaginator(DescribeNotificationSubscriptionsRequest.builder()
                .applyMutation(describeNotificationSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     *
     * @param describeResourcePermissionsRequest
     * @return A Java Future containing the result of the DescribeResourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePermissionsResponse> describeResourcePermissions(
            DescribeResourcePermissionsRequest describeResourcePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeResourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePermissionsResponse> describeResourcePermissions(
            Consumer<DescribeResourcePermissionsRequest.Builder> describeResourcePermissionsRequest) {
        return describeResourcePermissions(DescribeResourcePermissionsRequest.builder()
                .applyMutation(describeResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsPublisher publisher = client.describeResourcePermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsPublisher publisher = client.describeResourcePermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeResourcePermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsPublisher describeResourcePermissionsPaginator(
            DescribeResourcePermissionsRequest describeResourcePermissionsRequest) {
        return new DescribeResourcePermissionsPublisher(this, describeResourcePermissionsRequest);
    }

    /**
     * <p>
     * Describes the permissions of a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsPublisher publisher = client.describeResourcePermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeResourcePermissionsPublisher publisher = client.describeResourcePermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourcePermissions(software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePermissionsPublisher describeResourcePermissionsPaginator(
            Consumer<DescribeResourcePermissionsRequest.Builder> describeResourcePermissionsRequest) {
        return describeResourcePermissionsPaginator(DescribeResourcePermissionsRequest.builder()
                .applyMutation(describeResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param describeRootFoldersRequest
     * @return A Java Future containing the result of the DescribeRootFolders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRootFoldersResponse> describeRootFolders(
            DescribeRootFoldersRequest describeRootFoldersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRootFoldersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRootFoldersRequest#builder()}
     * </p>
     *
     * @param describeRootFoldersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRootFolders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRootFoldersResponse> describeRootFolders(
            Consumer<DescribeRootFoldersRequest.Builder> describeRootFoldersRequest) {
        return describeRootFolders(DescribeRootFoldersRequest.builder().applyMutation(describeRootFoldersRequest).build());
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersPublisher publisher = client.describeRootFoldersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersPublisher publisher = client.describeRootFoldersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRootFoldersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersPublisher describeRootFoldersPaginator(DescribeRootFoldersRequest describeRootFoldersRequest) {
        return new DescribeRootFoldersPublisher(this, describeRootFoldersRequest);
    }

    /**
     * <p>
     * Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>.
     * <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of
     * recycled items. This is not a valid action for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersPublisher publisher = client.describeRootFoldersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeRootFoldersPublisher publisher = client.describeRootFoldersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRootFolders(software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRootFoldersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRootFoldersRequest#builder()}
     * </p>
     *
     * @param describeRootFoldersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeRootFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRootFoldersPublisher describeRootFoldersPaginator(
            Consumer<DescribeRootFoldersRequest.Builder> describeRootFoldersRequest) {
        return describeRootFoldersPaginator(DescribeRootFoldersRequest.builder().applyMutation(describeRootFoldersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     *
     * @param describeUsersRequest
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>RequestedEntityTooLargeException The response is too large to return. The request must include a
     *         filter to reduce the size of the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>RequestedEntityTooLargeException The response is too large to return. The request must include a
     *         filter to reduce the size of the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest) {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)} operation.</b>
     * </p>
     *
     * @param describeUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>RequestedEntityTooLargeException The response is too large to return. The request must include a
     *         filter to reduce the size of the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersPublisher describeUsersPaginator(DescribeUsersRequest describeUsersRequest) {
        return new DescribeUsersPublisher(this, describeUsersRequest);
    }

    /**
     * <p>
     * Describes the specified users. You can describe all users or filter the results (for example, by status or
     * organization).
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response
     * includes a marker that you can use to request the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>RequestedEntityTooLargeException The response is too large to return. The request must include a
     *         filter to reduce the size of the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersPublisher describeUsersPaginator(Consumer<DescribeUsersRequest.Builder> describeUsersRequest) {
        return describeUsersPaginator(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action
     * for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     *
     * @param getCurrentUserRequest
     * @return A Java Future containing the result of the GetCurrentUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetCurrentUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCurrentUserResponse> getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action
     * for SigV4 (administrative API) clients.
     * </p>
     * <p>
     * This action requires an authentication token. To get an authentication token, register an application with Amazon
     * WorkDocs. For more information, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserRequest.Builder} avoiding the need to
     * create one manually via {@link GetCurrentUserRequest#builder()}
     * </p>
     *
     * @param getCurrentUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCurrentUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetCurrentUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCurrentUserResponse> getCurrentUser(Consumer<GetCurrentUserRequest.Builder> getCurrentUserRequest) {
        return getCurrentUser(GetCurrentUserRequest.builder().applyMutation(getCurrentUserRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a document.
     * </p>
     *
     * @param getDocumentRequest
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDocumentRequest#builder()}
     * </p>
     *
     * @param getDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(Consumer<GetDocumentRequest.Builder> getDocumentRequest) {
        return getDocument(GetDocumentRequest.builder().applyMutation(getDocumentRequest).build());
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * names of the parent folders.
     * </p>
     *
     * @param getDocumentPathRequest
     * @return A Java Future containing the result of the GetDocumentPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocumentPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentPathResponse> getDocumentPath(GetDocumentPathRequest getDocumentPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * names of the parent folders.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentPathRequest.Builder} avoiding the need
     * to create one manually via {@link GetDocumentPathRequest#builder()}
     * </p>
     *
     * @param getDocumentPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDocumentPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocumentPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentPathResponse> getDocumentPath(
            Consumer<GetDocumentPathRequest.Builder> getDocumentPathRequest) {
        return getDocumentPath(GetDocumentPathRequest.builder().applyMutation(getDocumentPathRequest).build());
    }

    /**
     * <p>
     * Retrieves version metadata for the specified document.
     * </p>
     *
     * @param getDocumentVersionRequest
     * @return A Java Future containing the result of the GetDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentVersionResponse> getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves version metadata for the specified document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentVersionRequest#builder()}
     * </p>
     *
     * @param getDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentVersionResponse> getDocumentVersion(
            Consumer<GetDocumentVersionRequest.Builder> getDocumentVersionRequest) {
        return getDocumentVersion(GetDocumentVersionRequest.builder().applyMutation(getDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata of the specified folder.
     * </p>
     *
     * @param getFolderRequest
     * @return A Java Future containing the result of the GetFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata of the specified folder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFolderRequest.Builder} avoiding the need to
     * create one manually via {@link GetFolderRequest#builder()}
     * </p>
     *
     * @param getFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetFolderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderResponse> getFolder(Consumer<GetFolderRequest.Builder> getFolderRequest) {
        return getFolder(GetFolderRequest.builder().applyMutation(getFolderRequest).build());
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * parent folder names.
     * </p>
     *
     * @param getFolderPathRequest
     * @return A Java Future containing the result of the GetFolderPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetFolderPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderPathResponse> getFolderPath(GetFolderPathRequest getFolderPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     * </p>
     * <p>
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes
     * the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the
     * parent folder names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFolderPathRequest.Builder} avoiding the need to
     * create one manually via {@link GetFolderPathRequest#builder()}
     * </p>
     *
     * @param getFolderPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFolderPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetFolderPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderPathResponse> getFolderPath(Consumer<GetFolderPathRequest.Builder> getFolderPathRequest) {
        return getFolderPath(GetFolderPathRequest.builder().applyMutation(getFolderPathRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of resources, including folders and documents. The only <code>CollectionType</code>
     * supported is <code>SHARED_WITH_ME</code>.
     * </p>
     *
     * @param getResourcesRequest
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcesResponse> getResources(GetResourcesRequest getResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of resources, including folders and documents. The only <code>CollectionType</code>
     * supported is <code>SHARED_WITH_ME</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.GetResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.GetResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcesResponse> getResources(Consumer<GetResourcesRequest.Builder> getResourcesRequest) {
        return getResources(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * Creates a new document object and version object.
     * </p>
     * <p>
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when
     * creating a new version of an existing document. This is the first step to upload a document. Next, upload the
     * document to the URL returned from the call, and then call <a>UpdateDocumentVersion</a>.
     * </p>
     * <p>
     * To cancel the document upload, call <a>AbortDocumentVersionUpload</a>.
     * </p>
     *
     * @param initiateDocumentVersionUploadRequest
     * @return A Java Future containing the result of the InitiateDocumentVersionUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>StorageLimitExceededException The storage limit has been exceeded.</li>
     *         <li>StorageLimitWillExceedException The storage limit will be exceeded.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DraftUploadOutOfSyncException This exception is thrown when a valid checkout ID is not presented on
     *         document version upload calls for a document that has been checked out from Web client.</li>
     *         <li>ResourceAlreadyCheckedOutException The resource is already checked out.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.InitiateDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InitiateDocumentVersionUploadResponse> initiateDocumentVersionUpload(
            InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document object and version object.
     * </p>
     * <p>
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when
     * creating a new version of an existing document. This is the first step to upload a document. Next, upload the
     * document to the URL returned from the call, and then call <a>UpdateDocumentVersion</a>.
     * </p>
     * <p>
     * To cancel the document upload, call <a>AbortDocumentVersionUpload</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateDocumentVersionUploadRequest.Builder}
     * avoiding the need to create one manually via {@link InitiateDocumentVersionUploadRequest#builder()}
     * </p>
     *
     * @param initiateDocumentVersionUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the InitiateDocumentVersionUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>StorageLimitExceededException The storage limit has been exceeded.</li>
     *         <li>StorageLimitWillExceedException The storage limit will be exceeded.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DraftUploadOutOfSyncException This exception is thrown when a valid checkout ID is not presented on
     *         document version upload calls for a document that has been checked out from Web client.</li>
     *         <li>ResourceAlreadyCheckedOutException The resource is already checked out.</li>
     *         <li>InvalidPasswordException The password is invalid.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.InitiateDocumentVersionUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InitiateDocumentVersionUploadResponse> initiateDocumentVersionUpload(
            Consumer<InitiateDocumentVersionUploadRequest.Builder> initiateDocumentVersionUploadRequest) {
        return initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest.builder()
                .applyMutation(initiateDocumentVersionUploadRequest).build());
    }

    /**
     * <p>
     * Removes all the permissions from the specified resource.
     * </p>
     *
     * @param removeAllResourcePermissionsRequest
     * @return A Java Future containing the result of the RemoveAllResourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RemoveAllResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAllResourcePermissionsResponse> removeAllResourcePermissions(
            RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all the permissions from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAllResourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveAllResourcePermissionsRequest#builder()}
     * </p>
     *
     * @param removeAllResourcePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RemoveAllResourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RemoveAllResourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAllResourcePermissionsResponse> removeAllResourcePermissions(
            Consumer<RemoveAllResourcePermissionsRequest.Builder> removeAllResourcePermissionsRequest) {
        return removeAllResourcePermissions(RemoveAllResourcePermissionsRequest.builder()
                .applyMutation(removeAllResourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Removes the permission for the specified principal from the specified resource.
     * </p>
     *
     * @param removeResourcePermissionRequest
     * @return A Java Future containing the result of the RemoveResourcePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RemoveResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveResourcePermissionResponse> removeResourcePermission(
            RemoveResourcePermissionRequest removeResourcePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the permission for the specified principal from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveResourcePermissionRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveResourcePermissionRequest#builder()}
     * </p>
     *
     * @param removeResourcePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveResourcePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RemoveResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveResourcePermissionResponse> removeResourcePermission(
            Consumer<RemoveResourcePermissionRequest.Builder> removeResourcePermissionRequest) {
        return removeResourcePermission(RemoveResourcePermissionRequest.builder().applyMutation(removeResourcePermissionRequest)
                .build());
    }

    /**
     * <p>
     * Recovers a deleted version of an Amazon WorkDocs document.
     * </p>
     *
     * @param restoreDocumentVersionsRequest
     * @return A Java Future containing the result of the RestoreDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RestoreDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RestoreDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDocumentVersionsResponse> restoreDocumentVersions(
            RestoreDocumentVersionsRequest restoreDocumentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recovers a deleted version of an Amazon WorkDocs document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDocumentVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param restoreDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.RestoreDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RestoreDocumentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDocumentVersionsResponse> restoreDocumentVersions(
            Consumer<RestoreDocumentVersionsRequest.Builder> restoreDocumentVersionsRequest) {
        return restoreDocumentVersions(RestoreDocumentVersionsRequest.builder().applyMutation(restoreDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     *
     * @param searchResourcesRequest
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(SearchResourcesRequest searchResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(
            Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResources(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation.</b>
     * </p>
     *
     * @param searchResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest) {
        return new SearchResourcesPublisher(this, searchResourcesRequest);
    }

    /**
     * <p>
     * Searches metadata and the content of folders, documents, document versions, and comments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workdocs.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResourcesPaginator(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of a document. The user must have access to both the document and its parent
     * folder, if applicable.
     * </p>
     *
     * @param updateDocumentRequest
     * @return A Java Future containing the result of the UpdateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDocumentResponse> updateDocument(UpdateDocumentRequest updateDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of a document. The user must have access to both the document and its parent
     * folder, if applicable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDocumentRequest#builder()}
     * </p>
     *
     * @param updateDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDocumentResponse> updateDocument(Consumer<UpdateDocumentRequest.Builder> updateDocumentRequest) {
        return updateDocument(UpdateDocumentRequest.builder().applyMutation(updateDocumentRequest).build());
    }

    /**
     * <p>
     * Changes the status of the document version to ACTIVE.
     * </p>
     * <p>
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the
     * client uploads the document to an S3-presigned URL returned by <a>InitiateDocumentVersionUpload</a>.
     * </p>
     *
     * @param updateDocumentVersionRequest
     * @return A Java Future containing the result of the UpdateDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDocumentVersionResponse> updateDocumentVersion(
            UpdateDocumentVersionRequest updateDocumentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the status of the document version to ACTIVE.
     * </p>
     * <p>
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the
     * client uploads the document to an S3-presigned URL returned by <a>InitiateDocumentVersionUpload</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDocumentVersionRequest#builder()}
     * </p>
     *
     * @param updateDocumentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDocumentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>InvalidOperationException The operation is invalid.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateDocumentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDocumentVersionResponse> updateDocumentVersion(
            Consumer<UpdateDocumentVersionRequest.Builder> updateDocumentVersionRequest) {
        return updateDocumentVersion(UpdateDocumentVersionRequest.builder().applyMutation(updateDocumentVersionRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its
     * parent folder, if applicable.
     * </p>
     *
     * @param updateFolderRequest
     * @return A Java Future containing the result of the UpdateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFolderResponse> updateFolder(UpdateFolderRequest updateFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its
     * parent folder, if applicable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFolderRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFolderRequest#builder()}
     * </p>
     *
     * @param updateFolderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>EntityAlreadyExistsException The resource already exists.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>ConflictingOperationException Another operation is in progress on the resource that conflicts with
     *         the current operation.</li>
     *         <li>ConcurrentModificationException The resource hierarchy is changing.</li>
     *         <li>LimitExceededException The maximum of 100,000 files and folders under the parent folder has been
     *         exceeded.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFolderResponse> updateFolder(Consumer<UpdateFolderRequest.Builder> updateFolderRequest) {
        return updateFolder(UpdateFolderRequest.builder().applyMutation(updateFolderRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the
     * Amazon WorkDocs site.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>IllegalUserStateException The user is undergoing transfer of ownership.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DeactivatingLastSystemUserException The last user in the organization is being deactivated.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the
     * Amazon WorkDocs site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workdocs.model.UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotExistsException The resource does not exist.</li>
     *         <li>UnauthorizedOperationException The operation is not permitted.</li>
     *         <li>UnauthorizedResourceAccessException The caller does not have access to perform the action on the
     *         resource.</li>
     *         <li>IllegalUserStateException The user is undergoing transfer of ownership.</li>
     *         <li>ProhibitedStateException The specified document version is not in the INITIALIZED state.</li>
     *         <li>FailedDependencyException The Directory Service cannot reach an on-premises instance. Or a dependency
     *         under the control of the organization is failing, such as a connected Active Directory.</li>
     *         <li>ServiceUnavailableException One or more of the dependencies is unavailable.</li>
     *         <li>DeactivatingLastSystemUserException The last user in the organization is being deactivated.</li>
     *         <li>InvalidArgumentException The pagination marker or limit fields are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkDocsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkDocsAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    @Override
    default WorkDocsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkDocsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkDocsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkDocsAsyncClient}.
     */
    static WorkDocsAsyncClientBuilder builder() {
        return new DefaultWorkDocsAsyncClientBuilder();
    }
}
