/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.Subscription;

public class DescribeNotificationSubscriptionsPublisher
implements SdkPublisher<DescribeNotificationSubscriptionsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeNotificationSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNotificationSubscriptionsPublisher(WorkDocsAsyncClient client, DescribeNotificationSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNotificationSubscriptionsPublisher(WorkDocsAsyncClient client, DescribeNotificationSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNotificationSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNotificationSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscription> subscriptions() {
        Function<DescribeNotificationSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNotificationSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNotificationSubscriptionsResponseFetcher
    implements AsyncPageFetcher<DescribeNotificationSubscriptionsResponse> {
        private DescribeNotificationSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeNotificationSubscriptionsResponse> nextPage(DescribeNotificationSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationSubscriptionsPublisher.this.client.describeNotificationSubscriptions(DescribeNotificationSubscriptionsPublisher.this.firstRequest);
            }
            return DescribeNotificationSubscriptionsPublisher.this.client.describeNotificationSubscriptions((DescribeNotificationSubscriptionsRequest)((Object)DescribeNotificationSubscriptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

