/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentVersionResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, GetDocumentVersionResponse> {
    private static final SdkField<DocumentVersionMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(GetDocumentVersionResponse.getter(GetDocumentVersionResponse::metadata)).setter(GetDocumentVersionResponse.setter(Builder::metadata)).constructor(DocumentVersionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomMetadata").getter(GetDocumentVersionResponse.getter(GetDocumentVersionResponse::customMetadata)).setter(GetDocumentVersionResponse.setter(Builder::customMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, CUSTOM_METADATA_FIELD));
    private final DocumentVersionMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetDocumentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public final DocumentVersionMetadata metadata() {
        return this.metadata;
    }

    public final boolean hasCustomMetadata() {
        return this.customMetadata != null && !(this.customMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomMetadata() ? this.customMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentVersionResponse)) {
            return false;
        }
        GetDocumentVersionResponse other = (GetDocumentVersionResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && this.hasCustomMetadata() == other.hasCustomMetadata() && Objects.equals(this.customMetadata(), other.customMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetDocumentVersionResponse").add("Metadata", (Object)this.metadata()).add("CustomMetadata", this.hasCustomMetadata() ? this.customMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "CustomMetadata": {
                return Optional.ofNullable(clazz.cast(this.customMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentVersionResponse, T> g) {
        return obj -> g.apply((GetDocumentVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private DocumentVersionMetadata metadata;
        private Map<String, String> customMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentVersionResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.customMetadata(model.customMetadata);
        }

        public final DocumentVersionMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentVersionMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(DocumentVersionMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Map<String, String> getCustomMetadata() {
            if (this.customMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customMetadata;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        @Override
        public GetDocumentVersionResponse build() {
            return new GetDocumentVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentVersionResponse> {
        public Builder metadata(DocumentVersionMetadata var1);

        default public Builder metadata(Consumer<DocumentVersionMetadata.Builder> metadata) {
            return this.metadata((DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder customMetadata(Map<String, String> var1);
    }
}

