/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the path information of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePath implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePath.Builder, ResourcePath> {
    private static final SdkField<List<ResourcePathComponent>> COMPONENTS_FIELD = SdkField
            .<List<ResourcePathComponent>> builder(MarshallingType.LIST)
            .memberName("Components")
            .getter(getter(ResourcePath::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResourcePathComponent> components;

    private ResourcePath(BuilderImpl builder) {
        this.components = builder.components;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components of the resource path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return The components of the resource path.
     */
    public final List<ResourcePathComponent> components() {
        return components;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath) obj;
        return hasComponents() == other.hasComponents() && Objects.equals(components(), other.components());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePath").add("Components", hasComponents() ? components() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Components":
            return Optional.ofNullable(clazz.cast(components()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePath, T> g) {
        return obj -> g.apply((ResourcePath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePath> {
        /**
         * <p>
         * The components of the resource path.
         * </p>
         * 
         * @param components
         *        The components of the resource path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ResourcePathComponent> components);

        /**
         * <p>
         * The components of the resource path.
         * </p>
         * 
         * @param components
         *        The components of the resource path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ResourcePathComponent... components);

        /**
         * <p>
         * The components of the resource path.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.ResourcePathComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workdocs.model.ResourcePathComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.ResourcePathComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ResourcePathComponent>)}.
         * 
         * @param components
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.ResourcePathComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(java.util.Collection<ResourcePathComponent>)
         */
        Builder components(Consumer<ResourcePathComponent.Builder>... components);
    }

    static final class BuilderImpl implements Builder {
        private List<ResourcePathComponent> components = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePath model) {
            components(model.components);
        }

        public final List<ResourcePathComponent.Builder> getComponents() {
            List<ResourcePathComponent.Builder> result = ResourcePathComponentListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ResourcePathComponent.BuilderImpl> components) {
            this.components = ResourcePathComponentListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ResourcePathComponent... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ResourcePathComponent.Builder>... components) {
            components(Stream.of(components).map(c -> ResourcePathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourcePath build() {
            return new ResourcePath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
